/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.script.Bindings;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.json.IJsonBindingsBacked;
import manifold.api.json.IJsonList;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonModel;
import manifold.api.json.Loader;
import manifold.api.json.Requester;
import manifold.api.type.JavaTypeManifold;
import manifold.ext.DataBindings;
import manifold.ext.RuntimeMethods;
import manifold.ext.api.IProxyFactory;
import manifold.ext.api.Structural;
import manifold.util.JsonUtil;
import manifold.util.ManClassUtil;

public abstract class AbstractJsonTypeManifold<T extends JsonModel>
extends JavaTypeManifold<T> {
    private static final Set<String> API_INNER_CLASS_NAMES = new HashSet<String>(Arrays.asList("Proxy", "ProxyFactory", "Builder", "Copier"));

    public boolean isInnerType(String topLevel, String relativeInner) {
        IJsonParentType type;
        JsonModel model = (JsonModel)this.getModel(topLevel);
        IJsonParentType iJsonParentType = type = model == null ? null : model.getType();
        if (type == null) {
            return false;
        }
        if (this.isApiInnerClass(topLevel, relativeInner)) {
            return true;
        }
        IJsonParentType csr = type;
        StringBuilder enclosing = new StringBuilder(topLevel);
        StringTokenizer tokenizer = new StringTokenizer(relativeInner, ".");
        while (tokenizer.hasMoreTokens()) {
            String childName = tokenizer.nextToken();
            IJsonType child = csr.findChild(childName);
            if (child instanceof IJsonParentType) {
                csr = (IJsonParentType)child;
                enclosing.append('.').append(childName);
                continue;
            }
            if (child == null) {
                return this.isApiInnerClass(enclosing.toString(), childName);
            }
            return false;
        }
        return true;
    }

    protected boolean isApiInnerClass(String topLevel, String relativeInner) {
        return API_INNER_CLASS_NAMES.contains(relativeInner);
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, String existing, T model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(ManClassUtil.getPackage((String)topLevelFqn)).append(";\n\n").append("import ").append(Json.class.getName()).append(";\n").append("import ").append(JsonUtil.class.getName()).append(";\n").append("import ").append(Bindings.class.getName()).append(";\n").append("import ").append(Loader.class.getName()).append(";\n").append("import ").append(Requester.class.getName()).append(";\n").append("import ").append(List.class.getName()).append(";\n").append("import ").append(ArrayList.class.getName()).append(";\n").append("import ").append(Map.class.getName()).append(";\n").append("import ").append(DataBindings.class.getName()).append(";\n").append("import ").append(IJsonBindingsBacked.class.getName()).append(";\n").append("import ").append(IJsonList.class.getName()).append(";\n").append("import ").append(Structural.class.getName()).append(";\n").append("import ").append(IProxyFactory.class.getName()).append(";\n").append("import ").append(RuntimeMethods.class.getName()).append(";\n\n");
        ((JsonModel)((Object)model)).report(errorHandler);
        ((JsonModel)((Object)model)).getType().render(sb, 0, true);
        return sb.toString();
    }
}

