/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.StringTokenizer;
import javax.script.Bindings;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.json.IJsonBindingsBacked;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonModel;
import manifold.api.type.JavaTypeManifold;
import manifold.ext.DataBindings;
import manifold.ext.RuntimeMethods;
import manifold.ext.api.Structural;
import manifold.util.ManClassUtil;

public abstract class AbstractJsonTypeManifold<T extends JsonModel>
extends JavaTypeManifold<T> {
    public boolean isInnerType(String topLevel, String relativeInner) {
        IJsonParentType type;
        JsonModel model = (JsonModel)this.getModel(topLevel);
        IJsonParentType iJsonParentType = type = model == null ? null : model.getType();
        if (type == null) {
            return false;
        }
        IJsonParentType csr = type;
        StringTokenizer tokenizer = new StringTokenizer(relativeInner, ".");
        while (tokenizer.hasMoreTokens()) {
            String childName = tokenizer.nextToken();
            IJsonType child = csr.findChild(childName);
            if (child instanceof IJsonParentType) {
                csr = (IJsonParentType)child;
                continue;
            }
            return false;
        }
        return true;
    }

    protected String contribute(JavaFileManager.Location location, String topLevelFqn, String existing, T model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(ManClassUtil.getPackage((String)topLevelFqn)).append(";\n\n").append("import ").append(Json.class.getName()).append(";\n").append("import ").append(Bindings.class.getName()).append(";\n").append("import ").append(DataBindings.class.getName()).append(";\n").append("import ").append(IJsonBindingsBacked.class.getName()).append(";\n").append("import ").append(Structural.class.getName()).append(";\n").append("import ").append(RuntimeMethods.class.getName()).append(";\n\n");
        ((JsonModel)((Object)model)).report(errorHandler);
        ((JsonModel)((Object)model)).getType().render(sb, 0, true);
        return sb.toString();
    }
}

