/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonListType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonEnumType;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.json.schema.LazyRefJsonType;
import manifold.api.json.schema.TypeAttributes;
import manifold.api.type.ActualName;
import manifold.api.type.SourcePosition;
import manifold.api.type.TypeReference;
import manifold.ext.RuntimeMethods;
import manifold.ext.api.IBindingsBacked;
import manifold.json.extensions.java.net.URL.ManUrlExt;
import manifold.json.extensions.javax.script.Bindings.ManBindingsExt;
import manifold.util.JsonUtil;
import manifold.util.ManEscapeUtil;
import manifold.util.ManStringUtil;

public class JsonStructureType
extends JsonSchemaType {
    private static final String FIELD_FILE_URL = "__FILE_URL_";
    private final State _state = new State();

    public JsonStructureType(JsonSchemaType parent, URL source, String name, TypeAttributes attr) {
        super(name, source, parent, attr);
        this._state._membersByName = new LinkedHashMap();
        this._state._memberLocations = new LinkedHashMap();
        this._state._innerTypes = Collections.emptyMap();
        this._state._unionMembers = Collections.emptyMap();
        this._state._superTypes = Collections.emptyList();
        this._state._required = Collections.emptySet();
    }

    @Override
    protected void resolveRefsImpl() {
        IJsonType type;
        super.resolveRefsImpl();
        for (Map.Entry entry : new LinkedHashSet(this._state._membersByName.entrySet())) {
            type = (IJsonType)entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            this._state._membersByName.put(entry.getKey(), ((LazyRefJsonType)type).resolve());
        }
        for (Map.Entry entry : new LinkedHashSet(this._state._unionMembers.entrySet())) {
            LinkedHashSet<IJsonType> types = new LinkedHashSet<IJsonType>();
            for (IJsonType type2 : (Set)entry.getValue()) {
                if (type2 instanceof JsonSchemaType) {
                    ((JsonSchemaType)type2).resolveRefs();
                } else if (type2 instanceof LazyRefJsonType) {
                    type2 = ((LazyRefJsonType)type2).resolve();
                }
                types.add(type2);
            }
            this._state._unionMembers.put(entry.getKey(), types);
        }
        for (Map.Entry entry : new LinkedHashSet(this._state._innerTypes.entrySet())) {
            type = (IJsonType)entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            type = ((LazyRefJsonType)type).resolve();
            this._state._innerTypes.put(entry.getKey(), (IJsonParentType)type);
        }
    }

    private boolean isSuperParentMe(IJsonType type) {
        return type.getParent() == this || type.getParent() != null && type.getParent().getName().equals("definitions") && type.getParent().getParent().getName().equals(this.getName());
    }

    @Override
    public String getFqn() {
        String result = "";
        if (!this.isParentRoot()) {
            result = this.getParent().getFqn();
            result = result + '.';
        }
        return result + JsonUtil.makeIdentifier((String)this.getLabel());
    }

    public void addSuper(IJsonType superType) {
        if (this._state._superTypes.isEmpty()) {
            this._state._superTypes = new ArrayList();
        }
        this._state._superTypes.add(superType);
    }

    private List<IJsonType> getSuperTypes() {
        if (!this._state._superTypes.isEmpty() && this._state._superTypes.stream().anyMatch(e -> e instanceof LazyRefJsonType)) {
            ArrayList<IJsonType> resolved = new ArrayList<IJsonType>();
            for (IJsonType type : this._state._superTypes) {
                if (type instanceof LazyRefJsonType) {
                    type = ((LazyRefJsonType)type).resolve();
                }
                resolved.add(type);
            }
            this._state._superTypes = resolved;
        }
        return this._state._superTypes;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        if (this._state._innerTypes.isEmpty()) {
            this._state._innerTypes = new HashMap();
        }
        this._state._innerTypes.put(name, type);
    }

    @Override
    public IJsonType findChild(String name) {
        List<IJsonType> definitions;
        IJsonParentType innerType = (IJsonParentType)this._state._innerTypes.get(name);
        if (innerType == null && (definitions = this.getDefinitions()) != null) {
            for (IJsonType child : definitions) {
                if (!child.getIdentifier().equals(name)) continue;
                innerType = (IJsonParentType)child;
                break;
            }
        }
        if (innerType == null) {
            for (Set constituents : this._state._unionMembers.values()) {
                for (IJsonType c : constituents) {
                    if (c.getIdentifier().equals(name)) {
                        innerType = (IJsonParentType)c;
                        continue;
                    }
                    while (c instanceof JsonListType) {
                        c = ((JsonListType)c).getComponentType();
                    }
                    if (!c.getIdentifier().equals(name)) continue;
                    innerType = (IJsonParentType)c;
                }
            }
        }
        return innerType;
    }

    public Map<String, IJsonType> getMembers() {
        return this._state._membersByName;
    }

    private Map<String, IJsonType> getAllMembers() {
        HashMap<String, IJsonType> allMembers = new HashMap<String, IJsonType>(this._state._membersByName);
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType)) continue;
            allMembers.putAll(((JsonStructureType)extended).getMembers());
        }
        return allMembers;
    }

    protected Map<String, Token> getMemberLocations() {
        return this._state._memberLocations;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._state._innerTypes;
    }

    public void addMember(String name, IJsonType type, Token token) {
        IJsonType existingType = (IJsonType)this._state._membersByName.get(name);
        if (existingType != null && existingType != type) {
            if (type == DynamicType.instance()) {
                return;
            }
            if (existingType != DynamicType.instance() && (type = Json.mergeTypes(existingType, type)) == null) {
                throw new RuntimeException("Types disagree for '" + name + "' from array data: " + existingType.getName() + " vs: " + existingType.getName());
            }
        }
        this._state._membersByName.put(name, type);
        this._state._memberLocations.put(name, token);
        this.addUnionMemberAccess(name, type);
    }

    private void addUnionMemberAccess(String name, IJsonType type) {
        if (type instanceof JsonUnionType) {
            for (IJsonType iJsonType : ((JsonUnionType)type).getConstituents()) {
                if (this._state._unionMembers.isEmpty()) {
                    this._state._unionMembers = new HashMap();
                }
                Set union = this._state._unionMembers.computeIfAbsent(name, k -> new LinkedHashSet());
                union.add(iJsonType);
            }
        } else if (type instanceof JsonListType) {
            this.addUnionMemberAccess(name, ((JsonListType)type).getComponentType());
        }
    }

    private IJsonType findMemberType(String name) {
        return (IJsonType)this._state._membersByName.get(name);
    }

    public Token getToken() {
        return this._state._token;
    }

    public void setToken(Token token) {
        this._state._token = token;
    }

    @Override
    public IJsonType merge(IJsonType that) {
        if (!(that instanceof JsonStructureType) || that instanceof JsonEnumType) {
            return null;
        }
        JsonStructureType other = (JsonStructureType)that;
        if (!this.getName().equals(other.getName())) {
            return null;
        }
        TypeAttributes mergedTypeAttributes = this.getTypeAttributes().blendWith(other.getTypeAttributes());
        JsonStructureType mergedType = new JsonStructureType(this.getParent(), this.getFile(), this.getName(), mergedTypeAttributes);
        for (Map.Entry e : this._state._membersByName.entrySet()) {
            String memberName = (String)e.getKey();
            IJsonType memberType = other.findMemberType(memberName);
            memberType = memberType != null ? Json.mergeTypes((IJsonType)e.getValue(), memberType) : (IJsonType)e.getValue();
            if (memberType != null) {
                mergedType.addMember(memberName, memberType, (Token)this._state._memberLocations.get(memberName));
                continue;
            }
            return null;
        }
        if (!this.mergeInnerTypes(other, mergedType, this._state._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        JsonEnumType enumType = this.getAllOfEnumType();
        if (enumType != null) {
            enumType.render(sb, indent, mutable);
            return;
        }
        if (this.getParent() != null) {
            sb.append('\n');
        }
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name, false);
        if (!(this.getParent() instanceof JsonStructureType && ((JsonStructureType)this.getParent()).addSourcePositionAnnotation(sb, indent, identifier) || this.getToken() == null)) {
            this.addSourcePositionAnnotation(sb, indent, identifier, this.getToken());
        }
        this.indent(sb, indent);
        sb.append("@Structural\n");
        this.indent(sb, indent);
        sb.append("public interface ").append(identifier).append(this.addSuperTypes(sb)).append(" {\n");
        this.renderFileField(sb, indent + 2);
        this.renderStaticMembers(sb, indent + 2);
        this.renderProperties(sb, indent, mutable);
        this.addAdditionalPropertiesMethods(sb, indent, mutable);
        this.renderInnerTypes(sb, indent, mutable);
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void renderInnerTypes(StringBuilder sb, int indent, boolean mutable) {
        this.addBuilder(sb, indent);
        for (IJsonParentType child : this._state._innerTypes.values()) {
            child.render(sb, indent + 2, mutable);
        }
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null) {
            for (IJsonType child : definitions) {
                if (!(child instanceof IJsonParentType)) continue;
                ((IJsonParentType)child).render(sb, indent + 2, mutable);
            }
        }
    }

    private void renderProperties(StringBuilder sb, int indent, boolean mutable) {
        this.renderProperties(sb, indent, mutable, new HashSet<String>());
    }

    private void renderProperties(StringBuilder sb, int indent, boolean mutable, Set<String> rendered) {
        for (String key : this._state._membersByName.keySet()) {
            boolean isReadOnly;
            boolean isWriteOnly;
            if (rendered.contains(key)) continue;
            rendered.add(key);
            sb.append('\n');
            IJsonType type = (IJsonType)this._state._membersByName.get(key);
            String propertyType = this.getPropertyType(type);
            boolean bl = isWriteOnly = type.getTypeAttributes().getWriteOnly() != null && type.getTypeAttributes().getWriteOnly() != false;
            if (!isWriteOnly) {
                this.addGetter(sb, indent, type, key, propertyType);
            }
            boolean bl2 = isReadOnly = type.getTypeAttributes().getReadOnly() != null && type.getTypeAttributes().getReadOnly() != false;
            if (mutable && !isReadOnly) {
                this.addSetter(sb, indent, key, propertyType);
            }
            this.renderUnionAccessors(sb, indent, mutable, key, type);
        }
        for (IJsonType superType : this.getSuperTypes()) {
            if (!this.isSuperParentMe(superType) || superType instanceof JsonEnumType) continue;
            ((JsonStructureType)superType).renderProperties(sb, indent, mutable, rendered);
        }
    }

    private void addGetter(StringBuilder sb, int indent, IJsonType type, String key, String propertyType) {
        this.addSourcePositionAnnotation(sb, indent + 2, key);
        String identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
        this.indent(sb, indent + 2);
        sb.append("default " + propertyType + " get" + identifier + "() {\n");
        this.indent(sb, indent + 4);
        if (type instanceof JsonListType || propertyType.indexOf(62) > 0) {
            sb.append("return (" + propertyType + ")getBindings().get(\"" + key + "\");\n");
        } else {
            sb.append("return (" + propertyType + ")").append(RuntimeMethods.class.getSimpleName()).append(".coerce(getBindings().get(\"" + key + "\"), " + propertyType + ".class);\n");
        }
        this.indent(sb, indent + 2);
        sb.append("}\n");
    }

    private void addSetter(StringBuilder sb, int indent, String key, String propertyType) {
        this.addSourcePositionAnnotation(sb, indent + 2, key);
        String identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
        this.indent(sb, indent + 2);
        sb.append("default void set" + identifier + "(").append(propertyType).append(" $value) {\n");
        this.indent(sb, indent + 4);
        sb.append("getBindings().put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue(getBindings(), $value));\n");
        this.indent(sb, indent + 2);
        sb.append("}\n");
    }

    private void addAdditionalPropertiesMethods(StringBuilder sb, int indent, boolean mutable) {
        boolean isPatternProperties;
        Object addProps = this.getTypeAttributes().getAdditionalProperties();
        boolean isAdditionalProperties = addProps == null || !(addProps instanceof Boolean) || (Boolean)addProps != false;
        boolean bl = isPatternProperties = this.getTypeAttributes().getPatternProperties() != null && !this.getTypeAttributes().getPatternProperties().isEmpty();
        if (!isAdditionalProperties && !isPatternProperties) {
            return;
        }
        this.indent(sb, indent + 2);
        sb.append("default Object get(String $name) {\n");
        this.indent(sb, indent + 4);
        sb.append("return getBindings().get($name);\n");
        this.indent(sb, indent + 2);
        sb.append("}\n");
        if (mutable) {
            this.indent(sb, indent + 2);
            sb.append("default Object put(String $name, Object $value) {\n");
            this.indent(sb, indent + 4);
            sb.append("return getBindings().put($name, $value);\n");
            this.indent(sb, indent + 2);
            sb.append("}\n");
        }
    }

    private void renderUnionAccessors(StringBuilder sb, int indent, boolean mutable, String key, IJsonType type) {
        if (this.isCollapsedUnionEnum(type)) {
            return;
        }
        Set union = (Set)this._state._unionMembers.get(key);
        if (union != null) {
            for (IJsonType constituentType : union) {
                sb.append('\n');
                String specificPropertyType = this.getConstituentQn(constituentType, type);
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                String identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                String unionName = this.makeMemberIdentifier(constituentType);
                sb.append("default " + specificPropertyType + "  get").append(identifier).append("As").append(unionName).append("() {\n");
                this.indent(sb, indent + 4);
                if (constituentType instanceof JsonListType || specificPropertyType.indexOf(62) > 0) {
                    sb.append("return (" + specificPropertyType + ")getBindings().get(\"" + key + "\");\n");
                } else {
                    sb.append("return (" + specificPropertyType + ")").append(RuntimeMethods.class.getSimpleName()).append(".coerce(getBindings().get(\"" + key + "\"), " + specificPropertyType + ".class);\n");
                }
                this.indent(sb, indent + 2);
                sb.append("}\n");
                if (!mutable) continue;
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                sb.append("default void set").append(identifier).append("As").append(unionName).append("(").append(specificPropertyType).append(" $value) {\n");
                this.indent(sb, indent + 4);
                sb.append("getBindings().put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue(getBindings(), $value));\n");
                this.indent(sb, indent + 2);
                sb.append("}\n");
            }
        }
    }

    private boolean isCollapsedUnionEnum(IJsonType type) {
        while (type instanceof JsonListType) {
            type = ((JsonListType)type).getComponentType();
        }
        JsonEnumType enumType = type instanceof JsonUnionType ? ((JsonUnionType)type).getCollapsedEnumType() : null;
        return enumType != null;
    }

    private JsonEnumType getAllOfEnumType() {
        if (!this.getMembers().isEmpty()) {
            return null;
        }
        if (this.getSuperTypes().stream().allMatch(e -> e instanceof JsonEnumType)) {
            return this.makeEnumType(this.getSuperTypes());
        }
        return null;
    }

    protected JsonEnumType makeEnumType(Collection<? extends IJsonType> types) {
        JsonEnumType result = null;
        JsonEnumType prev = null;
        for (IJsonType iJsonType : types) {
            prev = result = new JsonEnumType((JsonEnumType)iJsonType, prev, this.getParent(), this.getName());
        }
        return result;
    }

    private String getConstituentQn(IJsonType constituentType, IJsonType propertyType) {
        String qn = this.getConstituentQn(constituentType);
        while (propertyType instanceof JsonListType) {
            qn = List.class.getTypeName() + '<' + qn + '>';
            propertyType = ((JsonListType)propertyType).getComponentType();
        }
        return qn;
    }

    private String getPropertyType(IJsonType propertyType) {
        JsonEnumType enumType;
        String name = propertyType instanceof JsonListType ? List.class.getTypeName() + '<' + this.getPropertyType(((JsonListType)propertyType).getComponentType()) + '>' : (propertyType instanceof JsonUnionType ? ((enumType = ((JsonUnionType)propertyType).getCollapsedEnumType()) != null ? this.getNameRelativeFromMe(enumType) : Object.class.getSimpleName()) : (propertyType instanceof JsonSchemaType ? this.getNameRelativeFromMe(propertyType) : propertyType.getIdentifier()));
        return name;
    }

    private String getNameRelativeFromMe(IJsonType type) {
        IJsonType parent = this.getParentFromMe(type);
        if (parent == null) {
            return type.getIdentifier();
        }
        return this.getNameRelativeFromMe(parent) + '.' + type.getIdentifier();
    }

    private IJsonType getParentFromMe(IJsonType type) {
        IJsonParentType parent = type.getParent();
        if (parent != null) {
            if (parent instanceof JsonListType) {
                return this.getParentFromMe(parent);
            }
            if (parent.getIdentifier().equals("definitions")) {
                return this.getParentFromMe(parent);
            }
            if (parent == this) {
                return null;
            }
        }
        return parent;
    }

    private String getConstituentQn(IJsonType constituentType) {
        if (constituentType instanceof JsonListType) {
            return List.class.getTypeName() + '<' + this.getConstituentQn(((JsonListType)constituentType).getComponentType()) + '>';
        }
        String qn = "";
        if (constituentType.getParent() instanceof JsonUnionType) {
            qn = this.getConstituentQn(constituentType.getParent()) + '.';
        }
        return qn + constituentType.getIdentifier();
    }

    private IJsonType getConstituentQnComponent(IJsonType constituentType) {
        if (constituentType instanceof JsonListType) {
            return this.getConstituentQnComponent(((JsonListType)constituentType).getComponentType());
        }
        return constituentType;
    }

    private void renderFileField(StringBuilder sb, int indent) {
        this.renderFileField(sb, indent, null);
    }

    protected void renderFileField(StringBuilder sb, int indent, String modifiers) {
        this.indent(sb, indent);
        sb.append(modifiers == null ? "" : modifiers + " ").append("String ").append(FIELD_FILE_URL).append(" = \"").append(this.getFile() == null ? "null" : this.getFile().toString()).append("\";\n");
    }

    private String addSuperTypes(StringBuilder sb) {
        sb.append(" extends ").append(IBindingsBacked.class.getSimpleName());
        List<IJsonType> superTypes = this.getSuperTypes();
        if (superTypes.isEmpty()) {
            return "";
        }
        for (IJsonType superType : superTypes) {
            if (this.isSuperParentMe(superType)) continue;
            sb.append(", ");
            sb.append(superType.getIdentifier());
        }
        return "";
    }

    protected String addActualNameAnnotation(StringBuilder sb, int indent, String name, boolean capitalize) {
        String identifier = this.makeIdentifier(name, capitalize);
        if (!identifier.equals(name)) {
            this.indent(sb, indent);
            sb.append("@").append(ActualName.class.getName()).append("( \"").append(name).append("\" )\n");
        }
        return identifier;
    }

    private String makeMemberIdentifier(IJsonType type) {
        return this.makeIdentifier(type.getName(), false);
    }

    private String makeIdentifier(String name, boolean capitalize) {
        return capitalize ? ManStringUtil.capitalize((String)JsonUtil.makeIdentifier((String)name)) : JsonUtil.makeIdentifier((String)name);
    }

    public boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name) {
        Token token = (Token)this._state._memberLocations.get(name);
        if (token == null) {
            return false;
        }
        return this.addSourcePositionAnnotation(sb, indent, name, token);
    }

    protected boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name, Token token) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(SourcePosition.class.getName()).addArgument((SrcArgument)new SrcArgument((SrcExpression)new SrcMemberAccessExpression(new String[]{this.getIdentifier(), FIELD_FILE_URL})).name("url")).addArgument("feature", String.class, (Object)name).addArgument("offset", Integer.TYPE, (Object)token.getOffset()).addArgument("length", Integer.TYPE, (Object)name.length());
        annotation.render(sb, indent);
        return true;
    }

    private void addTypeReferenceAnnotation(StringBuilder sb, int indent, JsonSchemaType type) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(TypeReference.class.getName()).addArgument("value", String.class, (Object)this.getPropertyType(type));
        annotation.render(sb, indent);
    }

    private void renderStaticMembers(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.addCreateMethod(sb, indent, typeName);
        this.addBuilderMethod(sb, indent);
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" proxy(").append(Bindings.class.getSimpleName()).append(" bindings) {\n");
        this.indent(sb, indent + 2);
        sb.append("return new " + typeName + "() {\n");
        this.indent(sb, indent + 4);
        sb.append("  public Bindings getBindings() {\n");
        this.indent(sb, indent + 6);
        sb.append("    return bindings;\n");
        this.indent(sb, indent + 4);
        sb.append("  }\n");
        this.indent(sb, indent + 2);
        sb.append("};\n");
        this.indent(sb, indent);
        sb.append("}\n");
        if (this.shouldRenderTopLevel(this)) {
            this.addTopLevelFactoryMethods(sb, indent, typeName);
        }
        this.indent(sb, indent);
        sb.append("default String").append(" toJson() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toJson(getBindings());\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(getBindings());\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml(String name) {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(getBindings(), name);\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addTopLevelFactoryMethods(StringBuilder sb, int indent, String typeName) {
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJson(String jsonText) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(Json.class.getName()).append(".fromJson(jsonText);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(String url) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(new java.net.URL(url));\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(java.net.URL url) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(url);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(java.net.URL url, javax.script.Bindings json) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".postForJsonContent(url, json);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonFile(java.io.File file) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(typeName).append(")fromJsonUrl(file.toURI().toURL());\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addBuilderMethod(StringBuilder sb, int indent) {
        this.indent(sb, indent);
        sb.append("static Builder builder(");
        Set<String> allRequired = this.getAllRequired();
        Map<String, IJsonType> allMembers = this.getAllMembers();
        this.addRequredParams(sb, allRequired, allMembers);
        sb.append(") {\n");
        this.indent(sb, indent += 2);
        sb.append("return new Builder(");
        int count = 0;
        for (String param : allRequired) {
            IJsonType paramType = allMembers.get(param);
            if (paramType.getTypeAttributes().getDefaultValue() != null) continue;
            if (count++ > 0) {
                sb.append(", ");
            }
            String paramName = this.makeIdentifier(param, false);
            sb.append("" + paramName);
        }
        sb.append(");\n");
        this.indent(sb, indent -= 2);
        sb.append("}\n");
    }

    private void addBuilder(StringBuilder sb, int indent) {
        this.indent(sb, indent += 2);
        sb.append("class Builder {\n");
        this.indent(sb, indent += 2);
        sb.append("private final Bindings _bindings;\n");
        this.indent(sb, indent);
        this.addBuilderConstructor(sb, indent);
        this.addWithMethods(sb, indent);
        this.addBuildMethod(sb, indent);
        this.indent(sb, indent - 2);
        sb.append("}\n");
    }

    private void addBuildMethod(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.indent(sb, indent);
        sb.append("public " + typeName + " build() {\n");
        this.indent(sb, indent + 2);
        sb.append("return (" + typeName + ")_bindings;\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addWithMethods(StringBuilder sb, int indent) {
        for (Map.Entry<String, IJsonType> entry : this.getNotRequired().entrySet()) {
            String propertyType = this.getPropertyType(entry.getValue());
            String key = entry.getKey();
            String suffix = this.makeIdentifier(key, true);
            this.addSourcePositionAnnotation(sb, indent + 2, key);
            String identifier = this.addActualNameAnnotation(sb, indent + 2, key, false);
            this.indent(sb, indent);
            sb.append("public Builder with" + suffix + "(" + propertyType + " " + identifier + ") {\n");
            this.indent(sb, indent + 2);
            sb.append("_bindings.put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue(_bindings, " + identifier + "));\n");
            this.indent(sb, indent + 2);
            sb.append("return this;\n");
            this.indent(sb, indent);
            sb.append("}\n");
        }
    }

    private Map<String, IJsonType> getNotRequired() {
        HashMap<String, IJsonType> result = new HashMap<String, IJsonType>();
        Set<String> allRequired = this.getAllRequired();
        this.getAllMembers().forEach((key, value) -> {
            if (!allRequired.contains(key)) {
                result.put((String)key, (IJsonType)value);
            }
        });
        return result;
    }

    private void addBuilderConstructor(StringBuilder sb, int indent) {
        sb.append("private Builder(");
        Set<String> allRequired = this.getAllRequired();
        Map<String, IJsonType> allMembers = this.getAllMembers();
        this.addRequredParams(sb, allRequired, allMembers);
        sb.append(") {\n");
        this.indent(sb, indent += 2);
        sb.append("_bindings = create(");
        int count = 0;
        for (String param : allRequired) {
            IJsonType paramType = allMembers.get(param);
            if (paramType.getTypeAttributes().getDefaultValue() != null) continue;
            if (count++ > 0) {
                sb.append(", ");
            }
            String paramName = this.makeIdentifier(param, false);
            sb.append("" + paramName);
        }
        sb.append(").getBindings();\n");
        this.indent(sb, indent -= 2);
        sb.append("}\n");
    }

    private void addCreateMethod(StringBuilder sb, int indent, String typeName) {
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" create(");
        Set<String> allRequired = this.getAllRequired();
        Map<String, IJsonType> allMembers = this.getAllMembers();
        this.addRequredParams(sb, allRequired, allMembers);
        sb.append(") {\n");
        this.indent(sb, indent + 2);
        sb.append("DataBindings bindings_ = new DataBindings();\n");
        for (String string : allRequired) {
            IJsonType paramType = allMembers.get(string);
            if (paramType.getTypeAttributes().getDefaultValue() != null) continue;
            this.indent(sb, indent + 2);
            String passedInParam = this.makeIdentifier(string, false);
            sb.append("bindings_.put(\"" + string + "\", " + passedInParam + ");\n");
        }
        for (Map.Entry entry : allMembers.entrySet()) {
            StringBuilder defValJson;
            Object defaultValue = ((IJsonType)entry.getValue()).getTypeAttributes().getDefaultValue();
            if (defaultValue == null) continue;
            this.indent(sb, indent + 2);
            sb.append("bindings_.put(\"" + (String)entry.getKey() + "\", ");
            if (defaultValue instanceof Bindings) {
                this.indent(sb, indent + 2);
                sb.append("Json.fromJson(\"");
                defValJson = new StringBuilder();
                JsonUtil.toJson((StringBuilder)defValJson, (int)0, (Object)defaultValue);
                sb.append(ManEscapeUtil.escapeForJava((String)defValJson.toString()));
                sb.append("\")");
            } else if (defaultValue instanceof List) {
                this.indent(sb, indent + 2);
                sb.append("Json.fromJson(\"");
                defValJson = new StringBuilder();
                JsonUtil.toJson((StringBuilder)defValJson, (int)0, (Object)defaultValue);
                sb.append(ManEscapeUtil.escapeForJava((String)defValJson.toString()));
                sb.append("\").get(\"value\")");
            } else {
                JsonUtil.toJson((StringBuilder)sb, (int)0, (Object)defaultValue);
            }
            sb.append(");\n");
        }
        this.indent(sb, indent + 2);
        sb.append("return (" + typeName + ")bindings_;\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addRequredParams(StringBuilder sb, Set<String> allRequired, Map<String, IJsonType> allMembers) {
        int count = 0;
        for (String param : allRequired) {
            IJsonType paramType = allMembers.get(param);
            if (paramType.getTypeAttributes().getDefaultValue() != null) continue;
            if (count++ > 0) {
                sb.append(", ");
            }
            String paramTypeName = this.getPropertyType(paramType);
            String paramName = this.makeIdentifier(param, false);
            sb.append(paramTypeName + " " + paramName);
        }
    }

    private boolean shouldRenderTopLevel(IJsonParentType type) {
        IJsonParentType parent = type.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof JsonListType) {
            return this.shouldRenderTopLevel(parent);
        }
        return false;
    }

    protected void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    @Override
    public boolean equalsStructurally(IJsonType o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType that = (JsonStructureType)o;
        int[] i = new int[]{0};
        if (this._state._superTypes.size() != that._state._superTypes.size() || !this._state._superTypes.stream().allMatch(t -> {
            int n = i[0];
            i[0] = n + 1;
            return ((IJsonType)that._state._superTypes.get(n)).equalsStructurally((IJsonType)t);
        })) {
            return false;
        }
        if (this._state._membersByName.size() != that._state._membersByName.size() || !this._state._membersByName.keySet().stream().allMatch(key -> that._state._membersByName.containsKey(key) && ((IJsonType)this._state._membersByName.get(key)).equalsStructurally((IJsonType)that._state._membersByName.get(key)))) {
            return false;
        }
        if (this._state._unionMembers.size() != that._state._unionMembers.size() || !this._state._unionMembers.keySet().stream().allMatch(key -> that._state._unionMembers.containsKey(key) && this.typeSetsSame((Set)this._state._unionMembers.get(key), (Set)that._state._unionMembers.get(key)))) {
            return false;
        }
        return this._state._innerTypes.size() == that._state._innerTypes.size() && this._state._innerTypes.keySet().stream().allMatch(key -> that._state._innerTypes.containsKey(key) && ((IJsonParentType)this._state._innerTypes.get(key)).equalsStructurally((IJsonType)that._state._innerTypes.get(key)));
    }

    private boolean typeSetsSame(Set<IJsonType> t1, Set<IJsonType> t2) {
        if (t1.size() != t2.size()) {
            return false;
        }
        Iterator<IJsonType> iter1 = t1.iterator();
        Iterator<IJsonType> iter2 = t2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (iter1.next().equalsStructurally(iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    public boolean isRequired(String name) {
        if (this._state._required.contains(name)) {
            return true;
        }
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType) || !((JsonStructureType)extended).isRequired(name)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getAllRequired() {
        LinkedHashSet<String> allRequired = new LinkedHashSet<String>();
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType)) continue;
            allRequired.addAll(((JsonStructureType)extended)._state._required);
        }
        allRequired.addAll(this._state._required);
        return allRequired;
    }

    public void addRequired(Set<String> required) {
        if (this._state._required.isEmpty()) {
            this._state._required = new LinkedHashSet();
        }
        this._state._required.addAll(required);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.isSchemaType()) {
            return this == o;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType type = (JsonStructureType)o;
        if (!this._state._superTypes.equals(type._state._superTypes)) {
            return false;
        }
        if (!this._state._membersByName.equals(type._state._membersByName)) {
            return false;
        }
        if (!this._state._unionMembers.equals(type._state._unionMembers)) {
            return false;
        }
        return this._state._innerTypes.equals(type._state._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._state._superTypes.hashCode();
        result = 31 * result + this._state._membersByName.keySet().hashCode();
        result = 31 * result + this._state._unionMembers.keySet().hashCode();
        return result;
    }

    public String toString() {
        return this.getFqn();
    }

    private static final class State {
        private List<IJsonType> _superTypes;
        private Map<String, IJsonType> _membersByName;
        private Map<String, Set<IJsonType>> _unionMembers;
        private Map<String, Token> _memberLocations;
        private Map<String, IJsonParentType> _innerTypes;
        private Set<String> _required;
        private Token _token;

        private State() {
        }
    }
}

