/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonStructureType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonSchemaTransformer;
import manifold.api.json.schema.JsonSchemaType;
import manifold.internal.javac.IIssue;
import manifold.util.DebugLogUtil;
import manifold.util.Pair;

class ObjectTransformer {
    private final JsonSchemaTransformer _schemaTx;
    private final JsonStructureType _type;
    private final Bindings _jsonObj;

    static void transform(JsonSchemaTransformer schemaTx, JsonStructureType type, Bindings jsonObj) {
        new ObjectTransformer(schemaTx, type, jsonObj).transform();
    }

    private ObjectTransformer(JsonSchemaTransformer schemaTx, JsonStructureType type, Bindings jsonObj) {
        this._schemaTx = schemaTx;
        this._jsonObj = jsonObj;
        this._type = type;
    }

    JsonStructureType getType() {
        return this._type;
    }

    private void transform() {
        JsonSchemaType parent = this._type.getParent();
        if (parent != null) {
            parent.addChild(this._type.getLabel(), this._type);
        }
        this._schemaTx.cacheByFqn(this._type);
        this.addProperties();
    }

    private void addProperties() {
        Object props = this._jsonObj.get("properties");
        if (props == null) {
            return;
        }
        Token token = null;
        try {
            Bindings properties = props instanceof Pair ? (Bindings)((Pair)props).getSecond() : (Bindings)props;
            for (Map.Entry entry : properties.entrySet()) {
                Bindings bindings;
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Pair) {
                    token = ((Token[])((Pair)value).getFirst())[0];
                    bindings = (Bindings)((Pair)value).getSecond();
                } else {
                    token = null;
                    bindings = (Bindings)value;
                }
                IJsonType type = this._schemaTx.transformType(this._type, this._type.getFile(), name, bindings);
                this._type.addMember(name, type, token);
            }
            this.addRequired();
        }
        catch (Exception e) {
            String message = e.getMessage();
            this._type.addIssue(new JsonIssue(IIssue.Kind.Error, token, message == null ? DebugLogUtil.getStackTrace((Throwable)e) : message));
        }
    }

    private void addRequired() {
        Object requiredValue = this._jsonObj.get("required");
        Set<String> required = Collections.emptySet();
        if (requiredValue != null) {
            Object object = requiredValue = requiredValue instanceof Pair ? ((Pair)requiredValue).getSecond() : requiredValue;
            if (requiredValue instanceof Collection) {
                required = new HashSet<String>((Collection)requiredValue);
            }
        }
        this._type.addRequired(required);
    }
}

