/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import manifold.api.gen.SrcAnnotationExpression;
import manifold.api.gen.SrcArgument;
import manifold.api.gen.SrcExpression;
import manifold.api.gen.SrcMemberAccessExpression;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.Json;
import manifold.api.json.JsonListType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonEnumType;
import manifold.api.json.schema.JsonSchemaType;
import manifold.api.json.schema.JsonUnionType;
import manifold.api.json.schema.LazyRefJsonType;
import manifold.api.type.ActualName;
import manifold.api.type.SourcePosition;
import manifold.api.type.TypeReference;
import manifold.ext.RuntimeMethods;
import manifold.ext.api.IBindingsBacked;
import manifold.json.extensions.java.net.URL.ManUrlExt;
import manifold.json.extensions.javax.script.Bindings.ManBindingsExt;
import manifold.util.JsonUtil;
import manifold.util.ManEscapeUtil;
import manifold.util.ManStringUtil;

public class JsonStructureType
extends JsonSchemaType {
    private static final String FIELD_FILE_URL = "__FILE_URL_";
    private List<IJsonType> _superTypes;
    private Map<String, IJsonType> _membersByName = new LinkedHashMap<String, IJsonType>();
    private Map<String, Set<IJsonType>> _unionMembers;
    private Map<String, Token> _memberLocations = new LinkedHashMap<String, Token>();
    private Map<String, IJsonParentType> _innerTypes = Collections.emptyMap();
    private Set<String> _required;
    private Token _token;

    public JsonStructureType(JsonSchemaType parent, URL source, String name) {
        super(name, source, parent);
        this._unionMembers = Collections.emptyMap();
        this._superTypes = Collections.emptyList();
        this._required = Collections.emptySet();
    }

    @Override
    protected void resolveRefsImpl() {
        IJsonType type;
        super.resolveRefsImpl();
        for (Map.Entry<String, IJsonType> entry : new HashSet<Map.Entry<String, IJsonType>>(this._membersByName.entrySet())) {
            type = entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            this._membersByName.put(entry.getKey(), ((LazyRefJsonType)type).resolve());
        }
        for (Map.Entry<String, Object> entry : new HashSet<Map.Entry<String, Set<IJsonType>>>(this._unionMembers.entrySet())) {
            HashSet<IJsonType> types = new HashSet<IJsonType>();
            for (IJsonType type2 : (Set)entry.getValue()) {
                if (type2 instanceof JsonSchemaType) {
                    ((JsonSchemaType)type2).resolveRefs();
                } else if (type2 instanceof LazyRefJsonType) {
                    type2 = ((LazyRefJsonType)type2).resolve();
                }
                types.add(type2);
            }
            this._unionMembers.put(entry.getKey(), types);
        }
        for (Map.Entry<String, Object> entry : new HashSet<Map.Entry<String, IJsonParentType>>(this._innerTypes.entrySet())) {
            type = (IJsonType)entry.getValue();
            if (type instanceof JsonSchemaType) {
                ((JsonSchemaType)type).resolveRefs();
                continue;
            }
            if (!(type instanceof LazyRefJsonType)) continue;
            type = ((LazyRefJsonType)type).resolve();
            this._innerTypes.put(entry.getKey(), (IJsonParentType)type);
        }
    }

    @Override
    public String getFqn() {
        String result = "";
        if (!this.isParentRoot()) {
            result = this.getParent().getFqn();
            result = result + '.';
        }
        return result + JsonUtil.makeIdentifier((String)this.getLabel());
    }

    public void addSuper(IJsonType superType) {
        if (this._superTypes.isEmpty()) {
            this._superTypes = new ArrayList<IJsonType>();
        }
        this._superTypes.add(superType);
    }

    private List<IJsonType> getSuperTypes() {
        if (!this._superTypes.isEmpty() && this._superTypes.stream().anyMatch(e -> e instanceof LazyRefJsonType)) {
            ArrayList<IJsonType> resolved = new ArrayList<IJsonType>();
            for (IJsonType type : this._superTypes) {
                if (type instanceof LazyRefJsonType) {
                    type = ((LazyRefJsonType)type).resolve();
                }
                resolved.add(type);
            }
            this._superTypes = resolved;
        }
        return this._superTypes;
    }

    @Override
    public void addChild(String name, IJsonParentType type) {
        if (this._innerTypes.isEmpty()) {
            this._innerTypes = new HashMap<String, IJsonParentType>();
        }
        this._innerTypes.put(name, type);
    }

    @Override
    public IJsonType findChild(String name) {
        List<IJsonType> definitions;
        IJsonParentType innerType = this._innerTypes.get(name);
        if (innerType == null && (definitions = this.getDefinitions()) != null) {
            for (IJsonType child : definitions) {
                if (!child.getIdentifier().equals(name)) continue;
                innerType = (IJsonParentType)child;
                break;
            }
        }
        if (innerType == null) {
            for (Set<IJsonType> constituents : this._unionMembers.values()) {
                for (IJsonType c : constituents) {
                    if (c.getIdentifier().equals(name)) {
                        innerType = (IJsonParentType)c;
                        continue;
                    }
                    while (c instanceof JsonListType) {
                        c = ((JsonListType)c).getComponentType();
                    }
                    if (!c.getIdentifier().equals(name)) continue;
                    innerType = (IJsonParentType)c;
                }
            }
        }
        return innerType;
    }

    public Map<String, IJsonType> getMembers() {
        return this._membersByName;
    }

    private Map<String, IJsonType> getAllMembers() {
        HashMap<String, IJsonType> allMembers = new HashMap<String, IJsonType>(this._membersByName);
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType)) continue;
            allMembers.putAll(((JsonStructureType)extended).getMembers());
        }
        return allMembers;
    }

    protected Map<String, Token> getMemberLocations() {
        return this._memberLocations;
    }

    public Map<String, IJsonParentType> getInnerTypes() {
        return this._innerTypes;
    }

    public void addMember(String name, IJsonType type, Token token) {
        IJsonType existingType = this._membersByName.get(name);
        if (existingType != null && existingType != type) {
            if (type == DynamicType.instance()) {
                return;
            }
            if (existingType != DynamicType.instance() && (type = Json.mergeTypes(existingType, type)) == null) {
                throw new RuntimeException("Types disagree for '" + name + "' from array data: " + existingType.getName() + " vs: " + existingType.getName());
            }
        }
        this._membersByName.put(name, type);
        this._memberLocations.put(name, token);
        this.addUnionMemberAccess(name, type);
    }

    private void addUnionMemberAccess(String name, IJsonType type) {
        if (type instanceof JsonUnionType) {
            for (IJsonType iJsonType : ((JsonUnionType)type).getConstituents()) {
                if (this._unionMembers.isEmpty()) {
                    this._unionMembers = new HashMap<String, Set<IJsonType>>();
                }
                Set union = this._unionMembers.computeIfAbsent(name, k -> new HashSet());
                union.add(iJsonType);
            }
        } else if (type instanceof JsonListType) {
            this.addUnionMemberAccess(name, ((JsonListType)type).getComponentType());
        }
    }

    private IJsonType findMemberType(String name) {
        return this._membersByName.get(name);
    }

    public Token getToken() {
        return this._token;
    }

    public void setToken(Token token) {
        this._token = token;
    }

    @Override
    public IJsonType merge(IJsonType that) {
        if (!(that instanceof JsonStructureType) || that instanceof JsonEnumType) {
            return null;
        }
        JsonStructureType other = (JsonStructureType)that;
        if (!this.getName().equals(other.getName())) {
            return null;
        }
        JsonStructureType mergedType = new JsonStructureType(this.getParent(), this.getFile(), this.getName());
        for (Map.Entry<String, IJsonType> e : this._membersByName.entrySet()) {
            String memberName = e.getKey();
            IJsonType memberType = other.findMemberType(memberName);
            memberType = memberType != null ? Json.mergeTypes(e.getValue(), memberType) : e.getValue();
            if (memberType != null) {
                mergedType.addMember(memberName, memberType, this._memberLocations.get(memberName));
                continue;
            }
            return null;
        }
        if (!this.mergeInnerTypes(other, mergedType, this._innerTypes)) {
            return null;
        }
        return mergedType;
    }

    @Override
    public void render(StringBuilder sb, int indent, boolean mutable) {
        JsonEnumType enumType = this.getAllOfEnumType();
        if (enumType != null) {
            enumType.render(sb, indent, mutable);
            return;
        }
        if (this.getParent() != null) {
            sb.append('\n');
        }
        String name = this.getName();
        String identifier = this.addActualNameAnnotation(sb, indent, name, false);
        if (!(this.getParent() instanceof JsonStructureType && ((JsonStructureType)this.getParent()).addSourcePositionAnnotation(sb, indent, identifier) || this.getToken() == null)) {
            this.addSourcePositionAnnotation(sb, indent, identifier, this.getToken());
        }
        this.indent(sb, indent);
        sb.append("@Structural\n");
        this.indent(sb, indent);
        sb.append("public interface ").append(identifier).append(this.addSuperTypes(sb)).append(" {\n");
        this.renderFileField(sb, indent + 2);
        this.renderTopLevelFactoryMethods(sb, indent + 2);
        for (String key : this._membersByName.keySet()) {
            sb.append('\n');
            IJsonType type = this._membersByName.get(key);
            String propertyType = this.getPropertyType(type);
            this.addSourcePositionAnnotation(sb, indent + 2, key);
            identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
            this.indent(sb, indent + 2);
            sb.append("default " + propertyType + " get").append(identifier).append("() {\n");
            this.indent(sb, indent + 4);
            if (type instanceof JsonListType || propertyType.indexOf(62) > 0) {
                sb.append("return (" + propertyType + ")getBindings().get(\"" + key + "\");\n");
            } else {
                sb.append("return (" + propertyType + ")").append(RuntimeMethods.class.getSimpleName()).append(".coerce(getBindings().get(\"" + key + "\"), " + propertyType + ".class);\n");
            }
            this.indent(sb, indent + 2);
            sb.append("}\n");
            if (mutable) {
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                sb.append("default void set").append(identifier).append("(").append(propertyType).append(" $value) {\n");
                this.indent(sb, indent + 4);
                sb.append("getBindings().put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue(getBindings(), $value));\n");
                this.indent(sb, indent + 2);
                sb.append("}\n");
            }
            this.renderUnionAccessors(sb, indent, mutable, key, type);
        }
        for (IJsonParentType child : this._innerTypes.values()) {
            child.render(sb, indent + 2, mutable);
        }
        List<IJsonType> definitions = this.getDefinitions();
        if (definitions != null) {
            for (IJsonType child : definitions) {
                if (!(child instanceof IJsonParentType)) continue;
                ((IJsonParentType)child).render(sb, indent + 2, mutable);
            }
        }
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void renderUnionAccessors(StringBuilder sb, int indent, boolean mutable, String key, IJsonType type) {
        if (this.isCollapsedUnionEnum(type)) {
            return;
        }
        Set<IJsonType> union = this._unionMembers.get(key);
        if (union != null) {
            for (IJsonType constituentType : union) {
                sb.append('\n');
                String specificPropertyType = this.getConstituentQn(constituentType, type);
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                String identifier = this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                String unionName = this.makeMemberIdentifier(constituentType);
                sb.append("default " + specificPropertyType + "  get").append(identifier).append("As").append(unionName).append("() {\n");
                this.indent(sb, indent + 4);
                if (constituentType instanceof JsonListType || specificPropertyType.indexOf(62) > 0) {
                    sb.append("return (" + specificPropertyType + ")getBindings().get(\"" + key + "\");\n");
                } else {
                    sb.append("return (" + specificPropertyType + ")").append(RuntimeMethods.class.getSimpleName()).append(".coerce(getBindings().get(\"" + key + "\"), " + specificPropertyType + ".class);\n");
                }
                this.indent(sb, indent + 2);
                sb.append("}\n");
                if (!mutable) continue;
                this.addSourcePositionAnnotation(sb, indent + 2, key);
                if (constituentType instanceof JsonSchemaType) {
                    this.addTypeReferenceAnnotation(sb, indent + 2, (JsonSchemaType)this.getConstituentQnComponent(constituentType));
                }
                this.addActualNameAnnotation(sb, indent + 2, key, true);
                this.indent(sb, indent + 2);
                sb.append("default void set").append(identifier).append("As").append(unionName).append("(").append(specificPropertyType).append(" $value) {\n");
                this.indent(sb, indent + 4);
                sb.append("getBindings().put(\"" + key + "\", ").append(RuntimeMethods.class.getSimpleName()).append(".coerceToBindingValue(getBindings(), $value));\n");
                this.indent(sb, indent + 2);
                sb.append("}\n");
            }
        }
    }

    private boolean isCollapsedUnionEnum(IJsonType type) {
        while (type instanceof JsonListType) {
            type = ((JsonListType)type).getComponentType();
        }
        JsonEnumType enumType = type instanceof JsonUnionType ? ((JsonUnionType)type).getCollapsedEnumType() : null;
        return enumType != null;
    }

    private JsonEnumType getAllOfEnumType() {
        if (!this.getMembers().isEmpty()) {
            return null;
        }
        if (this.getSuperTypes().stream().allMatch(e -> e instanceof JsonEnumType)) {
            return this.makeEnumType(this.getSuperTypes());
        }
        return null;
    }

    protected JsonEnumType makeEnumType(Collection<? extends IJsonType> types) {
        JsonEnumType result = null;
        JsonEnumType prev = null;
        for (IJsonType iJsonType : types) {
            prev = result = new JsonEnumType((JsonEnumType)iJsonType, prev, this.getParent(), this.getName());
        }
        return result;
    }

    private String getConstituentQn(IJsonType constituentType, IJsonType propertyType) {
        String qn = this.getConstituentQn(constituentType);
        while (propertyType instanceof JsonListType) {
            qn = List.class.getTypeName() + '<' + qn + '>';
            propertyType = ((JsonListType)propertyType).getComponentType();
        }
        return qn;
    }

    private String getPropertyType(IJsonType propertyType) {
        if (propertyType instanceof JsonListType) {
            return List.class.getTypeName() + '<' + this.getPropertyType(((JsonListType)propertyType).getComponentType()) + '>';
        }
        if (propertyType instanceof JsonUnionType) {
            JsonEnumType enumType = ((JsonUnionType)propertyType).getCollapsedEnumType();
            return enumType != null ? enumType.getIdentifier() : Object.class.getSimpleName();
        }
        return propertyType.getIdentifier();
    }

    private String getConstituentQn(IJsonType constituentType) {
        if (constituentType instanceof JsonListType) {
            return List.class.getTypeName() + '<' + this.getConstituentQn(((JsonListType)constituentType).getComponentType()) + '>';
        }
        String qn = "";
        if (constituentType.getParent() instanceof JsonUnionType) {
            qn = this.getConstituentQn(constituentType.getParent()) + '.';
        }
        return qn + constituentType.getIdentifier();
    }

    private IJsonType getConstituentQnComponent(IJsonType constituentType) {
        if (constituentType instanceof JsonListType) {
            return this.getConstituentQnComponent(((JsonListType)constituentType).getComponentType());
        }
        return constituentType;
    }

    private void renderFileField(StringBuilder sb, int indent) {
        this.renderFileField(sb, indent, null);
    }

    protected void renderFileField(StringBuilder sb, int indent, String modifiers) {
        this.indent(sb, indent);
        sb.append(modifiers == null ? "" : modifiers + " ").append("String ").append(FIELD_FILE_URL).append(" = \"").append(this.getFile() == null ? "null" : this.getFile().toString()).append("\";\n");
    }

    private String addSuperTypes(StringBuilder sb) {
        sb.append(" extends ").append(IBindingsBacked.class.getSimpleName());
        List<IJsonType> superTypes = this.getSuperTypes();
        if (superTypes.isEmpty()) {
            return "";
        }
        for (IJsonType superType : superTypes) {
            sb.append(", ");
            sb.append(superType.getIdentifier());
        }
        return "";
    }

    protected String addActualNameAnnotation(StringBuilder sb, int indent, String name, boolean capitalize) {
        String identifier = this.makeIdentifier(name, capitalize);
        if (!identifier.equals(name)) {
            this.indent(sb, indent);
            sb.append("@").append(ActualName.class.getName()).append("( \"").append(name).append("\" )\n");
        }
        return identifier;
    }

    private String makeMemberIdentifier(IJsonType type) {
        return this.makeIdentifier(type.getName(), false);
    }

    private String makeIdentifier(String name, boolean capitalize) {
        return capitalize ? ManStringUtil.capitalize((String)JsonUtil.makeIdentifier((String)name)) : JsonUtil.makeIdentifier((String)name);
    }

    public boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name) {
        Token token = this._memberLocations.get(name);
        if (token == null) {
            return false;
        }
        return this.addSourcePositionAnnotation(sb, indent, name, token);
    }

    protected boolean addSourcePositionAnnotation(StringBuilder sb, int indent, String name, Token token) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(SourcePosition.class.getName()).addArgument((SrcArgument)new SrcArgument((SrcExpression)new SrcMemberAccessExpression(new String[]{this.getIdentifier(), FIELD_FILE_URL})).name("url")).addArgument("feature", String.class, (Object)name).addArgument("offset", Integer.TYPE, (Object)token.getOffset()).addArgument("length", Integer.TYPE, (Object)name.length());
        annotation.render(sb, indent);
        return true;
    }

    private void addTypeReferenceAnnotation(StringBuilder sb, int indent, JsonSchemaType type) {
        SrcAnnotationExpression annotation = new SrcAnnotationExpression(TypeReference.class.getName()).addArgument("value", String.class, (Object)this.getPropertyType(type));
        annotation.render(sb, indent);
    }

    private void renderTopLevelFactoryMethods(StringBuilder sb, int indent) {
        String typeName = this.getIdentifier();
        this.addCreateMethod(sb, indent, typeName);
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" proxy(").append(Bindings.class.getSimpleName()).append(" bindings) {\n");
        sb.append("    return new " + typeName + "() {\n      public Bindings getBindings() {\n        return bindings;\n      }\n    };\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toJson() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toJson(getBindings());\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml() {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(getBindings());\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("default String").append(" toXml(String name) {\n");
        this.indent(sb, indent);
        sb.append("  return ").append(ManBindingsExt.class.getName()).append(".toXml(getBindings(), name);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        if (!this.shouldRenderTopLevel(this)) {
            return;
        }
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJson(String jsonText) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(Json.class.getName()).append(".fromJson(jsonText);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(String url) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(new java.net.URL(url));\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(java.net.URL url) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".getJsonContent(url);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonUrl(java.net.URL url, javax.script.Bindings json) {\n");
        this.indent(sb, indent);
        sb.append("  return (").append(typeName).append(")").append(ManUrlExt.class.getName()).append(".postForJsonContent(url, json);\n");
        this.indent(sb, indent);
        sb.append("}\n");
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" fromJsonFile(java.io.File file) {\n");
        this.indent(sb, indent);
        sb.append("  try {\n");
        this.indent(sb, indent);
        sb.append("    return (").append(typeName).append(")fromJsonUrl(file.toURI().toURL());\n");
        this.indent(sb, indent);
        sb.append("  } catch(Exception e) {throw new RuntimeException(e);}\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private void addCreateMethod(StringBuilder sb, int indent, String typeName) {
        IJsonType paramType;
        this.indent(sb, indent);
        sb.append("static ").append(typeName).append(" create(");
        int count = 0;
        Set<String> allRequired = this.getAllRequired();
        Map<String, IJsonType> allMembers = this.getAllMembers();
        for (String string : allRequired) {
            paramType = allMembers.get(string);
            if (paramType.getDefaultValue() != null) continue;
            if (count++ > 0) {
                sb.append(", ");
            }
            String paramTypeName = this.getPropertyType(paramType);
            String paramName = this.makeIdentifier(string, false);
            sb.append(paramTypeName + " " + paramName);
        }
        sb.append(") {\n");
        this.indent(sb, indent);
        sb.append("SimpleBindings bindings_ = new SimpleBindings();\n");
        this.indent(sb, indent);
        for (String string : allRequired) {
            paramType = allMembers.get(string);
            if (paramType.getDefaultValue() != null) continue;
            this.indent(sb, indent);
            String passedInParam = this.makeIdentifier(string, false);
            sb.append("bindings_.put(\"" + string + "\", " + passedInParam + ");\n");
        }
        for (Map.Entry entry : allMembers.entrySet()) {
            StringBuilder defValJson;
            Object defaultValue = ((IJsonType)entry.getValue()).getDefaultValue();
            if (defaultValue == null) continue;
            this.indent(sb, indent + 2);
            sb.append("bindings_.put(\"" + (String)entry.getKey() + "\", ");
            if (defaultValue instanceof Bindings) {
                sb.append("Json.fromJson(\"");
                defValJson = new StringBuilder();
                JsonUtil.toJson((StringBuilder)defValJson, (int)0, (Object)defaultValue);
                sb.append(ManEscapeUtil.escapeForJava((String)defValJson.toString()));
                sb.append("\")");
            } else if (defaultValue instanceof List) {
                sb.append("Json.fromJson(\"");
                defValJson = new StringBuilder();
                JsonUtil.toJson((StringBuilder)defValJson, (int)0, (Object)defaultValue);
                sb.append(ManEscapeUtil.escapeForJava((String)defValJson.toString()));
                sb.append("\").get(\"value\")");
            } else {
                JsonUtil.toJson((StringBuilder)sb, (int)0, (Object)defaultValue);
            }
            sb.append(");\n");
        }
        this.indent(sb, indent + 2);
        sb.append("return (" + typeName + ")bindings_;\n");
        this.indent(sb, indent);
        sb.append("}\n");
    }

    private boolean shouldRenderTopLevel(IJsonParentType type) {
        IJsonParentType parent = type.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof JsonListType) {
            return this.shouldRenderTopLevel(parent);
        }
        return false;
    }

    protected void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }

    @Override
    public boolean equalsStructurally(IJsonType o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType that = (JsonStructureType)o;
        int[] i = new int[]{0};
        if (this._superTypes.size() != that._superTypes.size() || !this._superTypes.stream().allMatch(t -> {
            int n = i[0];
            i[0] = n + 1;
            return that._superTypes.get(n).equalsStructurally((IJsonType)t);
        })) {
            return false;
        }
        if (this._membersByName.size() != that._membersByName.size() || !this._membersByName.keySet().stream().allMatch(key -> that._membersByName.containsKey(key) && this._membersByName.get(key).equalsStructurally(that._membersByName.get(key)))) {
            return false;
        }
        if (this._unionMembers.size() != that._unionMembers.size() || !this._unionMembers.keySet().stream().allMatch(key -> that._unionMembers.containsKey(key) && this.typeSetsSame(this._unionMembers.get(key), that._unionMembers.get(key)))) {
            return false;
        }
        return this._innerTypes.size() == that._innerTypes.size() && this._innerTypes.keySet().stream().allMatch(key -> that._innerTypes.containsKey(key) && this._innerTypes.get(key).equalsStructurally(that._innerTypes.get(key)));
    }

    private boolean typeSetsSame(Set<IJsonType> t1, Set<IJsonType> t2) {
        if (t1.size() != t2.size()) {
            return false;
        }
        Iterator<IJsonType> iter1 = t1.iterator();
        Iterator<IJsonType> iter2 = t2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (iter1.next().equalsStructurally(iter2.next())) continue;
            return false;
        }
        return !iter1.hasNext() && !iter2.hasNext();
    }

    public boolean isRequired(String name) {
        if (this._required.contains(name)) {
            return true;
        }
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType) || !((JsonStructureType)extended).isRequired(name)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getAllRequired() {
        HashSet<String> allRequired = new HashSet<String>(this._required);
        for (IJsonType extended : this.getSuperTypes()) {
            if (!(extended instanceof JsonStructureType)) continue;
            allRequired.addAll(((JsonStructureType)extended)._required);
        }
        return allRequired;
    }

    public void addRequired(Set<String> required) {
        if (this._required.isEmpty()) {
            this._required = new HashSet<String>();
        }
        this._required.addAll(required);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.isSchemaType()) {
            return this == o;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JsonStructureType type = (JsonStructureType)o;
        if (!this._superTypes.equals(type._superTypes)) {
            return false;
        }
        if (!this._membersByName.equals(type._membersByName)) {
            return false;
        }
        if (!this._unionMembers.equals(type._unionMembers)) {
            return false;
        }
        return this._innerTypes.equals(type._innerTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this._superTypes.hashCode();
        result = 31 * result + this._membersByName.keySet().hashCode();
        result = 31 * result + this._unionMembers.keySet().hashCode();
        return result;
    }

    public String toString() {
        return this.getFqn();
    }
}

