/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonSimpleTypeWithDefault;
import manifold.ext.RuntimeMethods;

public enum JsonSimpleType implements IJsonType
{
    String(String.class),
    Boolean(Boolean.class),
    Character(Character.class),
    Byte(Byte.class),
    Short(Short.class),
    Integer(Integer.class),
    Long(Long.class),
    Float(Float.class),
    Double(Double.class),
    BigInteger(BigInteger.class),
    BigDecimal(BigDecimal.class),
    Null("null");

    private final Class<?> _javaClass;
    private final String _identifier;

    private JsonSimpleType(Class<?> javaClass) {
        this._identifier = this.name();
        this._javaClass = javaClass;
    }

    private JsonSimpleType(String identifier) {
        this._identifier = identifier;
        this._javaClass = Void.class;
    }

    public static JsonSimpleType get(Object jsonObj) {
        if (jsonObj == null) {
            return null;
        }
        return JsonSimpleType.valueOf(JsonSimpleType.class, jsonObj.getClass().getSimpleName());
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getIdentifier() {
        return this._identifier;
    }

    @Override
    public IJsonParentType getParent() {
        return null;
    }

    @Override
    public Object getDefaultValue() {
        return null;
    }

    @Override
    public IJsonType setDefaultValue(Object value) {
        value = RuntimeMethods.coerce((Object)value, this._javaClass);
        return new JsonSimpleTypeWithDefault(this, value);
    }

    @Override
    public IJsonType merge(IJsonType that) {
        if (!(that instanceof JsonSimpleType)) {
            return that.merge(this);
        }
        JsonSimpleType other = (JsonSimpleType)that;
        if (this == String || other == String) {
            return String;
        }
        if (this == Null) {
            return other;
        }
        if (other == Null) {
            return this;
        }
        switch (this) {
            case Boolean: {
                break;
            }
            case Character: {
                switch (other) {
                    case Byte: {
                        return this;
                    }
                    case Short: 
                    case Integer: 
                    case Long: 
                    case Float: 
                    case Double: 
                    case BigDecimal: 
                    case BigInteger: {
                        return other;
                    }
                }
                break;
            }
            case Byte: {
                switch (other) {
                    case Short: 
                    case Integer: 
                    case Long: 
                    case Float: 
                    case Double: 
                    case BigDecimal: 
                    case BigInteger: 
                    case Character: {
                        return other;
                    }
                }
                break;
            }
            case Short: {
                switch (other) {
                    case Byte: 
                    case Character: {
                        return this;
                    }
                    case Integer: 
                    case Long: 
                    case Float: 
                    case Double: 
                    case BigDecimal: 
                    case BigInteger: {
                        return other;
                    }
                }
                break;
            }
            case Integer: {
                switch (other) {
                    case Byte: 
                    case Short: 
                    case Character: {
                        return this;
                    }
                    case Long: 
                    case Float: 
                    case Double: 
                    case BigDecimal: 
                    case BigInteger: {
                        return other;
                    }
                }
                break;
            }
            case Long: {
                switch (other) {
                    case Byte: 
                    case Short: 
                    case Integer: 
                    case Character: {
                        return this;
                    }
                    case Float: 
                    case Double: 
                    case BigDecimal: 
                    case BigInteger: {
                        return other;
                    }
                }
                break;
            }
            case Float: {
                switch (other) {
                    case Byte: 
                    case Short: 
                    case Integer: 
                    case Long: 
                    case Character: {
                        return this;
                    }
                    case Double: 
                    case BigDecimal: 
                    case BigInteger: {
                        return other;
                    }
                }
                break;
            }
            case Double: {
                switch (other) {
                    case Byte: 
                    case Short: 
                    case Integer: 
                    case Long: 
                    case Float: 
                    case Character: {
                        return this;
                    }
                    case BigDecimal: 
                    case BigInteger: {
                        return other;
                    }
                }
                break;
            }
            case BigDecimal: {
                switch (other) {
                    case Byte: 
                    case Short: 
                    case Integer: 
                    case Long: 
                    case Float: 
                    case Double: 
                    case BigInteger: 
                    case Character: {
                        return this;
                    }
                }
                break;
            }
            case BigInteger: {
                switch (other) {
                    case Byte: 
                    case Short: 
                    case Integer: 
                    case Long: 
                    case Character: {
                        return this;
                    }
                    case Float: 
                    case Double: 
                    case BigDecimal: {
                        return BigDecimal;
                    }
                }
            }
        }
        return null;
    }
}

