/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import manifold.api.json.IJsonParser;

public class NashornJsonParser
implements IJsonParser {
    private static final NashornJsonParser INSTANCE = new NashornJsonParser();
    private ScriptEngine _engine;

    public static IJsonParser instance() {
        return INSTANCE;
    }

    private NashornJsonParser() {
    }

    @Override
    public Bindings parseJson(String jsonText, boolean withBigNumbers, boolean withTokens) throws ScriptException {
        String script;
        Object result;
        if (withBigNumbers || withTokens) {
            throw new UnsupportedOperationException("Nashorn json parser does not support Big numbers or tokens");
        }
        if (this._engine == null) {
            this._engine = new ScriptEngineManager().getEngineByName("javascript");
        }
        if ((result = this._engine.eval(script = "Java.asJSONCompatible(" + jsonText + ")")) instanceof Bindings) {
            return (Bindings)result;
        }
        return NashornJsonParser.wrapValueInBindings(result);
    }

    static Bindings wrapValueInBindings(Object result) throws ScriptException {
        if (result == null || result instanceof List || result instanceof String || result instanceof Number || result instanceof Boolean) {
            SimpleBindings wrapper = new SimpleBindings();
            wrapper.put("value", result);
            return wrapper;
        }
        throw new ScriptException("Unexpected JSON result type: " + result.getClass().getName());
    }
}

