/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.Bindings;
import manifold.api.templ.DisableStringLiteralTemplates;
import manifold.internal.host.ManifoldHost;
import manifold.internal.runtime.Bootstrap;

public interface IJsonIO {
    @DisableStringLiteralTemplates
    public static final String TYPE = "$construct_type";

    public static <E extends IJsonIO> E read(Bindings bindings) {
        return IJsonIO.read(null, bindings);
    }

    public static <E extends IJsonIO> E read(String tag, Bindings bindings) {
        if (tag != null && !tag.isEmpty() && (bindings = (Bindings)bindings.get(tag)) == null) {
            return null;
        }
        String fqn = (String)bindings.get(TYPE);
        try {
            IJsonIO obj = (IJsonIO)Class.forName(fqn).newInstance();
            obj.load(bindings);
            return (E)obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <E extends IJsonIO> void write(E obj, Bindings bindings) {
        IJsonIO.write(null, obj, bindings);
    }

    public static <E extends IJsonIO> void write(String tag, E obj, Bindings bindings) {
        if (obj == null) {
            if (tag != null && !tag.isEmpty()) {
                bindings.put(tag, (Object)obj);
            }
        } else if (tag != null && !tag.isEmpty()) {
            Bindings objBindings = ManifoldHost.createBindings();
            obj.save(objBindings);
            bindings.put(tag, (Object)objBindings);
        } else {
            obj.save(bindings);
        }
    }

    public static <E extends IJsonIO> List<E> readList(Bindings bindings) {
        return IJsonIO.readList(null, bindings);
    }

    public static <E extends IJsonIO> List<E> readList(String tag, Bindings bindings) {
        List list = (List)bindings.get(tag);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<E> objs = list.isEmpty() ? Collections.emptyList() : new ArrayList<E>();
        for (Bindings elem : list) {
            objs.add(IJsonIO.read(elem));
        }
        return objs;
    }

    public static <E extends IJsonIO> void writeList(String tag, List<E> list, Bindings bindings) {
        if (list == null) {
            bindings.put(tag, (Object)null);
        } else if (list.isEmpty()) {
            bindings.put(tag, (Object)Collections.emptyList());
        } else {
            ArrayList<Bindings> blist = new ArrayList<Bindings>();
            for (IJsonIO e : list) {
                Bindings b = ManifoldHost.createBindings();
                e.save(b);
                blist.add(b);
            }
            bindings.put(tag, (Object)blist);
        }
    }

    default public void load(Bindings bindings) {
        Class<?> cls = this.getClass();
        IJsonIO.loadFields(this, cls, bindings);
    }

    default public void save(Bindings bindings) {
        Class<?> cls = this.getClass();
        bindings.put(TYPE, (Object)cls.getName());
        IJsonIO.saveFields(this, cls, bindings);
    }

    public static void loadFields(IJsonIO obj, Class cls, Bindings bindings) {
        Field[] fields;
        for (Field f : fields = cls.getDeclaredFields()) {
            if (f.isSynthetic() || Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                Object value = bindings.get(f.getName());
                if (value instanceof Bindings) {
                    value = IJsonIO.read((Bindings)value);
                } else if (value instanceof List && ((List)value).size() > 0 && ((List)value).get(0) instanceof Bindings) {
                    value = IJsonIO.readList(bindings);
                } else if (f.getType().isEnum() && value instanceof String) {
                    value = Enum.valueOf(f.getType(), (String)value);
                } else if (f.getType() == Boolean.class || f.getType() == Boolean.TYPE) {
                    value = (Integer)value != 0;
                } else if (!IJsonIO.isSimpleType(f.getType())) {
                    throw new UnsupportedOperationException("Unsupported Json type: " + f.getType());
                }
                f.set(obj, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        Class superclass = cls.getSuperclass();
        if (superclass != null) {
            IJsonIO.loadFields(obj, superclass, bindings);
        }
    }

    public static void saveFields(IJsonIO obj, Class cls, Bindings bindings) {
        Field[] fields;
        Class superclass = cls.getSuperclass();
        if (superclass != null) {
            IJsonIO.saveFields(obj, superclass, bindings);
        }
        for (Field f : fields = cls.getDeclaredFields()) {
            if (f.isSynthetic() || Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                Object value = f.get(obj);
                if (IJsonIO.isSimpleType(value)) {
                    bindings.put(f.getName(), value);
                    continue;
                }
                if (value instanceof Enum) {
                    bindings.put(f.getName(), (Object)((Enum)value).name());
                    continue;
                }
                if (value instanceof Boolean) {
                    bindings.put(f.getName(), (Object)((Boolean)value != false ? 1 : 0));
                    continue;
                }
                if (value instanceof List) {
                    if (!((List)value).isEmpty()) {
                        if (IJsonIO.isSimpleType(((List)value).get(0))) {
                            bindings.put(f.getName(), value);
                            continue;
                        }
                        IJsonIO.writeList(f.getName(), (List)value, bindings);
                        continue;
                    }
                    bindings.put(f.getName(), value);
                    continue;
                }
                if (value instanceof IJsonIO) {
                    IJsonIO.write(f.getName(), (IJsonIO)value, bindings);
                    continue;
                }
                throw new UnsupportedOperationException("Type: " + value.getClass() + " does not implement " + IJsonIO.class.getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean isSimpleType(Object value) {
        if (value == null) {
            return true;
        }
        return IJsonIO.isSimpleType(value.getClass());
    }

    public static boolean isSimpleType(Class cls) {
        return cls == null || cls == Integer.TYPE || cls == Long.TYPE || cls == Float.TYPE || cls == Double.TYPE || cls == String.class || cls == Integer.class || cls == Long.class || cls == Float.class || cls == Double.class;
    }

    static {
        Bootstrap.init();
    }
}

