/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import manifold.api.gen.SrcClass;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcGetProperty;
import manifold.api.gen.SrcRawStatement;
import manifold.api.gen.SrcSetProperty;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.json.DynamicType;
import manifold.api.json.IJsonIO;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonImplBase;
import manifold.api.json.JsonListType;
import manifold.api.json.JsonSimpleType;
import manifold.api.json.JsonStructureType;
import manifold.api.type.SourcePosition;
import manifold.internal.runtime.Bootstrap;
import manifold.util.JsonUtil;

public class JsonImplCodeGen {
    private final String _fqn;
    private final JsonStructureType _model;

    JsonImplCodeGen(JsonStructureType model, String topLevelFqn) {
        this._model = model;
        this._fqn = topLevelFqn;
    }

    public SrcClass make() {
        return this.genClass(this._fqn, this._model);
    }

    private SrcClass genClass(String fqnImpl, JsonStructureType model) {
        SrcClass srcClass = ((SrcClass)new SrcClass(fqnImpl, SrcClass.Kind.Class).modifiers(!fqnImpl.equals(this._fqn) ? 8L : 0L)).imports(new Class[]{Bindings.class}).imports(new Class[]{SimpleBindings.class}).imports(new Class[]{IJsonIO.class}).imports(new Class[]{List.class}).imports(new Class[]{SourcePosition.class}).superClass(JsonImplBase.class);
        this.addConstructors(srcClass);
        this.addProperties(srcClass, model);
        this.addInnerTypes(srcClass, model.getInnerTypes());
        return srcClass;
    }

    private void addConstructors(SrcClass srcClass) {
        srcClass.addConstructor(new SrcConstructor().body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("super();"))));
        srcClass.addConstructor(((SrcConstructor)new SrcConstructor().addParam("bindings", Bindings.class.getSimpleName())).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("super(bindings);"))));
    }

    private void addInnerTypes(SrcClass srcClass, Map<String, IJsonParentType> innerClasses) {
        for (Map.Entry<String, IJsonParentType> e : innerClasses.entrySet()) {
            IJsonParentType type = e.getValue();
            if (type instanceof JsonStructureType) {
                String simpleInnerIface = e.getValue().getIdentifier();
                String fqnInnerImpl = srcClass.getPackage() + '.' + srcClass.getSimpleName() + '.' + simpleInnerIface;
                srcClass.addInnerClass(this.genClass(fqnInnerImpl, (JsonStructureType)type));
                continue;
            }
            if (!(type instanceof JsonListType)) continue;
            this.addInnerTypes(srcClass, ((JsonListType)type).getInnerTypes());
        }
    }

    private void addProperties(SrcClass srcClass, JsonStructureType model) {
        Map<String, IJsonType> members = model.getMembers();
        for (Map.Entry<String, IJsonType> e : members.entrySet()) {
            String key = e.getKey();
            String identifier = this.makePropertyName(key);
            IJsonType type = e.getValue();
            String implType = type.getIdentifier();
            if (type instanceof JsonStructureType) {
                srcClass.addGetProperty((SrcGetProperty)new SrcGetProperty(identifier, implType).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return new " + implType + "((" + Bindings.class.getSimpleName() + ")_bindings.get(\"" + key + "\"));")))).addSetProperty((SrcSetProperty)new SrcSetProperty(identifier, Object.class.getSimpleName()).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("_bindings.put(\"" + key + "\", getBindings(" + "$value" + "));"))));
                continue;
            }
            IJsonType componentType = this.getComponentTypeSimple(type);
            if (type instanceof JsonListType && componentType instanceof JsonStructureType) {
                srcClass.addGetProperty((SrcGetProperty)new SrcGetProperty(identifier, implType).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return wrapList((List)_bindings.get(\"" + key + "\"), b ->  new " + componentType.getIdentifier() + "(b));")))).addSetProperty((SrcSetProperty)new SrcSetProperty(identifier, List.class.getSimpleName()).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("_bindings.put(\"" + key + "\", unwrapList(" + "$value" + "));"))));
                continue;
            }
            if (type == DynamicType.instance()) {
                implType = Object.class.getSimpleName();
            }
            srcClass.addGetProperty((SrcGetProperty)new SrcGetProperty(identifier, implType).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("return (" + implType + ")_bindings.get(\"" + key + "\");")))).addSetProperty((SrcSetProperty)new SrcSetProperty(identifier, implType).body(new SrcStatementBlock().addStatement((SrcStatement)new SrcRawStatement().rawText("_bindings.put(\"" + key + "\", " + "$value" + ");"))));
        }
    }

    private String makePropertyName(String key) {
        StringBuilder name = new StringBuilder(JsonUtil.makeIdentifier((String)key));
        char firstChar = name.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            name.setCharAt(0, Character.toUpperCase(firstChar));
        }
        return name.toString();
    }

    private IJsonType getComponentTypeSimple(IJsonType type) {
        if (type instanceof JsonListType) {
            IJsonType componentType = ((JsonListType)type).getComponentType();
            if (componentType instanceof JsonSimpleType) {
                return componentType;
            }
            return this.getComponentTypeSimple(componentType);
        }
        return type;
    }

    static {
        Bootstrap.init();
    }
}

