/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.StringTokenizer;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.host.IModuleComponent;
import manifold.api.json.IJsonParentType;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonModel;
import manifold.api.type.JavaTypeManifold;
import manifold.ext.api.Structural;
import manifold.internal.runtime.Bootstrap;
import manifold.util.ManClassUtil;

public class JsonTypeManifold
extends JavaTypeManifold<JsonModel> {
    public static final String FILE_EXTENSION = "json";

    public void init(IModuleComponent typeLoader) {
        this.init(typeLoader, JsonModel::new, "editor.plugin.typeloader.json.JsonTypeFactory");
    }

    public boolean handlesFileExtension(String fileExtension) {
        return fileExtension.equals(FILE_EXTENSION);
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        IJsonParentType type;
        JsonModel model = (JsonModel)this.getModel(topLevel);
        IJsonParentType iJsonParentType = type = model == null ? null : model.getType();
        if (type == null) {
            return false;
        }
        IJsonParentType csr = type;
        StringTokenizer tokenizer = new StringTokenizer(relativeInner, ".");
        while (tokenizer.hasMoreTokens()) {
            String childName = tokenizer.nextToken();
            IJsonType child = csr.findChild(childName);
            if (child instanceof IJsonParentType) {
                csr = (IJsonParentType)child;
                continue;
            }
            return false;
        }
        return true;
    }

    protected String contribute(String topLevelFqn, String existing, JsonModel model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(ManClassUtil.getPackage((String)topLevelFqn)).append(";\n\n").append("import ").append(Structural.class.getName()).append(";\n\n");
        model.report(errorHandler);
        model.getType().render(sb, 0, true);
        return sb.toString();
    }

    static {
        Bootstrap.init();
    }
}

