/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json;

import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.gen.SrcClass;
import manifold.api.host.IModuleComponent;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonImplCodeGen;
import manifold.api.json.JsonListType;
import manifold.api.json.JsonStructureType;
import manifold.api.json.Model;
import manifold.api.type.JavaTypeManifold;
import manifold.internal.runtime.Bootstrap;
import manifold.util.ManClassUtil;

public class JsonImplTypeManifold
extends JavaTypeManifold<Model> {
    private static final String FILE_EXTENSION = "json";
    private static final Set<String> FILE_EXTENSIONS;
    private static final String IMPL = "impl";

    public void init(IModuleComponent typeLoader) {
        this.init(typeLoader, Model::new);
    }

    public boolean handlesFileExtension(String fileExtension) {
        return FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    protected String getTypeNameForFile(String fqn, IFile file) {
        return JsonImplTypeManifold.makeImplName(fqn);
    }

    static String makeImplName(String fqn) {
        return ManClassUtil.getPackage((String)fqn) + '.' + IMPL + '.' + ManClassUtil.getShortClassName((String)fqn);
    }

    public boolean isInnerType(String topLevel, String relativeInner) {
        JsonStructureType type;
        Model model = (Model)this.getModel(topLevel);
        JsonStructureType jsonStructureType = type = model == null ? null : model.getType();
        if (type == null) {
            return false;
        }
        JsonStructureType csr = type;
        StringTokenizer tokenizer = new StringTokenizer(relativeInner, ".");
        while (tokenizer.hasMoreTokens()) {
            IJsonType componentType;
            String childName = tokenizer.nextToken();
            IJsonType child = csr.findChild(childName);
            if (child instanceof JsonStructureType) {
                csr = (JsonStructureType)child;
                continue;
            }
            if (child instanceof JsonListType && (componentType = ((JsonListType)child).getComponentType()) instanceof JsonStructureType) {
                csr = (JsonStructureType)componentType;
                continue;
            }
            return false;
        }
        return true;
    }

    protected String contribute(String topLevelFqn, String existing, Model model, DiagnosticListener<JavaFileObject> errorHandler) {
        StringBuilder sb = new StringBuilder();
        SrcClass srcClass = new JsonImplCodeGen(model.getType(), topLevelFqn).make();
        model.report(errorHandler);
        srcClass.render(sb, 0);
        return sb.toString();
    }

    static {
        Bootstrap.init();
        FILE_EXTENSIONS = Collections.singleton(FILE_EXTENSION);
    }
}

