/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.json.schema;

import java.util.List;
import javax.script.Bindings;
import manifold.api.json.DynamicType;
import manifold.api.json.ErrantType;
import manifold.api.json.IJsonType;
import manifold.api.json.JsonIssue;
import manifold.api.json.JsonListType;
import manifold.api.json.Token;
import manifold.api.json.schema.JsonSchemaTransformer;
import manifold.api.json.schema.JsonSchemaType;
import manifold.internal.javac.IIssue;
import manifold.internal.runtime.Bootstrap;
import manifold.util.Pair;

class ArrayTransformer {
    private static final String JSCH_ITEMS = "items";
    private final JsonSchemaTransformer _schemaTx;
    private final String _name;
    private final JsonListType _type;
    private final Bindings _jsonObj;

    static JsonListType transform(JsonSchemaTransformer schemaTx, String name, JsonListType type, Bindings jsonObj) {
        ArrayTransformer arrayTx = new ArrayTransformer(schemaTx, name, type, jsonObj);
        return arrayTx.transform();
    }

    private ArrayTransformer(JsonSchemaTransformer schemaTx, String name, JsonListType type, Bindings jsonObj) {
        this._schemaTx = schemaTx;
        this._name = name;
        this._jsonObj = jsonObj;
        this._type = type;
    }

    JsonListType getType() {
        return this._type;
    }

    private JsonListType transform() {
        JsonSchemaType parent = this._type.getParent();
        if (parent != null) {
            parent.addChild(this._type.getLabel(), this._type);
        }
        this.assignComponentType();
        this._schemaTx.cacheByFqn(this._type);
        return this._type;
    }

    private void assignComponentType() {
        Object items;
        IJsonType componentType = null;
        Object value = this._jsonObj.get(JSCH_ITEMS);
        Token[] tokens = null;
        if (value instanceof Pair) {
            items = ((Pair)value).getSecond();
            tokens = (Token[])((Pair)value).getFirst();
        } else {
            items = value;
        }
        if (items instanceof List) {
            for (Object elem : (List)items) {
                IJsonType csr = this._schemaTx.transformType(this._type, this._type.getFile(), this._name, (Bindings)elem);
                if (componentType == null) {
                    componentType = csr;
                    continue;
                }
                if (csr.equals(componentType)) continue;
                componentType = DynamicType.instance();
                break;
            }
        } else if (items instanceof Bindings) {
            componentType = this._schemaTx.transformType(this._type, this._type.getFile(), this._name, (Bindings)items);
        } else {
            this._type.addIssue(new JsonIssue(IIssue.Kind.Error, tokens != null ? tokens[1] : null, "Expecting '{' or '[' for object or array to contain array component type"));
            componentType = new ErrantType(this._type.getFile(), "Errant");
        }
        this._type.setComponentType(componentType);
    }

    static {
        Bootstrap.init();
    }
}

