/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.api;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import manifold.ext.rt.RuntimeMethods;
import manifold.json.rt.Json;
import manifold.json.rt.api.IJsonBindingsBacked;

public class Serializer
implements Externalizable {
    private String _interface;
    private String _json;

    public Serializer() {
    }

    public Serializer(IJsonBindingsBacked jsonBindingsBacked) {
        Class<?>[] interfaces = jsonBindingsBacked.getClass().getInterfaces();
        assert (interfaces.length == 1);
        this._interface = interfaces[0].getTypeName();
        this._json = jsonBindingsBacked.write().toJson();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._interface);
        out.writeObject(this._json);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._interface = (String)in.readObject();
        this._json = (String)in.readObject();
    }

    Object readResolve() throws ObjectStreamException {
        try {
            Class<?> iface = Class.forName(this._interface);
            return RuntimeMethods.coerceFromBindingsValue((Object)Json.fromJson(this._json), iface);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

