/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt.api;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import manifold.json.rt.Json;
import manifold.json.rt.api.IJsonList;

public class JsonList<T>
implements IJsonList<T>,
Serializable {
    private List _list;
    private Class<T> _finalComponentType;

    public JsonList() {
        this._list = new ArrayList();
        this._finalComponentType = Object.class;
    }

    public JsonList(Class<T> finalComponentType) {
        this._list = new ArrayList();
        this._finalComponentType = finalComponentType;
    }

    public JsonList(List jsonList, Class<T> finalComponentType) {
        this._list = jsonList;
        this._finalComponentType = finalComponentType;
    }

    public List getList() {
        return this._list;
    }

    public Class<?> getFinalComponentType() {
        return this._finalComponentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return Objects.equals(this._list, o);
    }

    public int hashCode() {
        return Objects.hash(this._list);
    }

    public String toString() {
        return this._list.toString();
    }

    private Object writeReplace() {
        return new Serializer(this);
    }

    public static class Serializer<T>
    implements Externalizable {
        private Class<T> _type;
        private String _json;

        public Serializer() {
        }

        Serializer(JsonList<T> jsonList) {
            this._json = Json.toJson(jsonList);
            this._type = ((JsonList)jsonList)._finalComponentType;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this._type);
            out.writeObject(this._json);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._type = (Class)in.readObject();
            this._json = (String)in.readObject();
        }

        Object readResolve() throws ObjectStreamException {
            List list = (List)Json.fromJson(this._json);
            return new JsonList<T>(list, this._type);
        }
    }
}

