/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import manifold.ext.rt.RuntimeMethods;
import manifold.ext.rt.api.IBindingType;
import manifold.ext.rt.api.ICallHandler;
import manifold.json.rt.api.IJsonFormatTypeCoercer;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class DefaultCoercer
implements IJsonFormatTypeCoercer {
    private final LocklessLazyVar<Map<String, Class<?>>> _formatToType = LocklessLazyVar.make(() -> new HashMap<String, Class<?>>(){
        {
            this.put("date-time", LocalDateTime.class);
            this.put("date", LocalDate.class);
            this.put("time", LocalTime.class);
            this.put("full-date", LocalDateTime.class);
            this.put("utc-millisec", Instant.class);
            this.put("int64", Long.class);
        }
    });

    @Override
    public Map<String, Class<?>> getFormats() {
        return (Map)this._formatToType.get();
    }

    public Object coerce(Object value, Class<?> type) {
        Object v;
        if (type.isEnum() && (v = this.coerceEnum(value, type)) != ICallHandler.UNHANDLED) {
            return v;
        }
        if (type == LocalDateTime.class) {
            return LocalDateTime.parse(String.valueOf(value), DateTimeFormatter.ISO_DATE_TIME);
        }
        if (type == LocalDate.class) {
            return LocalDate.parse(String.valueOf(value), DateTimeFormatter.ISO_DATE);
        }
        if (type == LocalTime.class) {
            return LocalTime.parse(String.valueOf(value), DateTimeFormatter.ISO_TIME);
        }
        if (type == Instant.class) {
            if (!(value instanceof Number)) {
                value = Long.valueOf(String.valueOf(value));
            }
            long millis = ((Number)value).longValue();
            long secs = millis / 1000L;
            return Instant.ofEpochSecond(secs, (millis - secs * 1000L) * 1000000L);
        }
        if (type == Long.class || type == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return Long.valueOf(String.valueOf(value));
            }
        }
        if ((value instanceof LocalDateTime || value instanceof LocalDate || value instanceof LocalTime) && type == String.class) {
            return value.toString();
        }
        if (value instanceof Instant) {
            if (Number.class.isAssignableFrom(type)) {
                return RuntimeMethods.coerce((Object)((Instant)value).toEpochMilli(), type);
            }
            if (type == String.class) {
                return value.toString();
            }
        }
        if (type == String.class && value instanceof Long) {
            return String.valueOf(value);
        }
        return ICallHandler.UNHANDLED;
    }

    public Object toBindingValue(Object value) {
        if (value instanceof IBindingType) {
            return ((IBindingType)value).toBindingValue();
        }
        if (value instanceof LocalDateTime || value instanceof LocalDate || value instanceof LocalTime) {
            return value.toString();
        }
        if (value instanceof Instant) {
            return ((Instant)value).toEpochMilli();
        }
        return ICallHandler.UNHANDLED;
    }

    private Object coerceEnum(Object value, Class<?> type) {
        if (IBindingType.class.isAssignableFrom(type) && IBindingType.class.isAssignableFrom(type)) {
            IBindingType[] values;
            for (IBindingType enumConst : values = (IBindingType[])ReflectUtil.method(type, (String)"values", (Class[])new Class[0]).invokeStatic(new Object[0])) {
                Object coercedValue;
                Object jsonValue = enumConst.toBindingValue();
                if (!jsonValue.equals(coercedValue = RuntimeMethods.coerce((Object)value, jsonValue.getClass()))) continue;
                return enumConst;
            }
        }
        return ICallHandler.UNHANDLED;
    }
}

