/*
 * Decompiled with CFR 0.152.
 */
package manifold.json.rt;

import java.util.HashMap;
import java.util.Map;
import manifold.ext.rt.api.ICallHandler;
import manifold.json.rt.api.Base64Encoding;
import manifold.json.rt.api.IJsonFormatTypeCoercer;
import manifold.json.rt.api.OctetEncoding;

public class BinaryCoercer
implements IJsonFormatTypeCoercer {
    private static final Map<String, Class<?>> ALL = new HashMap<String, Class<?>>(){
        {
            this.put("binary", OctetEncoding.class);
            this.put("byte", Base64Encoding.class);
        }
    };

    @Override
    public Map<String, Class<?>> getFormats() {
        return ALL;
    }

    public Object coerce(Object value, Class<?> type) {
        if (type == OctetEncoding.class && value instanceof String) {
            return OctetEncoding.encoded((String)value);
        }
        if (type == Base64Encoding.class && value instanceof String) {
            return Base64Encoding.encoded((String)value);
        }
        if ((value instanceof OctetEncoding || value instanceof Base64Encoding) && type == String.class) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }

    public Object toBindingValue(Object value) {
        if (value instanceof OctetEncoding || value instanceof Base64Encoding) {
            return value.toString();
        }
        return ICallHandler.UNHANDLED;
    }
}

