/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import manifold.ExtIssueMsg;
import manifold.api.fs.IFile;
import manifold.api.fs.IFileFragment;
import manifold.api.host.IManifoldHost;
import manifold.api.host.IModule;
import manifold.api.type.ContributorKind;
import manifold.api.type.FragmentValue;
import manifold.api.type.ITypeManifold;
import manifold.api.type.IncrementalCompile;
import manifold.api.type.Precompile;
import manifold.api.util.Pair;
import manifold.ext.ExtensionManifold;
import manifold.ext.ExtensionMethod;
import manifold.ext.ReflectionRuntimeMethods;
import manifold.ext.RuntimeMethods;
import manifold.ext.StructuralTypeEraser;
import manifold.ext.TypeUtil;
import manifold.ext.api.Extension;
import manifold.ext.api.Jailbreak;
import manifold.ext.api.Self;
import manifold.ext.api.Structural;
import manifold.ext.api.This;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.FragmentProcessor;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.HostKind;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.TypeProcessor;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.ConcurrentHashSet;

public class ExtensionTransformer
extends TreeTranslator {
    private final ExtensionManifold _sp;
    private final TypeProcessor _tp;
    private boolean _bridgeMethod;

    ExtensionTransformer(ExtensionManifold sp, TypeProcessor typeProcessor) {
        this._sp = sp;
        this._tp = typeProcessor;
    }

    public TypeProcessor getTypeProcessor() {
        return this._tp;
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        super.visitIdent(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (TypeUtil.isStructuralInterface(this._tp, tree.sym) && !this.isReceiver(tree)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            Tree parent = this._tp.getParent((Tree)tree);
            JCTree.JCIdent objIdent = this._tp.getTreeMaker().Ident(objectSym);
            if (parent instanceof JCTree.JCVariableDecl) {
                ((JCTree.JCVariableDecl)parent).type = objectSym.type;
                long parameterModifier = 0x200000000L;
                if ((((JCTree.JCVariableDecl)parent).mods.flags & parameterModifier) != 0L) {
                    objIdent.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).sym.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).vartype = objIdent;
                }
            } else if (parent instanceof JCTree.JCWildcard) {
                JCTree.JCWildcard wildcard = (JCTree.JCWildcard)parent;
                wildcard.type = new Type.WildcardType(objectSym.type, wildcard.kind.kind, wildcard.type.tsym);
            }
            tree = objIdent;
            tree.type = objectSym.type;
        }
        this.result = tree;
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        super.visitLambda(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        tree.type = this.eraseStructureType(tree.type);
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type target : IDynamicJdk.instance().getTargets(tree)) {
            types.add(this.eraseStructureType(target));
        }
        IDynamicJdk.instance().setTargets(tree, List.from(types));
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        super.visitSelect(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (TypeUtil.isStructuralInterface(this._tp, tree.sym) && !this.isReceiver(tree)) {
            Symbol.ClassSymbol objectSym = this.getObjectClass();
            JCTree.JCIdent objIdent = this._tp.getTreeMaker().Ident(objectSym);
            Tree parent = this._tp.getParent((Tree)tree);
            if (parent instanceof JCTree.JCVariableDecl) {
                ((JCTree.JCVariableDecl)parent).type = objectSym.type;
                long parameterModifier = 0x200000000L;
                if ((((JCTree.JCVariableDecl)parent).mods.flags & parameterModifier) != 0L) {
                    objIdent.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).sym.type = objectSym.type;
                    ((JCTree.JCVariableDecl)parent).vartype = objIdent;
                }
            } else if (parent instanceof JCTree.JCWildcard) {
                JCTree.JCWildcard wildcard = (JCTree.JCWildcard)parent;
                wildcard.type = new Type.WildcardType(objectSym.type, wildcard.kind.kind, wildcard.type.tsym);
            }
            this.result = objIdent;
        } else {
            this.result = ExtensionTransformer.isJailbreakReceiver(tree) ? this.replaceWithReflection(tree) : tree;
        }
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        super.visitAssign(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        this.result = ExtensionTransformer.isJailbreakReceiver(tree) ? this.replaceWithReflection(tree) : tree;
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        super.visitAssignop(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (ExtensionTransformer.isJailbreakReceiver(tree)) {
            this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_COMPOUND_OP_NOT_ALLOWED_REFLECTION.get(new Object[0]));
            Types types = Types.instance(((BasicJavacTask)this._tp.getJavacTask()).getContext());
            tree.type = types.createErrorType(tree.type);
            this.result = tree;
        } else {
            this.result = tree;
        }
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        super.visitUnary(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        if (ExtensionTransformer.isJailbreakReceiver(tree)) {
            Tree.Kind kind = tree.getKind();
            if (kind == Tree.Kind.POSTFIX_INCREMENT || kind == Tree.Kind.POSTFIX_DECREMENT || kind == Tree.Kind.PREFIX_INCREMENT || kind == Tree.Kind.PREFIX_DECREMENT) {
                this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_INCREMENT_OP_NOT_ALLOWED_REFLECTION.get(new Object[0]));
                Types types = Types.instance(((BasicJavacTask)this._tp.getJavacTask()).getContext());
                tree.type = types.createErrorType(tree.type);
            }
            this.result = tree;
        } else {
            this.result = tree;
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        super.visitNewClass(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        this.result = ExtensionTransformer.isJailbreakReceiver(tree) ? this.replaceWithReflection(tree) : tree;
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        super.visitVarDef(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        JCTree.JCExpression vartype = tree.vartype;
        if (vartype instanceof JCTree.JCAnnotatedType && ((JCTree.JCAnnotatedType)tree.vartype).getAnnotations().stream().anyMatch(anno -> Jailbreak.class.getTypeName().equals(anno.attribute.type.toString()))) {
            tree.type = ((JCTree.JCAnnotatedType)tree.vartype).underlyingType.type;
            tree.sym.type = this._tp.getSymtab().objectType;
        }
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        super.visitTypeCast(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            this.eraseCompilerGeneratedCast(tree);
            return;
        }
        if (TypeUtil.isStructuralInterface(this._tp, tree.type.tsym)) {
            tree.expr = this.replaceCastExpression(tree.getExpression(), tree.type);
            tree.type = this.getObjectClass().type;
        }
        this.result = tree;
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        super.visitLiteral(tree);
        if (this._tp.isGenerate() && !this.shouldProcessForGeneration()) {
            return;
        }
        this.result = tree.typetag.getKindLiteral() == Tree.Kind.STRING_LITERAL ? this.replaceStringLiteral(tree) : tree;
    }

    private JCTree replaceStringLiteral(JCTree.JCLiteral tree) {
        String literal = (String)tree.getValue();
        if (!literal.contains("[>") || !literal.contains("<]")) {
            return tree;
        }
        JCTree.JCClassDecl enclosingClass = this.getEnclosingClass(tree);
        try {
            CharSequence source = enclosingClass.sym.sourcefile.getCharContent(true);
            CharSequence chars = source.subSequence(tree.pos().getStartPosition(), tree.pos().getEndPosition(((JCTree.JCCompilationUnit)this._tp.getCompilationUnit()).endPositions));
            FragmentProcessor.Fragment fragment = FragmentProcessor.instance().parseFragment(tree.pos().getStartPosition(), chars.toString(), chars.length() > 3 && chars.charAt(1) == '\"' ? HostKind.TEXT_BLOCK_LITERAL : HostKind.DOUBLE_QUOTE_LITERAL);
            if (fragment != null) {
                String fragClass = enclosingClass.sym.packge().toString() + '.' + fragment.getName();
                Symbol.ClassSymbol fragSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), fragClass);
                for (Attribute.Compound annotation : fragSym.getAnnotationMirrors()) {
                    if (!annotation.type.toString().equals(FragmentValue.class.getName())) continue;
                    return this.replaceStringLiteral(fragSym, tree, annotation);
                }
            }
        }
        catch (IOException e) {
            System.err.print("WARNING: ");
            e.printStackTrace();
        }
        return tree;
    }

    private JCTree replaceStringLiteral(Symbol.ClassSymbol fragSym, JCTree.JCLiteral tree, Attribute.Compound attribute) {
        if (attribute == null) {
            return tree;
        }
        String methodName = null;
        String type = null;
        for (com.sun.tools.javac.util.Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (((Name)argName).toString().equals("methodName")) {
                methodName = (String)((Attribute)pair.snd).getValue();
                continue;
            }
            if (!((Name)argName).toString().equals("type")) continue;
            type = (String)((Attribute)pair.snd).getValue();
        }
        if (type != null) {
            return this.replaceStringLiteral(fragSym, tree, methodName, type);
        }
        return tree;
    }

    private JCTree.JCExpression replaceStringLiteral(Symbol.ClassSymbol fragSym, JCTree tree, String methodName, String type) {
        TreeMaker make = this._tp.getTreeMaker();
        Names names = Names.instance(this._tp.getContext());
        Symbol.MethodSymbol fragmentValueMethod = this.resolveMethod(tree.pos(), names.fromString(methodName), fragSym.type, List.nil());
        JCTree.JCMethodInvocation fragmentValueCall = make.Apply(List.nil(), this.memberAccess(make, this._tp.getElementUtil(), fragSym.getQualifiedName() + "." + methodName), List.nil());
        fragmentValueCall.type = fragmentValueMethod.getReturnType();
        fragmentValueCall.setPos(tree.pos);
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)fragmentValueCall.getMethodSelect();
        newMethodSelect.sym = fragmentValueMethod;
        newMethodSelect.type = fragmentValueMethod.type;
        this.assignTypes(newMethodSelect.selected, fragSym);
        return fragmentValueCall;
    }

    private void eraseCompilerGeneratedCast(JCTree.JCTypeCast tree) {
        if (TypeUtil.isStructuralInterface(this._tp, tree.type.tsym) && !this.isConstructProxyCall(tree.getExpression())) {
            tree.type = this.getObjectClass().type;
            TreeMaker make = this._tp.getTreeMaker();
            tree.clazz = make.Type(this.getObjectClass().type);
        }
    }

    private boolean isConstructProxyCall(JCTree.JCExpression expression) {
        if (expression instanceof JCTree.JCMethodInvocation) {
            JCTree.JCExpression meth = ((JCTree.JCMethodInvocation)expression).meth;
            return meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)meth).getIdentifier().toString().equals("constructProxy");
        }
        return expression instanceof JCTree.JCTypeCast && this.isConstructProxyCall(((JCTree.JCTypeCast)expression).getExpression());
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        super.visitApply(tree);
        this.eraseGenericStructuralVarargs(tree);
        if (this._tp.isGenerate()) {
            return;
        }
        Symbol.MethodSymbol method = this.findExtMethod(tree);
        this.result = method != null ? this.replaceExtCall(tree, method) : (this.isStructuralMethod(tree) ? this.replaceStructuralCall(tree) : (ExtensionTransformer.isJailbreakReceiver(tree) ? this.replaceWithReflection(tree) : tree));
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        super.visitReference(tree);
        if (this.isExtensionMethod(tree.sym)) {
            this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_EXTENSION_METHOD_REF_NOT_SUPPORTED.get(new Object[]{tree.sym.flatName()}));
        } else if (this.isStructuralMethod(tree.sym)) {
            this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_STRUCTURAL_METHOD_REF_NOT_SUPPORTED.get(new Object[]{tree.sym.flatName()}));
        }
    }

    private boolean isStructuralMethod(Symbol sym) {
        if (sym != null && !sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC) && !this.isObjectMethod(sym)) {
            return TypeUtil.isStructuralInterface(this._tp, sym.owner);
        }
        return false;
    }

    private boolean isExtensionMethod(Symbol sym) {
        if (sym instanceof Symbol.MethodSymbol) {
            for (Attribute.Compound annotation : sym.getAnnotationMirrors()) {
                if (!annotation.type.toString().equals(ExtensionMethod.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJailbreakReceiver(JCTree tree) {
        if (tree instanceof JCTree.JCMethodInvocation) {
            JCTree.JCExpression methodSelect = ((JCTree.JCMethodInvocation)tree).getMethodSelect();
            if (methodSelect instanceof JCTree.JCFieldAccess) {
                return ExtensionTransformer.isJailbreakReceiver((JCTree.JCFieldAccess)methodSelect);
            }
        } else {
            if (tree instanceof JCTree.JCFieldAccess) {
                return ExtensionTransformer.isJailbreakReceiver((JCTree.JCFieldAccess)tree);
            }
            if (tree instanceof JCTree.JCAssign) {
                JCTree.JCExpression lhs = ((JCTree.JCAssign)tree).lhs;
                if (lhs instanceof JCTree.JCFieldAccess) {
                    return ExtensionTransformer.isJailbreakReceiver(lhs);
                }
            } else if (tree instanceof JCTree.JCAssignOp) {
                JCTree.JCExpression lhs = ((JCTree.JCAssignOp)tree).lhs;
                if (lhs instanceof JCTree.JCFieldAccess) {
                    return ExtensionTransformer.isJailbreakReceiver(lhs);
                }
            } else if (tree instanceof JCTree.JCUnary) {
                JCTree.JCExpression arg = ((JCTree.JCUnary)tree).arg;
                if (arg instanceof JCTree.JCFieldAccess) {
                    return ExtensionTransformer.isJailbreakReceiver(arg);
                }
            } else if (tree instanceof JCTree.JCVariableDecl) {
                JCTree.JCExpression initializer = ((JCTree.JCVariableDecl)tree).init;
                if (initializer instanceof JCTree.JCFieldAccess) {
                    return ExtensionTransformer.isJailbreakReceiver(initializer);
                }
            } else if (tree instanceof JCTree.JCNewClass) {
                return ExtensionTransformer.isJailbreakReceiver((JCTree.JCNewClass)tree);
            }
        }
        return false;
    }

    public static boolean isJailbreakReceiver(JCTree.JCFieldAccess fieldAccess) {
        Symbol sym = null;
        JCTree.JCExpression selected = fieldAccess.selected;
        if (selected instanceof JCTree.JCIdent) {
            sym = ((JCTree.JCIdent)selected).sym;
        } else if (selected instanceof JCTree.JCMethodInvocation) {
            if (((JCTree.JCMethodInvocation)selected).meth instanceof JCTree.JCFieldAccess) {
                sym = ((JCTree.JCFieldAccess)((JCTree.JCMethodInvocation)selected).meth).sym;
            } else if (((JCTree.JCMethodInvocation)selected).meth instanceof JCTree.JCIdent) {
                sym = ((JCTree.JCIdent)((JCTree.JCMethodInvocation)selected).meth).sym;
            }
        }
        return ExtensionTransformer.isJailbreakSymbol(sym);
    }

    public static boolean isJailbreakSymbol(Symbol sym) {
        if (sym == null) {
            return false;
        }
        SymbolMetadata metadata = sym.getMetadata();
        if (metadata == null || metadata.isTypesEmpty() && metadata.isEmpty()) {
            return false;
        }
        List<Attribute.TypeCompound> typeAttributes = metadata.getTypeAttributes();
        if (!typeAttributes.isEmpty()) {
            return typeAttributes.stream().anyMatch(attr -> attr.type.toString().equals(Jailbreak.class.getTypeName()));
        }
        List<Attribute.Compound> attributes = metadata.getDeclarationAttributes();
        if (!attributes.isEmpty()) {
            return attributes.stream().anyMatch(attr -> attr.type.toString().equals(Jailbreak.class.getTypeName()));
        }
        return false;
    }

    private static boolean isJailbreakReceiver(JCTree.JCNewClass newExpr) {
        JCTree.JCExpression classExpr = newExpr.clazz;
        if (classExpr instanceof JCTree.JCAnnotatedType) {
            return ((JCTree.JCAnnotatedType)classExpr).annotations.stream().anyMatch(e -> Jailbreak.class.getTypeName().equals(e.attribute.type.toString()));
        }
        return false;
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        super.visitAnnotation(tree);
        if (!Self.class.getTypeName().equals(tree.getAnnotationType().type.tsym.toString())) {
            return;
        }
        if (!this.isSelfInMethodDeclOrFieldDecl(tree, tree)) {
            this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_SELF_NOT_ALLOWED_HERE.get(new Object[0]));
        } else {
            this.verifySelfOnThis(tree, tree);
        }
    }

    private void verifySelfOnThis(JCTree annotated, JCTree.JCAnnotation selfAnno) {
        String fqn;
        if (annotated instanceof JCTree.JCAnnotatedType) {
            fqn = ((JCTree.JCAnnotatedType)annotated).getUnderlyingType().type.tsym.getQualifiedName().toString();
        } else if (annotated instanceof JCTree.JCMethodDecl) {
            fqn = ((JCTree.JCMethodDecl)annotated).getReturnType().type.tsym.getQualifiedName().toString();
        } else {
            return;
        }
        try {
            JCTree.JCClassDecl enclosingClass = this._tp.getClassDecl((Tree)annotated);
            if (!this.isDeclaringClassOrExtension(annotated, fqn, enclosingClass) && !fqn.equals("Array")) {
                this._tp.report((JCTree)selfAnno, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_SELF_NOT_ON_CORRECT_TYPE.get(new Object[]{fqn, enclosingClass.sym.getQualifiedName()}));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isDeclaringClassOrExtension(JCTree annotated, String fqn, JCTree.JCClassDecl enclosingClass) {
        if (enclosingClass.sym.getQualifiedName().toString().equals(fqn) || this._tp.getTypes().isAssignable((Type)IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), fqn).asType(), enclosingClass.sym.type)) {
            return true;
        }
        return this.isOnExtensionMethod(annotated, fqn, enclosingClass);
    }

    private boolean isOnExtensionMethod(JCTree annotated, String fqn, JCTree.JCClassDecl enclosingClass) {
        JCTree.JCMethodDecl declMethod;
        String extendedClassName;
        if (this.isExtensionClass(enclosingClass) && (extendedClassName = this.getExtendedClassName()) != null && extendedClassName.equals(fqn) && (declMethod = this.findDeclMethod(annotated)) != null) {
            java.util.List parameters = declMethod.getParameters();
            for (JCTree.JCVariableDecl param : parameters) {
                if (!this.hasAnnotation((List<JCTree.JCAnnotation>)param.getModifiers().getAnnotations(), This.class)) continue;
                return true;
            }
        }
        return false;
    }

    private JCTree.JCMethodDecl findDeclMethod(Tree annotated) {
        if (annotated == null) {
            return null;
        }
        if (annotated instanceof JCTree.JCMethodDecl) {
            return (JCTree.JCMethodDecl)annotated;
        }
        return this.findDeclMethod(this._tp.getParent(annotated));
    }

    private boolean isSelfInMethodDeclOrFieldDecl(Tree tree, JCTree.JCAnnotation anno) {
        Tree container;
        if (tree == null) {
            return false;
        }
        Tree parent = this._tp.getParent(tree);
        if (parent instanceof JCTree.JCTypeParameter) {
            return false;
        }
        if (parent instanceof JCTree.JCMethodDecl) {
            return !((JCTree.JCMethodDecl)parent).getModifiers().getFlags().contains((Object)javax.lang.model.element.Modifier.STATIC) || this.isExtensionClass(this.getEnclosingClass(parent));
        }
        if (parent instanceof JCTree.JCVariableDecl && (container = this._tp.getParent(parent)) instanceof JCTree.JCClassDecl) {
            return !((JCTree.JCVariableDecl)parent).getModifiers().getFlags().contains((Object)javax.lang.model.element.Modifier.STATIC) || this.isExtensionClass(this.getEnclosingClass(parent));
        }
        return this.isSelfInMethodDeclOrFieldDecl(parent, anno);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        super.visitClassDef(tree);
        this.verifyExtensionInterfaces(tree);
        this.checkExtensionClassError(tree);
        this.precompileClasses(tree);
        this.incrementalCompileClasses(tree);
    }

    private void precompileClasses(JCTree.JCClassDecl tree) {
        HashMap<String, Set<String>> typeNames = new HashMap<String, Set<String>>();
        for (JCTree.JCAnnotation anno : tree.getModifiers().getAnnotations()) {
            if (!anno.getAnnotationType().type.toString().equals(Precompile.class.getCanonicalName())) continue;
            this.getTypesToCompile(anno, typeNames);
        }
        if (!typeNames.isEmpty()) {
            this.precompile(typeNames);
        }
    }

    private void getTypesToCompile(JCTree.JCAnnotation precompileAnno, Map<String, Set<String>> typeNames) {
        Attribute.Compound attribute = precompileAnno.attribute;
        if (attribute == null) {
            return;
        }
        String typeManifoldClassName = null;
        String regex = ".*";
        String ext = "*";
        for (com.sun.tools.javac.util.Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            switch (((Name)argName).toString()) {
                case "typeManifold": {
                    typeManifoldClassName = ((Attribute)pair.snd).getValue().toString();
                    break;
                }
                case "fileExtension": {
                    ext = ((Attribute)pair.snd).getValue().toString();
                    break;
                }
                case "typeNames": {
                    regex = ((Attribute)pair.snd).getValue().toString();
                }
            }
        }
        this.addToPrecompile(typeNames, typeManifoldClassName, ext, regex);
    }

    private void addToPrecompile(Map<String, Set<String>> typeNames, String typeManifoldClassName, String ext, String regex) {
        if (typeManifoldClassName != null) {
            Set regexes = typeNames.computeIfAbsent(typeManifoldClassName, tm -> new HashSet());
            regexes.add(regex);
        } else {
            boolean all = "*".equals(ext);
            this._tp.getHost().getSingleModule().getTypeManifolds().stream().filter(tm -> tm.getContributorKind() != ContributorKind.Supplemental).forEach(tm -> {
                boolean match;
                boolean bl = match = !all && tm.handlesFileExtension(ext);
                if (all || match) {
                    String classname = tm.getClass().getTypeName();
                    Set regexes = typeNames.computeIfAbsent(classname, e -> new HashSet());
                    regexes.add(regex);
                }
            });
        }
    }

    private void precompile(Map<String, Set<String>> typeNames) {
        for (ITypeManifold tm : this._tp.getHost().getSingleModule().getTypeManifolds()) {
            for (Map.Entry<String, Set<String>> entry : typeNames.entrySet()) {
                String typeManifoldClassName = entry.getKey();
                if (!tm.getClass().getName().equals(typeManifoldClassName)) continue;
                Collection<String> namesToPrecompile = this.computeNamesToPrecompile(tm.getAllTypeNames(), entry.getValue());
                for (String fqn : namesToPrecompile) {
                    IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), fqn);
                }
            }
        }
    }

    private Collection<String> computeNamesToPrecompile(Collection<String> allTypeNames, Set<String> regexes) {
        HashSet<String> matchingTypes = new HashSet<String>();
        for (String fqn : allTypeNames) {
            if (!regexes.stream().anyMatch(fqn::matches)) continue;
            matchingTypes.add(fqn);
        }
        return matchingTypes;
    }

    private void incrementalCompileClasses(JCTree.JCClassDecl tree) {
        if (this._tp.isGenerate()) {
            return;
        }
        Set<Object> drivers = this.findDrivers(tree);
        this.addCompiledResourceTypeByFile(drivers, tree);
        this.incrementalCompile(drivers);
    }

    private Set<Object> findDrivers(JCTree.JCClassDecl tree) {
        HashSet<Object> drivers = new HashSet<Object>();
        for (JCTree.JCAnnotation anno : tree.getModifiers().getAnnotations()) {
            if (!anno.getAnnotationType().type.toString().equals(IncrementalCompile.class.getCanonicalName())) continue;
            this.getIncrementalCompileDrivers(anno, drivers);
        }
        this._tp.addDrivers(drivers);
        this.addFileFragmentDriver();
        return this._tp.getDrivers();
    }

    private void addFileFragmentDriver() {
        Class type = ReflectUtil.type((String)"manifold.ij.jps.IjFileFragmentIncrementalCompileDriver");
        if (type != null) {
            Object driver = ReflectUtil.method((Class)type, (String)"getInstance", (Class[])new Class[0]).invokeStatic(new Object[0]);
            this._tp.addDrivers(Collections.singleton(driver));
        }
    }

    private void getIncrementalCompileDrivers(JCTree.JCAnnotation anno, Set<Object> drivers) {
        Attribute.Compound attribute = anno.attribute;
        if (attribute == null) {
            return;
        }
        String fqnDriver = null;
        Integer driverId = null;
        for (com.sun.tools.javac.util.Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (((Name)argName).toString().equals("driverInstance")) {
                driverId = (int)((Integer)((Attribute)pair.snd).getValue());
                continue;
            }
            if (!((Name)argName).toString().equals("driverClass")) continue;
            fqnDriver = (String)((Attribute)pair.snd).getValue();
        }
        if (driverId != null) {
            Object driver = ReflectUtil.method(fqnDriver, (String)"getInstance", (Class[])new Class[]{Integer.TYPE}).invokeStatic(new Object[]{driverId});
            drivers.add(driver);
        }
    }

    private void incrementalCompile(Set<Object> drivers) {
        for (Object driver : drivers) {
            Collection changedFiles = (Collection)ReflectUtil.method((Object)driver, (String)"getChangedFiles", (Class[])new Class[0]).invoke(new Object[0]);
            if (changedFiles == null || changedFiles.isEmpty()) continue;
            IManifoldHost host = this._tp.getHost();
            Set changes = changedFiles.stream().map(f -> host.getFileSystem().getIFile(f)).collect(Collectors.toSet());
            for (ITypeManifold tm : host.getSingleModule().getTypeManifolds()) {
                for (IFile file : changes) {
                    Set types = Arrays.stream(tm.getTypesForFile(file)).collect(Collectors.toSet());
                    if (types.size() <= 0) continue;
                    ReflectUtil.method((Object)driver, (String)"mapTypesToFile", (Class[])new Class[]{Set.class, File.class}).invoke(new Object[]{types, file.toJavaFile()});
                    for (String fqn : types) {
                        Symbol.ClassSymbol classSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), fqn);
                        assert (classSym != null);
                        changedFiles.remove(file.toJavaFile());
                    }
                }
            }
        }
    }

    private void addCompiledResourceTypeByFile(Set<Object> drivers, JCTree.JCClassDecl tree) {
        if (tree.sym == null) {
            return;
        }
        Name qualifiedName = tree.sym.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        JavaFileObject sourcefile = tree.sym.sourcefile;
        if (!(sourcefile instanceof GeneratedJavaStubFileObject)) {
            return;
        }
        Set resourceFiles = ((GeneratedJavaStubFileObject)sourcefile).getResourceFiles();
        for (IFile ifile : resourceFiles) {
            File file;
            try {
                while (ifile instanceof IFileFragment) {
                    ifile = ((IFileFragment)ifile).getEnclosingFile();
                }
                file = ifile.toJavaFile();
            }
            catch (Exception e) {
                continue;
            }
            Map typesCompiledByFile = this._tp.getTypesCompiledByFile();
            Set types = (Set)typesCompiledByFile.get(file);
            if (types == null) {
                types = new ConcurrentHashSet();
                typesCompiledByFile.put(file, types);
            }
            StringBuilder sb = new StringBuilder();
            this.make$name(tree.sym, sb);
            types.add(sb.toString());
        }
        this.addIndirectCompiledTypesToBuildForMapping(drivers);
    }

    private void make$name(Symbol.ClassSymbol sym, StringBuilder sb) {
        Element enclosingElement = sym.getEnclosingElement();
        if (enclosingElement instanceof Symbol.ClassSymbol) {
            this.make$name((Symbol.ClassSymbol)enclosingElement, sb);
            sb.append('$').append(sym.getSimpleName());
        } else {
            sb.append(sym.getQualifiedName().toString());
        }
    }

    private void addIndirectCompiledTypesToBuildForMapping(Set<Object> drivers) {
        Map typesCompiledByFile = this._tp.getTypesCompiledByFile();
        if (typesCompiledByFile.isEmpty()) {
            return;
        }
        for (Object driver : drivers) {
            Map map = (Map)ReflectUtil.method((Object)driver, (String)"getTypesToFile", (Class[])new Class[0]).invoke(new Object[0]);
            typesCompiledByFile.forEach((file, types) -> {
                Set existingTypes = (Set)map.get(file);
                if (existingTypes != null) {
                    existingTypes.addAll(types);
                } else {
                    map.put(file, types);
                }
            });
            typesCompiledByFile.clear();
        }
    }

    private void verifyExtensionInterfaces(JCTree.JCClassDecl tree) {
        if (!this.hasAnnotation((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations(), Extension.class)) {
            return;
        }
        block0: for (JCTree.JCExpression iface : tree.getImplementsClause()) {
            Symbol.TypeSymbol ifaceSym = iface.type.tsym;
            if (ifaceSym == this._tp.getSymtab().objectType.tsym) continue;
            for (Attribute.Compound anno : ifaceSym.getAnnotationMirrors()) {
                if (!anno.type.toString().equals(Structural.class.getName())) continue;
                continue block0;
            }
            this._tp.report((JCTree)iface, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_ONLY_STRUCTURAL_INTERFACE_ALLOWED_HERE.get(new Object[]{iface.toString()}));
        }
    }

    private boolean shouldProcessForGeneration() {
        return this._bridgeMethod;
    }

    private boolean isBridgeMethod(JCTree.JCMethodDecl tree) {
        long modifiers = tree.getModifiers().flags;
        return (0x80000000L & modifiers) != 0L;
    }

    private Type eraseStructureType(Type type) {
        return (Type)new StructuralTypeEraser(this).visit(type);
    }

    private boolean isReceiver(JCTree tree) {
        Tree parent = this._tp.getParent((Tree)tree);
        if (parent instanceof JCTree.JCFieldAccess) {
            return ((JCTree.JCFieldAccess)parent).getExpression() == tree;
        }
        return false;
    }

    Symbol.ClassSymbol getObjectClass() {
        Symtab symbols = Symtab.instance(this._tp.getContext());
        return (Symbol.ClassSymbol)symbols.objectType.tsym;
    }

    private void eraseGenericStructuralVarargs(JCTree.JCMethodInvocation tree) {
        if (tree.varargsElement instanceof Type.ClassType && TypeUtil.isStructuralInterface(this._tp, tree.varargsElement.tsym)) {
            tree.varargsElement = this._tp.getSymtab().objectType;
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        if (this.isBridgeMethod(tree)) {
            this._bridgeMethod = true;
        }
        try {
            super.visitMethodDef(tree);
        }
        finally {
            this._bridgeMethod = false;
        }
        if (this._tp.isGenerate()) {
            return;
        }
        if (tree.sym.owner.isAnonymous()) {
            JCTree.JCClassDecl anonymousClassDef = (JCTree.JCClassDecl)this._tp.getTreeUtil().getTree(tree.sym.owner);
            this._tp.preserveInnerClassForGenerationPhase(anonymousClassDef);
        }
        this.verifyExtensionMethod(tree);
        this.result = tree;
    }

    private void checkExtensionClassError(JCTree.JCClassDecl typeDecl) {
        JavacPlugin javacPlugin = JavacPlugin.instance();
        if (javacPlugin == null) {
            return;
        }
        if (!this.isExtensionClass(typeDecl)) {
            return;
        }
        String extendedFqn = this.getExtendedClassName();
        if (javacPlugin.getJavaInputFiles().stream().anyMatch(pair -> !(pair.getSecond() instanceof GeneratedJavaStubFileObject) && ((String)pair.getFirst()).equals(extendedFqn))) {
            this._tp.report((JCTree)typeDecl, Diagnostic.Kind.WARNING, ExtIssueMsg.MSG_CANNOT_EXTEND_SOURCE_FILE.get(new Object[]{extendedFqn}));
        }
    }

    private void verifyExtensionMethod(JCTree.JCMethodDecl tree) {
        if (!this.isExtensionClass(this._tp.getParent((Tree)tree))) {
            return;
        }
        String extendedClassName = this.getExtendedClassName();
        if (extendedClassName == null) {
            return;
        }
        boolean thisAnnoFound = false;
        java.util.List parameters = tree.getParameters();
        for (int i = 0; i < ((List)parameters).size(); ++i) {
            JCTree.JCVariableDecl param = (JCTree.JCVariableDecl)((List)parameters).get(i);
            long methodModifiers = tree.getModifiers().flags;
            if (this.hasAnnotation((List<JCTree.JCAnnotation>)param.getModifiers().getAnnotations(), This.class)) {
                Symbol.ClassSymbol extendClassSym;
                thisAnnoFound = true;
                if (i != 0) {
                    this._tp.report((JCTree)param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_THIS_FIRST.get(new Object[0]));
                }
                if (param.type.tsym instanceof Symbol.ClassSymbol && ((Symbol.ClassSymbol)param.type.tsym).className().equals(extendedClassName) || (extendClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), extendedClassName)) == null || TypeUtil.isStructuralInterface(this._tp, extendClassSym) || TypeUtil.isAssignableFromErased(this._tp.getContext(), extendClassSym, param.type.tsym)) continue;
                this._tp.report((JCTree)param, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_EXPECTING_TYPE_FOR_THIS.get(new Object[]{extendedClassName}));
                continue;
            }
            if (i != 0 || !Modifier.isStatic((int)methodModifiers) || !Modifier.isPublic((int)methodModifiers) || !param.type.toString().equals(extendedClassName)) continue;
            this._tp.report((JCTree)param, Diagnostic.Kind.WARNING, ExtIssueMsg.MSG_MAYBE_MISSING_THIS.get(new Object[0]));
        }
        if (thisAnnoFound || this.hasAnnotation((List<JCTree.JCAnnotation>)tree.getModifiers().getAnnotations(), Extension.class)) {
            long methodModifiers = tree.getModifiers().flags;
            if (!Modifier.isStatic((int)methodModifiers)) {
                this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_MUST_BE_STATIC.get(new Object[]{tree.getName()}));
            }
            if (Modifier.isPrivate((int)methodModifiers)) {
                this._tp.report((JCTree)tree, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_MUST_NOT_BE_PRIVATE.get(new Object[]{tree.getName()}));
            }
        }
    }

    private String getExtendedClassName() {
        String extendedClassName = this._tp.getCompilationUnit().getPackageName().toString();
        int iExt = extendedClassName.indexOf("extensions.");
        if (iExt < 0) {
            return null;
        }
        extendedClassName = extendedClassName.substring(iExt + "extensions".length() + 1);
        return extendedClassName;
    }

    private boolean isExtensionClass(Tree parent) {
        if (parent instanceof JCTree.JCClassDecl) {
            return this.hasAnnotation((List<JCTree.JCAnnotation>)((JCTree.JCClassDecl)parent).getModifiers().getAnnotations(), Extension.class);
        }
        return false;
    }

    private JCTree.JCClassDecl getEnclosingClass(Tree tree) {
        if (tree == null) {
            return null;
        }
        if (tree instanceof JCTree.JCClassDecl) {
            return (JCTree.JCClassDecl)tree;
        }
        return this.getEnclosingClass(this._tp.getParent(tree));
    }

    private boolean hasAnnotation(List<JCTree.JCAnnotation> annotations, Class<? extends Annotation> annoClass) {
        for (JCTree.JCAnnotation anno : annotations) {
            if (!anno.getAnnotationType().type.toString().equals(annoClass.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private JCTree replaceStructuralCall(JCTree.JCMethodInvocation theCall) {
        JCTree.JCExpression methodSelect = theCall.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            Symtab symbols = this._tp.getSymtab();
            Names names = Names.instance(this._tp.getContext());
            Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), RuntimeMethods.class.getName());
            Symbol.MethodSymbol makeInterfaceProxyMethod = this.resolveMethod(theCall.pos(), names.fromString("constructProxy"), reflectMethodClassSym.type, List.from(new Type[]{symbols.objectType, symbols.classType}));
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            JCTree.JCExpression thisArg = m.selected;
            ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
            newArgs.add(thisArg);
            JCTree.JCFieldAccess ifaceClassExpr = (JCTree.JCFieldAccess)this.memberAccess(make, javacElems, thisArg.type.tsym.getQualifiedName().toString() + ".class");
            ifaceClassExpr.type = symbols.classType;
            ifaceClassExpr.sym = symbols.classType.tsym;
            this.assignTypes(ifaceClassExpr.selected, thisArg.type.tsym);
            newArgs.add(ifaceClassExpr);
            JCTree.JCMethodInvocation makeProxyCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, RuntimeMethods.class.getName() + ".constructProxy"), List.from(newArgs));
            makeProxyCall.setPos(theCall.pos);
            makeProxyCall.type = thisArg.type;
            JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)makeProxyCall.getMethodSelect();
            newMethodSelect.sym = makeInterfaceProxyMethod;
            newMethodSelect.type = makeInterfaceProxyMethod.type;
            this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
            JCTree.JCTypeCast cast = make.TypeCast(thisArg.type, (JCTree.JCExpression)makeProxyCall);
            cast.type = thisArg.type;
            ((JCTree.JCFieldAccess)theCall.meth).selected = cast;
            return theCall;
        }
        return null;
    }

    private JCTree.JCExpression replaceCastExpression(JCTree.JCExpression expression, Type type) {
        TreeMaker make = this._tp.getTreeMaker();
        Symtab symbols = this._tp.getSymtab();
        Names names = Names.instance(this._tp.getContext());
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), RuntimeMethods.class.getName());
        Symbol.MethodSymbol makeInterfaceProxyMethod = this.resolveMethod(expression.pos(), names.fromString("assignStructuralIdentity"), reflectMethodClassSym.type, List.from(new Type[]{symbols.objectType, symbols.classType}));
        JavacElements javacElems = this._tp.getElementUtil();
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(expression);
        JCTree.JCFieldAccess ifaceClassExpr = (JCTree.JCFieldAccess)this.memberAccess(make, javacElems, type.tsym.getQualifiedName().toString() + ".class");
        ifaceClassExpr.type = symbols.classType;
        ifaceClassExpr.sym = symbols.classType.tsym;
        this.assignTypes(ifaceClassExpr.selected, type.tsym);
        newArgs.add(ifaceClassExpr);
        JCTree.JCMethodInvocation makeProxyCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, RuntimeMethods.class.getName() + ".assignStructuralIdentity"), List.from(newArgs));
        makeProxyCall.type = symbols.objectType;
        makeProxyCall.setPos(expression.pos);
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)makeProxyCall.getMethodSelect();
        newMethodSelect.sym = makeInterfaceProxyMethod;
        newMethodSelect.type = makeInterfaceProxyMethod.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        JCTree.JCTypeCast castCall = make.TypeCast(symbols.objectType, (JCTree.JCExpression)makeProxyCall);
        castCall.type = symbols.objectType;
        return castCall;
    }

    private JCTree replaceExtCall(JCTree.JCMethodInvocation tree, Symbol.MethodSymbol method) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            boolean isStatic = m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            JCTree.JCExpression thisArg = m.selected;
            String extensionFqn = ((Symbol)method.getEnclosingElement()).asType().tsym.toString();
            m.selected = this.memberAccess(make, javacElems, extensionFqn);
            BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
            Symbol.ClassSymbol extensionClassSym = (Symbol.ClassSymbol)ClassSymbols.instance((IModule)this._sp.getModule()).getClassSymbol(javacTask, this._tp, extensionFqn).getFirst();
            this.assignTypes(m.selected, extensionClassSym);
            m.sym = method;
            m.type = method.type;
            if (!isStatic) {
                ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>(tree.args);
                newArgs.add(0, thisArg);
                tree.args = List.from(newArgs);
            }
            return tree;
        }
        if (methodSelect instanceof JCTree.JCIdent) {
            JCTree.JCIdent m = (JCTree.JCIdent)methodSelect;
            boolean isStatic = m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
            TreeMaker make = this._tp.getTreeMaker();
            JavacElements javacElems = this._tp.getElementUtil();
            String extensionFqn = ((Symbol)method.getEnclosingElement()).asType().tsym.toString();
            ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>(tree.args);
            if (!isStatic) {
                JCTree.JCExpression thisArg = make.This(this._tp.getClassDecl((Tree)tree).type);
                newArgs.add(0, thisArg);
            }
            JCTree.JCMethodInvocation extCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, extensionFqn), List.from(newArgs));
            extCall.setPos(tree.pos);
            extCall.type = tree.type;
            JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)extCall.getMethodSelect();
            newMethodSelect.sym = method;
            newMethodSelect.type = method.type;
            this.assignTypes(newMethodSelect.selected, method.owner);
            return extCall;
        }
        return tree;
    }

    private JCTree.JCMethodInvocation replaceWithReflection(JCTree.JCMethodInvocation tree) {
        Type type = tree.getMethodSelect().type;
        if (type instanceof Type.ErrorType) {
            return tree;
        }
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            boolean isStatic = m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
            if (!(m.sym instanceof Symbol.MethodSymbol)) {
                return tree;
            }
            Type returnType = ((Symbol.MethodSymbol)m.sym).getReturnType();
            Symbol.MethodSymbol reflectMethodSym = this.findReflectUtilMethod(tree, returnType, isStatic);
            java.util.List parameters = ((Symbol.MethodSymbol)m.sym).getParameters();
            ArrayList<JCTree.JCExpression> paramTypes = new ArrayList<JCTree.JCExpression>();
            for (Symbol.VarSymbol param : parameters) {
                JCTree.JCExpression classExpr = this.makeClassExpr(tree, param.type);
                paramTypes.add(classExpr);
            }
            Symtab symTab = this._tp.getSymtab();
            JCTree.JCNewArray paramTypesArray = make.NewArray(make.Type(symTab.classType), List.nil(), List.from(paramTypes));
            paramTypesArray.type = new Type.ArrayType(symTab.classType, symTab.arrayClass);
            JCTree.JCNewArray argsArray = make.NewArray(make.Type(symTab.objectType), List.nil(), (List<JCTree.JCExpression>)tree.getArguments());
            argsArray.type = new Type.ArrayType(symTab.objectType, symTab.arrayClass);
            ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
            newArgs.add(isStatic ? this.makeClassExpr(tree, m.selected.type) : m.selected);
            newArgs.add(make.Literal(m.sym.flatName().toString()));
            newArgs.add(paramTypesArray);
            newArgs.add(argsArray);
            Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
            JCTree.JCMethodInvocation reflectCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, ReflectionRuntimeMethods.class.getName() + "." + reflectMethodSym.flatName().toString()), List.from(newArgs));
            reflectCall.setPos(tree.pos);
            reflectCall.type = returnType;
            JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)reflectCall.getMethodSelect();
            newMethodSelect.sym = reflectMethodSym;
            newMethodSelect.type = reflectMethodSym.type;
            this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
            return reflectCall;
        }
        return tree;
    }

    private JCTree replaceWithReflection(JCTree.JCFieldAccess tree) {
        Tree.Kind kind;
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        boolean isStatic = tree.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
        if (tree.sym instanceof Symbol.MethodSymbol) {
            return tree;
        }
        Tree parent = this._tp.getParent((Tree)tree);
        if (parent instanceof JCTree.JCAssign && ((JCTree.JCAssign)parent).lhs == tree || parent instanceof JCTree.JCAssignOp && ((JCTree.JCAssignOp)parent).lhs == tree) {
            return tree;
        }
        if (parent instanceof JCTree.JCUnary && ((JCTree.JCUnary)parent).arg == tree && (kind = parent.getKind()) != Tree.Kind.UNARY_MINUS && kind != Tree.Kind.UNARY_PLUS && kind != Tree.Kind.LOGICAL_COMPLEMENT && kind != Tree.Kind.BITWISE_COMPLEMENT) {
            this._tp.report((JCTree)parent, Diagnostic.Kind.ERROR, ExtIssueMsg.MSG_INCREMENT_OP_NOT_ALLOWED_REFLECTION.get(new Object[0]));
            return tree;
        }
        Type type = tree.sym.type;
        if (type instanceof Type.ErrorType) {
            return tree;
        }
        Symbol.MethodSymbol reflectMethodSym = this.findFieldAccessReflectUtilMethod(tree, type, isStatic, false);
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(isStatic ? this.makeClassExpr(tree, tree.selected.type) : tree.selected);
        newArgs.add(make.Literal(tree.sym.flatName().toString()));
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        JCTree.JCMethodInvocation reflectCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, ReflectionRuntimeMethods.class.getName() + "." + reflectMethodSym.flatName().toString()), List.from(newArgs));
        reflectCall.setPos(tree.pos);
        reflectCall.type = type;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)reflectCall.getMethodSelect();
        newMethodSelect.sym = reflectMethodSym;
        newMethodSelect.type = reflectMethodSym.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        return reflectCall;
    }

    private JCTree replaceWithReflection(JCTree.JCAssign assignTree) {
        JCTree.JCFieldAccess tree = (JCTree.JCFieldAccess)assignTree.lhs;
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        boolean isStatic = tree.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC);
        if (tree.sym instanceof Symbol.MethodSymbol) {
            return assignTree;
        }
        Type type = tree.sym.type;
        Symbol.MethodSymbol reflectMethodSym = this.findFieldAccessReflectUtilMethod(tree, type, isStatic, true);
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(isStatic ? this.makeClassExpr(tree, tree.selected.type) : tree.selected);
        newArgs.add(make.Literal(tree.sym.flatName().toString()));
        newArgs.add(assignTree.rhs);
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        JCTree.JCMethodInvocation reflectCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, ReflectionRuntimeMethods.class.getName() + "." + reflectMethodSym.flatName().toString()), List.from(newArgs));
        reflectCall.setPos(tree.pos);
        reflectCall.type = type;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)reflectCall.getMethodSelect();
        newMethodSelect.sym = reflectMethodSym;
        newMethodSelect.type = reflectMethodSym.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        return reflectCall;
    }

    private JCTree replaceWithReflection(JCTree.JCNewClass tree) {
        if (tree.constructor == null) {
            return tree;
        }
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        Type type = ((JCTree.JCAnnotatedType)tree.clazz).underlyingType.type;
        if (tree.constructor instanceof Symbol.ClassSymbol) {
            return tree;
        }
        java.util.List parameters = ((Symbol.MethodSymbol)tree.constructor).getParameters();
        ArrayList<JCTree.JCExpression> paramTypes = new ArrayList<JCTree.JCExpression>();
        for (Symbol.VarSymbol param : parameters) {
            paramTypes.add(this.makeClassExpr(tree, param.type));
        }
        Symtab symTab = this._tp.getSymtab();
        JCTree.JCNewArray paramTypesArray = make.NewArray(make.Type(symTab.classType), List.nil(), List.from(paramTypes));
        paramTypesArray.type = new Type.ArrayType(symTab.classType, symTab.arrayClass);
        JCTree.JCNewArray argsArray = make.NewArray(make.Type(symTab.objectType), List.nil(), (List<JCTree.JCExpression>)tree.getArguments());
        argsArray.type = new Type.ArrayType(symTab.objectType, symTab.arrayClass);
        ArrayList<JCTree.JCExpression> newArgs = new ArrayList<JCTree.JCExpression>();
        newArgs.add(this.makeClassExpr(tree, type));
        newArgs.add(paramTypesArray);
        newArgs.add(argsArray);
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        Symbol.MethodSymbol reflectMethodSym = this.findReflectUtilConstructor(tree);
        JCTree.JCMethodInvocation reflectCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, ReflectionRuntimeMethods.class.getName() + "." + reflectMethodSym.flatName().toString()), List.from(newArgs));
        reflectCall.setPos(tree.pos);
        reflectCall.type = type;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)reflectCall.getMethodSelect();
        newMethodSelect.sym = reflectMethodSym;
        newMethodSelect.type = reflectMethodSym.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        return reflectCall;
    }

    private JCTree.JCExpression makeClassExpr(JCTree tree, Type type) {
        BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
        Types types = Types.instance(javacTask.getContext());
        type = types.erasure(type);
        JCTree.JCExpression classExpr = type.isPrimitive() || JreUtil.isJava8() && type.tsym.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC) ? this._tp.getTreeMaker().ClassLiteral(type) : this.classForNameCall(type, tree);
        return classExpr;
    }

    private JCTree.JCExpression classForNameCall(Type type, JCTree tree) {
        TreeMaker make = this._tp.getTreeMaker();
        JavacElements javacElems = this._tp.getElementUtil();
        JCTree.JCMethodInvocation typeCall = make.Apply(List.nil(), this.memberAccess(make, javacElems, ReflectUtil.class.getName() + ".type"), List.of(make.Literal(type.tsym.getQualifiedName().toString())));
        typeCall.setPos(-1);
        typeCall.type = this._tp.getSymtab().classType;
        JCTree.JCFieldAccess newMethodSelect = (JCTree.JCFieldAccess)typeCall.getMethodSelect();
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), ReflectUtil.class.getName());
        Symbol.MethodSymbol typeMethodSymbol = this.resolveMethod(tree.pos(), Names.instance(this._tp.getContext()).fromString("type"), reflectMethodClassSym.type, List.of(this._tp.getSymtab().stringType));
        newMethodSelect.sym = typeMethodSymbol;
        newMethodSelect.type = typeMethodSymbol.type;
        this.assignTypes(newMethodSelect.selected, reflectMethodClassSym);
        return typeCall;
    }

    private void assignTypes(JCTree.JCExpression m, Symbol symbol) {
        if (m instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)m;
            fieldAccess.sym = symbol;
            fieldAccess.type = symbol.type;
            this.assignTypes(fieldAccess.selected, symbol.owner);
        } else if (m instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)m;
            ident.sym = symbol;
            ident.type = symbol.type;
        }
    }

    private Symbol.MethodSymbol findExtMethod(JCTree.JCMethodInvocation tree) {
        Symbol sym = null;
        if (tree.meth instanceof JCTree.JCFieldAccess) {
            sym = ((JCTree.JCFieldAccess)tree.meth).sym;
        } else if (tree.meth instanceof JCTree.JCIdent) {
            sym = ((JCTree.JCIdent)tree.meth).sym;
        }
        if (sym == null || !sym.hasAnnotations()) {
            return null;
        }
        for (Attribute.Compound annotation : sym.getAnnotationMirrors()) {
            if (!annotation.type.toString().equals(ExtensionMethod.class.getName())) continue;
            String extensionClass = (String)((Attribute)annotation.values.get((int)0).snd).getValue();
            boolean isStatic = (Boolean)((Attribute)annotation.values.get((int)1).snd).getValue();
            BasicJavacTask javacTask = (BasicJavacTask)this._tp.getJavacTask();
            Pair classSymbol = ClassSymbols.instance((IModule)this._sp.getModule()).getClassSymbol(javacTask, this._tp, extensionClass);
            if (classSymbol == null) continue;
            Symbol.ClassSymbol extClassSym = (Symbol.ClassSymbol)classSymbol.getFirst();
            if (extClassSym == null) {
                return null;
            }
            Types types = Types.instance(javacTask.getContext());
            block1: for (Symbol elem : IDynamicJdk.instance().getMembers(extClassSym)) {
                int thisOffset;
                if (!(elem instanceof Symbol.MethodSymbol) || !elem.flatName().toString().equals(sym.name.toString())) continue;
                Symbol.MethodSymbol extMethodSym = (Symbol.MethodSymbol)elem;
                java.util.List extParams = extMethodSym.getParameters();
                java.util.List calledParams = ((Symbol.MethodSymbol)sym).getParameters();
                int n = thisOffset = isStatic ? 0 : 1;
                if (((List)extParams).size() - thisOffset != ((List)calledParams).size()) continue;
                for (int i = thisOffset; i < ((List)extParams).size(); ++i) {
                    Symbol.VarSymbol extParam = (Symbol.VarSymbol)((List)extParams).get(i);
                    Symbol.VarSymbol calledParam = (Symbol.VarSymbol)((List)calledParams).get(i - thisOffset);
                    if (!types.isSameType(types.erasure(extParam.type), types.erasure(calledParam.type))) continue block1;
                }
                return extMethodSym;
            }
        }
        return null;
    }

    private Symbol.MethodSymbol findReflectUtilMethod(JCTree tree, Type returnType, boolean isStatic) {
        String name = "invoke" + (isStatic ? "Static" : "") + '_' + this.typeForReflect(returnType);
        Symtab symtab = this._tp.getSymtab();
        Type.ArrayType classArrayType = new Type.ArrayType(symtab.classType, symtab.arrayClass);
        Type.ArrayType objectArrayType = new Type.ArrayType(symtab.objectType, symtab.arrayClass);
        List<Type> paramTypes = isStatic ? List.of(symtab.classType, symtab.stringType, classArrayType, new Type[]{objectArrayType}) : List.of(symtab.objectType, symtab.stringType, classArrayType, new Type[]{objectArrayType});
        Names names = Names.instance(this._tp.getContext());
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        return this.resolveMethod(tree.pos(), names.fromString(name), reflectMethodClassSym.type, paramTypes);
    }

    private Symbol.MethodSymbol findFieldAccessReflectUtilMethod(JCTree tree, Type type, boolean isStatic, boolean setter) {
        String name = (setter ? "set" : "get") + "Field" + (isStatic ? "Static" : "") + '_' + this.typeForReflect(type);
        Symtab symtab = this._tp.getSymtab();
        List<Type> paramTypes = setter ? List.of(isStatic ? symtab.classType : symtab.objectType, symtab.stringType, type) : List.of(isStatic ? symtab.classType : symtab.objectType, symtab.stringType);
        Names names = Names.instance(this._tp.getContext());
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        return this.resolveMethod(tree.pos(), names.fromString(name), reflectMethodClassSym.type, paramTypes);
    }

    private Symbol.MethodSymbol findReflectUtilConstructor(JCTree.JCNewClass tree) {
        Symtab symtab = this._tp.getSymtab();
        Type.ArrayType classArrayType = new Type.ArrayType(symtab.classType, symtab.arrayClass);
        Type.ArrayType objectArrayType = new Type.ArrayType(symtab.objectType, symtab.arrayClass);
        List<Type> paramTypes = List.of(symtab.classType, classArrayType, objectArrayType);
        Symbol.ClassSymbol reflectMethodClassSym = IDynamicJdk.instance().getTypeElement(this._tp.getContext(), (Object)this._tp.getCompilationUnit(), ReflectionRuntimeMethods.class.getName());
        Names names = Names.instance(this._tp.getContext());
        return this.resolveMethod(tree.pos(), names.fromString("construct"), reflectMethodClassSym.type, paramTypes);
    }

    private String typeForReflect(Type returnType) {
        if (returnType.isPrimitive()) {
            return ((Name)returnType.tsym.getSimpleName()).toString();
        }
        return "Object";
    }

    private boolean isStructuralMethod(JCTree.JCMethodInvocation tree) {
        JCTree.JCExpression methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess m = (JCTree.JCFieldAccess)methodSelect;
            if (m.sym != null && !m.sym.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC) && !this.isObjectMethod(m.sym)) {
                JCTree.JCExpression thisArg = m.selected;
                return TypeUtil.isStructuralInterface(this._tp, thisArg.type.tsym);
            }
        }
        return false;
    }

    private boolean isObjectMethod(Symbol sym) {
        return sym.owner != null && sym.owner.type == this._tp.getSymtab().objectType;
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements javacElems, String path) {
        return this.memberAccess(make, javacElems, path.split("\\."));
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, JavacElements node, String ... components) {
        JCTree.JCExpression expr = make.Ident(node.getName(components[0]));
        for (int i = 1; i < components.length; ++i) {
            expr = make.Select(expr, node.getName(components[i]));
        }
        return expr;
    }

    private Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return ExtensionTransformer.resolveMethod(pos, this._tp.getContext(), (JCTree.JCCompilationUnit)this._tp.getCompilationUnit(), name, qual, args);
    }

    private static Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Context ctx, JCTree.JCCompilationUnit compUnit, Name name, Type qual, List<Type> args) {
        Resolve rs = Resolve.instance(ctx);
        AttrContext attrContext = new AttrContext();
        AttrContextEnv env = new AttrContextEnv(pos.getTree(), attrContext);
        env.toplevel = compUnit;
        return rs.resolveInternalMethod(pos, env, qual, name, args, null);
    }
}

