/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.type.NoType;
import javax.script.Bindings;
import manifold.api.host.IModule;
import manifold.ext.CoercionProviders;
import manifold.ext.DynamicTypeProxyGenerator;
import manifold.ext.StructuralTypeProxyGenerator;
import manifold.ext.api.IBindingType;
import manifold.ext.api.IBindingsBacked;
import manifold.ext.api.ICallHandler;
import manifold.ext.api.ICoercionProvider;
import manifold.internal.host.RuntimeManifoldHost;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.util.Pair;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.ConcurrentHashSet;
import manifold.util.concurrent.ConcurrentWeakHashMap;

public class RuntimeMethods {
    private static final String STRUCTURAL_PROXY = "_structuralproxy_";
    private static Map<Class, Map<Class, Constructor>> PROXY_CACHE = new ConcurrentHashMap<Class, Map<Class, Constructor>>();
    private static final Map<Object, Set<Class>> ID_MAP = new ConcurrentWeakHashMap();
    private static final Map<Class, Boolean> ICALL_HANDLER_MAP = new ConcurrentWeakHashMap();

    public static Object constructProxy(Object root, Class iface) {
        return RuntimeMethods.createNewProxy(root, iface);
    }

    public static Object assignStructuralIdentity(Object obj, Class iface) {
        if (obj != null) {
            Set ifaces = ID_MAP.computeIfAbsent(obj, k -> new ConcurrentHashSet());
            ifaces.add(iface);
        }
        return obj;
    }

    public static Object invokeUnhandled(Object thiz, Class proxiedIface, String name, Class returnType, Class[] paramTypes, Object[] args) {
        Set<Class> ifaces = ID_MAP.get(thiz);
        if (ifaces != null) {
            for (Class iface : ifaces) {
                Method m;
                if (iface == proxiedIface || (m = RuntimeMethods.findMethod(iface, name, paramTypes)) == null) continue;
                try {
                    Object result = m.invoke(RuntimeMethods.constructProxy(thiz, iface), args);
                    result = RuntimeMethods.coerce(result, returnType);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ICallHandler.UNHANDLED;
    }

    public static Object coerce(Object value, Class<?> type) {
        Class<?> valueClass;
        if (value == null) {
            if (type.isPrimitive()) {
                return RuntimeMethods.defaultPrimitiveValue(type);
            }
            return null;
        }
        if (type.isPrimitive()) {
            type = RuntimeMethods.box(type);
        }
        if ((valueClass = value.getClass()) == type || type.isAssignableFrom(valueClass)) {
            return value;
        }
        Object result = RuntimeMethods.callCoercionProviders(value, type);
        if (result != ICallHandler.UNHANDLED) {
            return result;
        }
        Object boxedValue = RuntimeMethods.coerceBoxed(value, type);
        if (boxedValue != null) {
            return boxedValue;
        }
        if (type == BigInteger.class) {
            if (value instanceof Number) {
                return BigInteger.valueOf(((Number)value).longValue());
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            return new BigInteger(value.toString());
        }
        if (type == BigDecimal.class) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            return new BigDecimal(value.toString());
        }
        if (type == String.class) {
            return String.valueOf(value);
        }
        if (type.isEnum()) {
            String name = String.valueOf(value);
            return Enum.valueOf(type, name);
        }
        if (type.isArray() && valueClass.isArray()) {
            int length = Array.getLength(value);
            Class<?> componentType = type.getComponentType();
            Object array = Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, RuntimeMethods.coerce(Array.get(value, i), componentType));
            }
            return array;
        }
        return value;
    }

    private static Object defaultPrimitiveValue(Class<?> type) {
        if (type == Integer.TYPE || type == Short.TYPE) {
            return 0;
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Void.TYPE) {
            return null;
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + type.getSimpleName());
    }

    private static Object coerceBoxed(Object value, Class<?> type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue() != 0;
            }
            return Boolean.parseBoolean(value.toString());
        }
        if (type == Byte.class || type == Byte.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).byteValue() != 0;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? (byte)1 : 0;
            }
            return Byte.parseByte(value.toString());
        }
        if (type == Character.class || type == Character.TYPE) {
            if (value instanceof Number) {
                return Character.valueOf((char)((Number)value).intValue());
            }
            String s = value.toString();
            return Character.valueOf(s.isEmpty() ? (char)'\u0000' : s.charAt(0));
        }
        if (type == Short.class || type == Short.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? (short)1 : 0;
            }
            return Short.parseShort(value.toString());
        }
        if (type == Integer.class || type == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1 : 0;
            }
            return Integer.parseInt(value.toString());
        }
        if (type == Long.class || type == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1L : 0L;
            }
            return Long.parseLong(value.toString());
        }
        if (type == Float.class || type == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (value instanceof Boolean) {
                return Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        if (type == Double.class || type == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? 1.0 : 0.0;
            }
            return Double.parseDouble(value.toString());
        }
        return null;
    }

    private static Object callCoercionProviders(Object value, Class<?> type) {
        for (ICoercionProvider coercer : CoercionProviders.get()) {
            Object coercedValue = coercer.coerce(value, type);
            if (coercedValue == ICallHandler.UNHANDLED) continue;
            return coercedValue;
        }
        return ICallHandler.UNHANDLED;
    }

    private static Class<?> box(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalStateException();
    }

    private static Method findMethod(Class<?> iface, String name, Class[] paramTypes) {
        try {
            Method m = iface.getDeclaredMethod(name, paramTypes);
            if (m == null) {
                Class<?> superIface;
                Class<?>[] classArray = iface.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (m = RuntimeMethods.findMethod(superIface = classArray[i], name, paramTypes)) == null; ++i) {
                }
            }
            if (m != null) {
                return m;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static Object createNewProxy(Object root, Class<?> iface) {
        Constructor<?> proxyClassCtor;
        if (root == null) {
            return null;
        }
        Class<?> rootClass = root.getClass();
        if (iface.isAssignableFrom(rootClass)) {
            return root;
        }
        if (root instanceof Bindings && IBindingsBacked.class.isAssignableFrom(iface)) {
            return ReflectUtil.method(iface, (String)"proxy", (Class[])new Class[]{Bindings.class}).invokeStatic(new Object[]{root});
        }
        Map<Class, Constructor> proxyByClass = PROXY_CACHE.get(iface);
        if (proxyByClass == null) {
            proxyByClass = new ConcurrentHashMap<Class, Constructor>();
            PROXY_CACHE.put(iface, proxyByClass);
        }
        if ((proxyClassCtor = proxyByClass.get(rootClass)) == null) {
            Class proxyClass = RuntimeMethods.createProxy(iface, rootClass);
            proxyClassCtor = proxyClass.getConstructors()[0];
            proxyByClass.put(rootClass, proxyClassCtor);
        }
        try {
            ReflectUtil.setAccessible((Constructor)proxyClassCtor);
            return proxyClassCtor.newInstance(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class createProxy(Class iface, Class rootClass) {
        String relativeProxyName = rootClass.getCanonicalName().replace('.', '_') + STRUCTURAL_PROXY + iface.getCanonicalName().replace('.', '_');
        if (RuntimeMethods.hasCallHandlerMethod(rootClass)) {
            return DynamicTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
        }
        return StructuralTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
    }

    private static boolean hasCallHandlerMethod(Class rootClass) {
        if (ICallHandler.class.isAssignableFrom(rootClass)) {
            return true;
        }
        if (ReflectUtil.method((Class)rootClass, (String)"call", (Class[])new Class[]{Class.class, String.class, String.class, Class.class, Class[].class, Object[].class}) != null) {
            return true;
        }
        return RuntimeMethods.hasCallHandlerFromExtension(rootClass);
    }

    private static boolean hasCallHandlerFromExtension(Class rootClass) {
        Boolean isCallHandler = ICALL_HANDLER_MAP.get(rootClass);
        if (isCallHandler != null) {
            return isCallHandler;
        }
        String fqn = rootClass.getCanonicalName();
        BasicJavacTask javacTask = RuntimeManifoldHost.get().getJavaParser().getJavacTask();
        Pair classSymbol = ClassSymbols.instance((IModule)RuntimeManifoldHost.get().getSingleModule()).getClassSymbol(javacTask, fqn);
        Pair callHandlerSymbol = ClassSymbols.instance((IModule)RuntimeManifoldHost.get().getSingleModule()).getClassSymbol(javacTask, ICallHandler.class.getCanonicalName());
        isCallHandler = Types.instance(javacTask.getContext()).isAssignable((Type)((Symbol.ClassSymbol)classSymbol.getFirst()).asType(), (Type)((Symbol.ClassSymbol)callHandlerSymbol.getFirst()).asType()) ? Boolean.valueOf(true) : Boolean.valueOf(RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)classSymbol.getFirst()));
        ICALL_HANDLER_MAP.put(rootClass, isCallHandler);
        return isCallHandler;
    }

    private static boolean hasCallMethod(BasicJavacTask javacTask, Symbol.ClassSymbol classSymbol) {
        Name call = Names.instance(javacTask.getContext()).fromString("call");
        Iterable elems = IDynamicJdk.instance().getMembersByName(classSymbol, call);
        for (Symbol s : elems) {
            if (!(s instanceof Symbol.MethodSymbol)) continue;
            java.util.List parameters = ((Symbol.MethodSymbol)s).getParameters();
            if (((List)parameters).size() != 6) {
                return false;
            }
            Symtab symbols = Symtab.instance(javacTask.getContext());
            Types types = Types.instance(javacTask.getContext());
            return types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(0)).asType()).equals(types.erasure(symbols.classType)) && ((Type)((Symbol.VarSymbol)((List)parameters).get(1)).asType()).equals(symbols.stringType) && ((Type)((Symbol.VarSymbol)((List)parameters).get(2)).asType()).equals(symbols.stringType) && types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(3)).asType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(4)).asType() instanceof Type.ArrayType && types.erasure(((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(4)).asType()).getComponentType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(5)).asType() instanceof Type.ArrayType && ((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(5)).asType()).getComponentType().equals(symbols.objectType);
        }
        Type superclass = classSymbol.getSuperclass();
        if (!(superclass instanceof NoType) && RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)superclass.tsym)) {
            return true;
        }
        for (Type iface : classSymbol.getInterfaces()) {
            if (!RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)iface.tsym)) continue;
            return true;
        }
        return false;
    }

    public static Object coerceToBindingValue(Map thiz, Object arg) {
        if (arg instanceof IBindingType) {
            arg = ((IBindingType)arg).toBindingValue();
        } else if (RuntimeMethods.needsCoercion(arg, thiz)) {
            for (ICoercionProvider coercer : CoercionProviders.get()) {
                Object coercedValue = coercer.toBindingValue(arg);
                if (coercedValue == ICallHandler.UNHANDLED) continue;
                arg = coercedValue;
            }
        }
        return arg;
    }

    private static boolean needsCoercion(Object arg, Map thiz) {
        return thiz instanceof Bindings && !(arg instanceof Bindings) && !RuntimeMethods.isPrimitiveType(arg.getClass());
    }

    private static boolean isPrimitiveType(Class<?> type) {
        return type == String.class || type == Boolean.class || type == Character.class || type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class;
    }
}

