/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import javax.lang.model.type.NoType;
import manifold.api.host.IModule;
import manifold.ext.ExtensionMethod;
import manifold.ext.RuntimeMethods;
import manifold.internal.host.RuntimeManifoldHost;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.runtime.protocols.ManClassesUrlConnection;

public class StructuralTypeProxyGenerator {
    private final Class<?> _iface;
    private Class<?> _rootClass;
    private final String _name;
    private Symbol.ClassSymbol _rootClassSymbol;

    private StructuralTypeProxyGenerator(Class<?> iface, Class<?> rootClass, String name) {
        this._iface = iface;
        this._rootClass = rootClass;
        this._name = name;
    }

    public static Class makeProxy(Class<?> iface, Class<?> rootClass, String name) {
        StructuralTypeProxyGenerator gen = new StructuralTypeProxyGenerator(iface, rootClass, name);
        String fqnProxy = StructuralTypeProxyGenerator.getNamespace(iface) + '.' + name;
        ManClassesUrlConnection.putProxySupplier((String)fqnProxy, () -> gen.generateProxy().toString());
        try {
            return Class.forName(fqnProxy, false, iface.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(fqnProxy, false, StructuralTypeProxyGenerator.class.getClassLoader());
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    private StringBuilder generateProxy() {
        return new StringBuilder().append("package ").append(StructuralTypeProxyGenerator.getNamespace(this._iface)).append(";\n").append("\n").append("public class ").append(this._name).append(" implements ").append(this._iface.getCanonicalName()).append(" {\n").append("  private final ").append(this._rootClass.getCanonicalName()).append(" _root;\n").append("  \n").append("  public ").append(this._name).append("(").append(this._rootClass.getCanonicalName()).append(" root) {\n").append("    _root = root;\n").append("  }\n").append("  \n").append(this.implementIface()).append("}");
    }

    private static String getNamespace(Class ifaceType) {
        String nspace = ifaceType.getPackage().getName();
        if (nspace.startsWith("java.") || nspace.startsWith("javax.")) {
            nspace = "not" + nspace;
        }
        return nspace;
    }

    private String implementIface() {
        StringBuilder sb = new StringBuilder();
        for (Method mi : this._iface.getMethods()) {
            this.genInterfaceMethodDecl(sb, mi, this._rootClass);
        }
        return sb.toString();
    }

    private void genInterfaceMethodDecl(StringBuilder sb, Method mi, Class rootType) {
        if (mi.isDefault() && !this.implementsMethod(rootType, mi) || Modifier.isStatic(mi.getModifiers())) {
            return;
        }
        if (mi.getAnnotation(ExtensionMethod.class) != null) {
            return;
        }
        if (StructuralTypeProxyGenerator.isObjectMethod(mi)) {
            return;
        }
        Class<?> returnType = mi.getReturnType();
        sb.append("  public ").append(returnType.getCanonicalName()).append(' ').append(mi.getName()).append("(");
        Class[] params = mi.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> pi = params[i];
            sb.append(' ').append(pi.getCanonicalName()).append(" p").append(i);
            sb.append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append(") {\n").append(returnType == Void.TYPE ? "    " : "    return ").append(this.maybeCastReturnType(mi, returnType, rootType));
        if (!returnType.isPrimitive()) {
            sb.append(RuntimeMethods.class.getTypeName()).append(".coerce(");
        }
        if (!this.handleField(sb, mi)) {
            this.handleMethod(sb, mi, params);
        }
        if (!returnType.isPrimitive()) {
            sb.append(", ").append(mi.getReturnType().getCanonicalName()).append(".class);\n");
        } else {
            sb.append(";\n");
        }
        sb.append("  }\n");
    }

    private void handleMethod(StringBuilder sb, Method mi, Class[] params) {
        sb.append("_root").append('.').append(mi.getName()).append("(");
        for (int i = 0; i < params.length; ++i) {
            sb.append(' ').append("p").append(i).append(i < params.length - 1 ? (char)',' : ' ');
        }
        sb.append(")");
    }

    private boolean handleField(StringBuilder sb, Method method) {
        String propertyName = this.getPropertyNameFromGetter(method);
        if (propertyName != null) {
            Field field = this.findField(propertyName, this._rootClass, method.getReturnType(), Variance.Covariant);
            if (field != null) {
                sb.append("_root").append('.').append(field.getName());
                return true;
            }
        } else {
            Field field;
            propertyName = this.getPropertyNameFromSetter(method);
            if (propertyName != null && (field = this.findField(propertyName, this._rootClass, method.getParameterTypes()[0], Variance.Contravariant)) != null) {
                sb.append("_root").append('.').append(field.getName()).append(" = p0;\n");
                return true;
            }
        }
        return false;
    }

    private Field findField(String name, Class rootType, Class<?> returnType, Variance variance) {
        String nameUpper = Character.toUpperCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        String nameLower = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        String nameUnder = '_' + nameLower;
        for (Field field : rootType.getFields()) {
            Class<?> fromType;
            String fieldName = field.getName();
            Class<?> toType = variance == Variance.Covariant ? returnType : field.getType();
            Class<?> clazz = fromType = variance == Variance.Covariant ? field.getType() : returnType;
            if (!toType.isAssignableFrom(fromType) && !StructuralTypeProxyGenerator.arePrimitiveTypesAssignable(toType, fromType) || !fieldName.equals(nameUpper) && !fieldName.equals(nameLower) && !fieldName.equals(nameUnder)) continue;
            return field;
        }
        return null;
    }

    public static boolean arePrimitiveTypesAssignable(Class toType, Class fromType) {
        if (toType == null || fromType == null || !toType.isPrimitive() || !fromType.isPrimitive()) {
            return false;
        }
        if (toType == fromType) {
            return true;
        }
        if (toType == Double.TYPE) {
            return fromType == Float.TYPE || fromType == Integer.TYPE || fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Float.TYPE) {
            return fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Long.TYPE) {
            return fromType == Integer.TYPE || fromType == Character.TYPE || fromType == Short.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Integer.TYPE) {
            return fromType == Short.TYPE || fromType == Character.TYPE || fromType == Byte.TYPE;
        }
        if (toType == Short.TYPE) {
            return fromType == Byte.TYPE;
        }
        return false;
    }

    private String getPropertyNameFromGetter(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 0) {
            return null;
        }
        String name = method.getName();
        String propertyName = null;
        for (String prefix : Arrays.asList("get", "is")) {
            if (name.length() <= prefix.length() || !name.startsWith(prefix)) continue;
            if (prefix.equals("is") && !method.getReturnType().equals(Boolean.TYPE) && !method.getReturnType().equals(Boolean.class) || this.hasPotentialMethod(this.getRootClassSymbol(), name, method.getParameterCount())) break;
            propertyName = name.substring(prefix.length());
            char firstChar = propertyName.charAt(0);
            if (firstChar == '_' && propertyName.length() > 1) {
                propertyName = propertyName.substring(1);
                continue;
            }
            if (!Character.isAlphabetic(firstChar) || Character.isUpperCase(firstChar)) continue;
            propertyName = null;
            break;
        }
        return propertyName;
    }

    private String getPropertyNameFromSetter(Method method) {
        if (method.getReturnType() != Void.TYPE) {
            return null;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != 1) {
            return null;
        }
        String name = method.getName();
        String propertyName = null;
        if (name.length() > "set".length() && name.startsWith("set")) {
            if (this.hasPotentialMethod(this.getRootClassSymbol(), name, method.getParameterCount())) {
                return null;
            }
            propertyName = name.substring("set".length());
            char firstChar = propertyName.charAt(0);
            if (firstChar == '_' && propertyName.length() > 1) {
                propertyName = propertyName.substring(1);
            } else if (Character.isAlphabetic(firstChar) && !Character.isUpperCase(firstChar)) {
                propertyName = null;
            }
        }
        return propertyName;
    }

    private boolean hasPotentialMethod(Symbol.ClassSymbol rootClassSymbol, String name, int paramCount) {
        if (rootClassSymbol == null || rootClassSymbol instanceof NoType) {
            return false;
        }
        for (Symbol member : IDynamicJdk.instance().getMembers(rootClassSymbol, e -> e.flatName().toString().equals(name))) {
            Symbol.MethodSymbol methodSym = (Symbol.MethodSymbol)member;
            if (((List)methodSym.getParameters()).size() != paramCount) continue;
            return true;
        }
        if (this.hasPotentialMethod((Symbol.ClassSymbol)rootClassSymbol.getSuperclass().tsym, name, paramCount)) {
            return true;
        }
        for (Type iface : rootClassSymbol.getInterfaces()) {
            if (!this.hasPotentialMethod((Symbol.ClassSymbol)iface.tsym, name, paramCount)) continue;
            return true;
        }
        return false;
    }

    private Symbol.ClassSymbol getRootClassSymbol() {
        if (this._rootClassSymbol == null) {
            ClassSymbols classSymbols = ClassSymbols.instance((IModule)RuntimeManifoldHost.get().getSingleModule());
            BasicJavacTask javacTask = classSymbols.getJavacTask_PlainFileMgr();
            this._rootClassSymbol = (Symbol.ClassSymbol)classSymbols.getClassSymbol(javacTask, this._rootClass.getCanonicalName()).getFirst();
        }
        return this._rootClassSymbol;
    }

    public static boolean isObjectMethod(Method mi) {
        Class[] paramTypes = null;
        block0: for (Method objMi : Object.class.getMethods()) {
            Parameter[] objParams;
            if (!objMi.getName().equals(mi.getName())) continue;
            if (paramTypes == null) {
                paramTypes = StructuralTypeProxyGenerator.getParamTypes(mi);
            }
            if ((objParams = objMi.getParameters()).length == paramTypes.length) {
                for (int i = 0; i < objParams.length; ++i) {
                    if (!paramTypes[i].equals(objParams[i].getType())) continue block0;
                }
            }
            return true;
        }
        return false;
    }

    private static Class[] getParamTypes(Method mi) {
        Parameter[] params = mi.getParameters();
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getType();
        }
        return paramTypes;
    }

    private boolean implementsMethod(Class type, Method mi) {
        return true;
    }

    private String maybeCastReturnType(Method mi, Class returnType, Class rootType) {
        return returnType != Void.TYPE ? "(" + returnType.getCanonicalName() + ")" : "";
    }

    static enum Variance {
        Covariant,
        Contravariant;

    }
}

