/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.lang.model.type.NoType;
import manifold.api.host.IModule;
import manifold.ext.DynamicTypeProxyGenerator;
import manifold.ext.StructuralTypeProxyGenerator;
import manifold.ext.api.ICallHandler;
import manifold.internal.host.ManifoldHost;
import manifold.internal.javac.ClassSymbols;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavaParser;
import manifold.internal.runtime.Bootstrap;
import manifold.util.Pair;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.ConcurrentHashSet;
import manifold.util.concurrent.ConcurrentWeakHashMap;

public class RuntimeMethods {
    private static final String STRUCTURAL_PROXY = "_structuralproxy_";
    private static Map<Class, Map<Class, Constructor>> PROXY_CACHE;
    private static final Map<Object, Set<Class>> ID_MAP;

    public static Object constructProxy(Object root, Class iface) {
        return RuntimeMethods.createNewProxy(root, iface);
    }

    public static Object assignStructuralIdentity(Object obj, Class iface) {
        if (obj != null) {
            Set ifaces = ID_MAP.computeIfAbsent(obj, k -> new ConcurrentHashSet());
            ifaces.add(iface);
        }
        return obj;
    }

    public static Object invokeUnhandled(Object thiz, Class proxiedIface, String name, Class returnType, Class[] paramTypes, Object[] args) {
        Set<Class> ifaces = ID_MAP.get(thiz);
        if (ifaces != null) {
            for (Class iface : ifaces) {
                Method m;
                if (iface == proxiedIface || (m = RuntimeMethods.findMethod(iface, name, paramTypes)) == null) continue;
                try {
                    Object result = m.invoke(RuntimeMethods.constructProxy(thiz, iface), args);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return ICallHandler.UNHANDLED;
    }

    private static Method findMethod(Class<?> iface, String name, Class[] paramTypes) {
        try {
            Method m = iface.getDeclaredMethod(name, paramTypes);
            if (m == null) {
                Class<?> superIface;
                Class<?>[] classArray = iface.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (m = RuntimeMethods.findMethod(superIface = classArray[i], name, paramTypes)) == null; ++i) {
                }
            }
            if (m != null) {
                return m;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static Object createNewProxy(Object root, Class<?> iface) {
        Constructor<?> proxyClassCtor;
        if (root == null) {
            return null;
        }
        Class<?> rootClass = root.getClass();
        if (iface.isAssignableFrom(rootClass)) {
            return root;
        }
        Map<Class, Constructor> proxyByClass = PROXY_CACHE.get(iface);
        if (proxyByClass == null) {
            proxyByClass = new ConcurrentHashMap<Class, Constructor>();
            PROXY_CACHE.put(iface, proxyByClass);
        }
        if ((proxyClassCtor = proxyByClass.get(rootClass)) == null) {
            Class proxyClass = RuntimeMethods.createProxy(iface, rootClass);
            proxyClassCtor = proxyClass.getConstructors()[0];
            proxyByClass.put(rootClass, proxyClassCtor);
        }
        try {
            ReflectUtil.setAccessible((Constructor)proxyClassCtor);
            return proxyClassCtor.newInstance(root);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class createProxy(Class iface, Class rootClass) {
        String relativeProxyName = rootClass.getCanonicalName().replace('.', '_') + STRUCTURAL_PROXY + iface.getCanonicalName().replace('.', '_');
        if (RuntimeMethods.hasCallHandlerMethod(rootClass)) {
            return DynamicTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
        }
        return StructuralTypeProxyGenerator.makeProxy(iface, rootClass, relativeProxyName);
    }

    private static boolean hasCallHandlerMethod(Class rootClass) {
        String fqn = rootClass.getCanonicalName();
        BasicJavacTask javacTask = JavaParser.instance().getJavacTask();
        Pair classSymbol = ClassSymbols.instance((IModule)ManifoldHost.getGlobalModule()).getClassSymbol(javacTask, fqn);
        Pair callHandlerSymbol = ClassSymbols.instance((IModule)ManifoldHost.getGlobalModule()).getClassSymbol(javacTask, ICallHandler.class.getCanonicalName());
        if (Types.instance(javacTask.getContext()).isAssignable((Type)((Symbol.ClassSymbol)classSymbol.getFirst()).asType(), (Type)((Symbol.ClassSymbol)callHandlerSymbol.getFirst()).asType())) {
            return true;
        }
        return RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)classSymbol.getFirst());
    }

    private static boolean hasCallMethod(BasicJavacTask javacTask, Symbol.ClassSymbol classSymbol) {
        Name call = Names.instance(javacTask.getContext()).fromString("call");
        Iterable elems = IDynamicJdk.instance().getMembersByName(classSymbol, call);
        for (Symbol s : elems) {
            if (!(s instanceof Symbol.MethodSymbol)) continue;
            java.util.List parameters = ((Symbol.MethodSymbol)s).getParameters();
            if (((List)parameters).size() != 6) {
                return false;
            }
            Symtab symbols = Symtab.instance(javacTask.getContext());
            Types types = Types.instance(javacTask.getContext());
            return types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(0)).asType()).equals(types.erasure(symbols.classType)) && ((Type)((Symbol.VarSymbol)((List)parameters).get(1)).asType()).equals(symbols.stringType) && ((Type)((Symbol.VarSymbol)((List)parameters).get(2)).asType()).equals(symbols.stringType) && types.erasure((Type)((Symbol.VarSymbol)((List)parameters).get(3)).asType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(4)).asType() instanceof Type.ArrayType && types.erasure(((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(4)).asType()).getComponentType()).equals(types.erasure(symbols.classType)) && ((Symbol.VarSymbol)((List)parameters).get(5)).asType() instanceof Type.ArrayType && ((Type.ArrayType)((Symbol.VarSymbol)((List)parameters).get(5)).asType()).getComponentType().equals(symbols.objectType);
        }
        Type superclass = classSymbol.getSuperclass();
        if (!(superclass instanceof NoType) && RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)superclass.tsym)) {
            return true;
        }
        for (Type iface : classSymbol.getInterfaces()) {
            if (!RuntimeMethods.hasCallMethod(javacTask, (Symbol.ClassSymbol)iface.tsym)) continue;
            return true;
        }
        return false;
    }

    static {
        Bootstrap.init();
        PROXY_CACHE = new ConcurrentHashMap<Class, Map<Class, Constructor>>();
        ID_MAP = new ConcurrentWeakHashMap();
    }
}

