/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import manifold.api.fs.IFile;
import manifold.api.fs.cache.ModulePathCache;
import manifold.api.host.ITypeLoader;
import manifold.api.type.ClassType;
import manifold.api.type.ITypeManifold;
import manifold.api.type.ITypeProcessor;
import manifold.api.type.JavaTypeManifold;
import manifold.ext.ExtCodeGen;
import manifold.ext.ExtensionTransformer;
import manifold.ext.Model;
import manifold.ext.api.Extension;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.TypeProcessor;
import manifold.internal.runtime.Bootstrap;
import manifold.util.StreamUtil;

public class ExtensionManifold
extends JavaTypeManifold<Model>
implements ITypeProcessor {
    public static final String EXTENSIONS_PACKAGE = "extensions";
    private static final Set<String> FILE_EXTENSIONS;

    public void init(ITypeLoader typeLoader) {
        this.init(typeLoader, (fqn, files) -> new Model((String)fqn, (Set<IFile>)files, this));
    }

    public boolean handlesFileExtension(String fileExtension) {
        return FILE_EXTENSIONS.contains(fileExtension.toLowerCase());
    }

    public ITypeManifold.ProducerKind getProducerKind() {
        return ITypeManifold.ProducerKind.Supplemental;
    }

    protected String aliasFqn(String fqn, IFile file) {
        String extendedType;
        int iDot;
        if (fqn.length() > EXTENSIONS_PACKAGE.length() + 2 && fqn.startsWith("extensions.") && (iDot = (extendedType = fqn.substring(EXTENSIONS_PACKAGE.length() + 1)).lastIndexOf(46)) > 0) {
            return extendedType.substring(0, iDot);
        }
        return null;
    }

    public boolean handlesFile(IFile file) {
        Set fqns = ModulePathCache.instance().get(this.getModule()).getFqnForFile(file);
        if (fqns == null) {
            return false;
        }
        for (String fqn : fqns) {
            String extendedType;
            int iDot;
            if (fqn.length() <= EXTENSIONS_PACKAGE.length() + 2 || !fqn.startsWith("extensions.") || (iDot = (extendedType = fqn.substring(EXTENSIONS_PACKAGE.length() + 1)).lastIndexOf(46)) <= 0) continue;
            try {
                if (file.getExtension().equalsIgnoreCase("java")) {
                    String content = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream()));
                    return content.contains("@Extension") && content.contains(Extension.class.getPackage().getName());
                }
                String content = StreamUtil.getContent((Reader)new InputStreamReader(file.openInputStream()));
                return content.contains(Extension.class.getName().replace('.', '/'));
            }
            catch (IOException iOException) {
            }
        }
        return false;
    }

    public String[] getTypesForFile(IFile file) {
        String fqn;
        String[] typesForFile = super.getTypesForFile(file);
        if (typesForFile != null && typesForFile.length > 0 && (fqn = typesForFile[0]).startsWith(EXTENSIONS_PACKAGE)) {
            int iDot = (fqn = fqn.substring(EXTENSIONS_PACKAGE.length() + 1)).lastIndexOf(46);
            fqn = iDot == -1 ? fqn : fqn.substring(0, iDot);
            return new String[]{fqn};
        }
        return typesForFile;
    }

    protected boolean isInnerType(String topLevel, String relativeInner) {
        return false;
    }

    public ClassType getClassType(String fqn) {
        return ClassType.Class;
    }

    public void clear() {
        super.clear();
    }

    protected String produce(String topLevelFqn, String existing, Model model, DiagnosticListener<JavaFileObject> errorHandler) {
        return new ExtCodeGen(model, topLevelFqn, existing).make(errorHandler);
    }

    public void process(TypeElement typeElement, TypeProcessor typeProcessor, IssueReporter<JavaFileObject> issueReporter) {
        if (typeElement.getKind() == ElementKind.CLASS || typeElement.getKind() == ElementKind.INTERFACE) {
            ExtensionTransformer visitor = new ExtensionTransformer(this, typeProcessor);
            typeProcessor.getTree().accept(visitor);
        }
    }

    static {
        Bootstrap.init();
        FILE_EXTENSIONS = new HashSet<String>(Arrays.asList("java", "class"));
    }
}

