/*
 * Decompiled with CFR 0.152.
 */
package com.furdei.furdroid.security.encryption;

import android.content.ContentValues;
import android.util.Base64;
import com.furdei.furdroid.security.encryption.EncryptedTableSettings;
import com.furdei.furdroid.security.encryption.EncryptionSettings;
import com.furdei.furdroid.security.encryption.EncryptionSettingsProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtils {
    private static final String KEY_ALGORITHM = "AES";
    private static final String ENC_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String DER_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int KEY_LENGTH = 128;
    private static final int ITERATION_COUNT = 1000;
    private static final String ENCODING = "UTF-8";
    private static volatile SecretKey secretKey = null;
    private static volatile EncryptionSettings encSettings;
    private static volatile EncryptionSettingsProvider encryptionSettingsProvider;

    public static void setPassword(String password) throws InvalidKeySpecException, NoSuchAlgorithmException {
        secretKey = EncryptionUtils.deriveKeyFromPassword(password);
    }

    public static EncryptionSettingsProvider getEncryptionSettingsProvider() {
        return encryptionSettingsProvider;
    }

    public static synchronized void setEncryptionSettingsProvider(EncryptionSettingsProvider encryptionSettingsProvider) {
        EncryptionUtils.encryptionSettingsProvider = encryptionSettingsProvider;
        encSettings = null;
    }

    public static Cipher initForEncrypt(SecretKey aesKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher encryptCipher = Cipher.getInstance(ENC_ALGORITHM);
        encryptCipher.init(1, aesKey);
        return encryptCipher;
    }

    public static Cipher initForEncrypt() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return EncryptionUtils.initForEncrypt(secretKey);
    }

    public static byte[] encrypt(Cipher encryptCipher, byte[] rawBytes) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, encryptCipher);
        cipherOutputStream.write(rawBytes);
        cipherOutputStream.flush();
        cipherOutputStream.close();
        return outputStream.toByteArray();
    }

    public static Cipher initForDecrypt(SecretKey aesKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        Cipher decryptCipher = Cipher.getInstance(ENC_ALGORITHM);
        decryptCipher.init(2, (Key)aesKey, new SecureRandom());
        return decryptCipher;
    }

    public static Cipher initForDecrypt() throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException {
        return EncryptionUtils.initForDecrypt(secretKey);
    }

    public static byte[] decrypt(Cipher decryptCipher, byte[] encryptedBytes) throws IOException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inStream = new ByteArrayInputStream(encryptedBytes);
        CipherInputStream cipherInputStream = new CipherInputStream(inStream, decryptCipher);
        byte[] buf = new byte[1024];
        while ((bytesRead = cipherInputStream.read(buf)) >= 0) {
            outputStream.write(buf, 0, bytesRead);
        }
        return outputStream.toByteArray();
    }

    public static void encryptContentValues(Cipher encryptCipher, ContentValues contentValues, String tableName) throws IOException {
        String[] columnsToEncrypt = null;
        EncryptedTableSettings table = EncryptionUtils.getEncSettings().getEncryptedTables().get(tableName);
        if (table != null) {
            columnsToEncrypt = table.getEncColumns().toArray(new String[table.getEncColumns().size()]);
        }
        EncryptionUtils.encryptContentValues(encryptCipher, contentValues, columnsToEncrypt);
    }

    public static void encryptContentValues(Cipher encryptCipher, ContentValues contentValues, String[] columnsToEncrypt) throws IOException {
        if (encryptCipher == null || contentValues == null || columnsToEncrypt == null || columnsToEncrypt.length == 0 || contentValues.size() == 0) {
            return;
        }
        for (String column : columnsToEncrypt) {
            String value;
            if (!contentValues.containsKey(column) || (value = contentValues.getAsString(column)) == null || value.length() <= 0) continue;
            byte[] dataToEncrypt = value.getBytes(ENCODING);
            byte[] encryptedData = EncryptionUtils.encrypt(encryptCipher, dataToEncrypt);
            contentValues.put(column, Base64.encodeToString((byte[])encryptedData, (int)0));
        }
    }

    public static String decrypt(Cipher decryptCipher, String encryptedStringBase64) throws IOException {
        if (encryptedStringBase64 == null || encryptedStringBase64.length() == 0) {
            return null;
        }
        byte[] encryptedData = Base64.decode((String)encryptedStringBase64, (int)0);
        return new String(EncryptionUtils.decrypt(decryptCipher, encryptedData), ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EncryptionSettings getEncSettings() {
        if (encSettings != null) return encSettings;
        Class<EncryptionUtils> clazz = EncryptionUtils.class;
        synchronized (EncryptionUtils.class) {
            if (encSettings != null) return encSettings;
            if (encryptionSettingsProvider == null) {
                throw new IllegalStateException("Encryption settings provider has not been specified. Call EncryptionUtils.setEncryptionSettingsProvider(EncryptionSettingsProvider) to specify encryption settings.");
            }
            encSettings = encryptionSettingsProvider.getEncryptionSettings();
            // ** MonitorExit[var0] (shouldn't be in output)
            return encSettings;
        }
    }

    private static SecretKey deriveKeyFromPassword(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory f = SecretKeyFactory.getInstance(DER_ALGORITHM);
        PBEKeySpec ks = new PBEKeySpec(password.toCharArray(), "salt0123456789yo".getBytes(), 1000, 128);
        byte[] keyBytes = f.generateSecret(ks).getEncoded();
        return new SecretKeySpec(keyBytes, KEY_ALGORITHM);
    }
}

