/*
 * Decompiled with CFR 0.152.
 */
package com.furdei.furdroid.security.database;

import android.database.CharArrayBuffer;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;
import android.os.Bundle;
import com.furdei.furdroid.security.encryption.EncryptedTableSettings;
import com.furdei.furdroid.security.encryption.EncryptionUtils;
import java.io.IOException;
import javax.crypto.Cipher;

public class DecryptingSQLiteCursor
extends SQLiteCursor {
    private Bundle extras;
    private String editTable;
    private boolean[] encryptedColumns = null;
    private Cipher decryptingCipher = null;

    public DecryptingSQLiteCursor(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        super(db, driver, editTable, query);
        this.editTable = editTable;
    }

    public Bundle getExtras() {
        if (this.extras == null) {
            this.extras = new Bundle();
        }
        return this.extras;
    }

    private boolean isColumnEncrypted(int columnIndex) {
        if (this.encryptedColumns == null) {
            this.encryptedColumns = new boolean[this.getColumnCount()];
            EncryptedTableSettings encTable = EncryptionUtils.getEncSettings().getEncryptedTables().get(this.editTable);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.encryptedColumns[i] = encTable != null && encTable.getEncColumns().contains(this.getColumnName(i));
            }
        }
        return this.encryptedColumns[columnIndex];
    }

    private Cipher getDecryptingCipher() {
        if (this.decryptingCipher == null) {
            try {
                this.decryptingCipher = EncryptionUtils.initForDecrypt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.decryptingCipher;
    }

    private void checkColumnIndex(int columnIndex) {
        if (columnIndex < 0) {
            throw new IllegalArgumentException("columnIndex < 0. columnIndex: " + columnIndex);
        }
        if (columnIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("columnIndex >= getColumnCount(). columnIndex: " + columnIndex + " getColumnCount(): " + this.getColumnCount());
        }
    }

    public byte[] getBlob(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        if (this.isColumnEncrypted(columnIndex)) {
            throw new IllegalStateException("Blob encryption is not supported. Use getString(int columnIndex) instead.");
        }
        return super.getBlob(columnIndex);
    }

    public String getString(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        try {
            return this.isColumnEncrypted(columnIndex) ? EncryptionUtils.decrypt(this.getDecryptingCipher(), super.getString(columnIndex)) : super.getString(columnIndex);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while decrypting cursor", e);
        }
    }

    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        this.checkColumnIndex(columnIndex);
        if (this.isColumnEncrypted(columnIndex)) {
            throw new IllegalStateException("copyStringToBuffer is not supported for encrypted data. Use getString(int columnIndex) instead.");
        }
        super.copyStringToBuffer(columnIndex, buffer);
    }

    public short getShort(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        if (this.isColumnEncrypted(columnIndex)) {
            String strVal = this.getString(columnIndex);
            return strVal != null ? Short.parseShort(strVal) : (short)0;
        }
        return super.getShort(columnIndex);
    }

    public int getInt(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        if (this.isColumnEncrypted(columnIndex)) {
            String strVal = this.getString(columnIndex);
            return strVal != null ? Integer.parseInt(strVal) : 0;
        }
        return super.getInt(columnIndex);
    }

    public long getLong(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        if (this.isColumnEncrypted(columnIndex)) {
            String strVal = this.getString(columnIndex);
            return strVal != null ? Long.parseLong(strVal) : 0L;
        }
        return super.getLong(columnIndex);
    }

    public float getFloat(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        if (this.isColumnEncrypted(columnIndex)) {
            String strVal = this.getString(columnIndex);
            return strVal != null ? Float.parseFloat(strVal) : 0.0f;
        }
        return super.getFloat(columnIndex);
    }

    public double getDouble(int columnIndex) {
        this.checkColumnIndex(columnIndex);
        if (this.isColumnEncrypted(columnIndex)) {
            String strVal = this.getString(columnIndex);
            return strVal != null ? Double.parseDouble(strVal) : 0.0;
        }
        return super.getDouble(columnIndex);
    }
}

