/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra.loadbalancing;

import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import systems.composable.dropwizard.cassandra.loadbalancing.LoadBalancingPolicyFactory;

@JsonTypeName(value="dcAwareRoundRobin")
public class DCAwareRoundRobinPolicyFactory
implements LoadBalancingPolicyFactory {
    private String localDC;
    private Integer usedHostsPerRemoteDC;
    private Boolean allowRemoteDCsForLocalConsistencyLevel;

    @JsonProperty
    public String getLocalDC() {
        return this.localDC;
    }

    @JsonProperty
    public void setLocalDC(String localDC) {
        this.localDC = localDC;
    }

    @JsonProperty
    public Integer getUsedHostsPerRemoteDC() {
        return this.usedHostsPerRemoteDC;
    }

    @JsonProperty
    public void setUsedHostsPerRemoteDC(Integer usedHostsPerRemoteDC) {
        this.usedHostsPerRemoteDC = usedHostsPerRemoteDC;
    }

    @JsonProperty
    public Boolean getAllowRemoteDCsForLocalConsistencyLevel() {
        return this.allowRemoteDCsForLocalConsistencyLevel;
    }

    @JsonProperty
    public void setAllowRemoteDCsForLocalConsistencyLevel(Boolean allowRemoteDCsForLocalConsistencyLevel) {
        this.allowRemoteDCsForLocalConsistencyLevel = allowRemoteDCsForLocalConsistencyLevel;
    }

    @Override
    public LoadBalancingPolicy build() {
        DCAwareRoundRobinPolicy.Builder builder = DCAwareRoundRobinPolicy.builder();
        if (this.allowRemoteDCsForLocalConsistencyLevel == Boolean.TRUE) {
            builder.allowRemoteDCsForLocalConsistencyLevel();
        }
        if (this.localDC != null) {
            builder.withLocalDc(this.localDC);
        }
        if (this.usedHostsPerRemoteDC != null) {
            builder.withUsedHostsPerRemoteDc(this.usedHostsPerRemoteDC.intValue());
        }
        return builder.build();
    }
}

