/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra.ssl;

import com.datastax.driver.core.NettySSLOptions;
import com.datastax.driver.core.SSLOptions;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.ValidationMethod;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import systems.composable.dropwizard.cassandra.ssl.SSLOptionsFactory;

@JsonTypeName(value="netty")
public class NettySSLOptionsFactory
implements SSLOptionsFactory {
    private SslProvider provider;
    private List<String> ciphers;
    private ClientAuth clientAuth;
    private Long sessionCacheSize;
    private Duration sessionTimeout;
    private File trustCertChainFile;
    @Valid
    private KeyManagerConfig keyManager;

    @JsonProperty
    public SslProvider getProvider() {
        return this.provider;
    }

    @JsonProperty
    public void setProvider(SslProvider provider) {
        this.provider = provider;
    }

    @JsonProperty
    public List<String> getCiphers() {
        return this.ciphers;
    }

    @JsonProperty
    public void setCiphers(List<String> ciphers) {
        this.ciphers = ciphers;
    }

    @JsonProperty
    public ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    @JsonProperty
    public void setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
    }

    @JsonProperty
    public Long getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @JsonProperty
    public void setSessionCacheSize(Long sessionCacheSize) {
        this.sessionCacheSize = sessionCacheSize;
    }

    @JsonProperty
    public Duration getSessionTimeout() {
        return this.sessionTimeout;
    }

    @JsonProperty
    public void setSessionTimeout(Duration sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @JsonProperty
    public File getTrustCertChainFile() {
        return this.trustCertChainFile;
    }

    @JsonProperty
    public void setTrustCertChainFile(File trustCertChainFile) {
        this.trustCertChainFile = trustCertChainFile;
    }

    @JsonProperty
    public KeyManagerConfig getKeyManager() {
        return this.keyManager;
    }

    @JsonProperty
    public void setKeyManager(KeyManagerConfig keyManager) {
        this.keyManager = keyManager;
    }

    @ValidationMethod(message="must define keyManager when clientAuth is REQUIRE")
    public boolean isClientAuthConfigValid() {
        return this.clientAuth != ClientAuth.REQUIRE || this.keyManager != null;
    }

    @Override
    public SSLOptions build() {
        SslContext sslContext;
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
        if (this.provider != null) {
            sslContextBuilder.sslProvider(this.provider);
        }
        if (this.ciphers != null) {
            sslContextBuilder.ciphers(this.ciphers);
        }
        if (this.clientAuth != null) {
            sslContextBuilder.clientAuth(this.clientAuth);
        }
        if (this.sessionCacheSize != null) {
            sslContextBuilder.sessionCacheSize(this.sessionCacheSize.longValue());
        }
        if (this.sessionTimeout != null) {
            sslContextBuilder.sessionTimeout(this.sessionTimeout.toSeconds());
        }
        if (this.trustCertChainFile != null) {
            sslContextBuilder.trustManager(this.trustCertChainFile);
        }
        if (this.keyManager != null) {
            sslContextBuilder.keyManager(this.keyManager.getKeyCertChainFile(), this.keyManager.getKeyFile(), this.keyManager.getKeyPassword());
        }
        try {
            sslContext = sslContextBuilder.build();
        }
        catch (SSLException e) {
            throw new RuntimeException("Unable to build Netty SslContext", e);
        }
        return new NettySSLOptions(sslContext);
    }

    static class KeyManagerConfig {
        @NotNull
        private File keyCertChainFile;
        @NotNull
        private File keyFile;
        private String keyPassword;

        KeyManagerConfig() {
        }

        @JsonProperty
        public File getKeyCertChainFile() {
            return this.keyCertChainFile;
        }

        @JsonProperty
        public void setKeyCertChainFile(File keyCertChainFile) {
            this.keyCertChainFile = keyCertChainFile;
        }

        @JsonProperty
        public File getKeyFile() {
            return this.keyFile;
        }

        @JsonProperty
        public void setKeyFile(File keyFile) {
            this.keyFile = keyFile;
        }

        @JsonProperty
        public String getKeyPassword() {
            return this.keyPassword;
        }

        @JsonProperty
        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }
    }
}

