/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra.speculativeexecution;

import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.util.Duration;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import systems.composable.dropwizard.cassandra.speculativeexecution.SpeculativeExecutionPolicyFactory;

@JsonTypeName(value="constant")
public class ConstantSpeculativeExecutionPolicyFactory
implements SpeculativeExecutionPolicyFactory {
    @NotNull
    private Duration delay;
    @NotNull
    @Min(value=1L)
    private Integer maxSpeculativeExecutions;

    @JsonProperty
    public Duration getDelay() {
        return this.delay;
    }

    @JsonProperty
    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    @JsonProperty
    public Integer getMaxSpeculativeExecutions() {
        return this.maxSpeculativeExecutions;
    }

    @JsonProperty
    public void setMaxSpeculativeExecutions(Integer maxSpeculativeExecutions) {
        this.maxSpeculativeExecutions = maxSpeculativeExecutions;
    }

    @Override
    public SpeculativeExecutionPolicy build() {
        return new ConstantSpeculativeExecutionPolicy(this.delay.toMilliseconds(), this.maxSpeculativeExecutions.intValue());
    }
}

