/*
 * Decompiled with CFR 0.152.
 */
package systems.composable.dropwizard.cassandra.loadbalancing;

import com.datastax.driver.core.policies.LatencyAwarePolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.util.Duration;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import systems.composable.dropwizard.cassandra.loadbalancing.LoadBalancingPolicyFactory;

@JsonTypeName(value="latencyAware")
public class LatencyAwarePolicyFactory
implements LoadBalancingPolicyFactory {
    @Valid
    @NotNull
    private LoadBalancingPolicyFactory subPolicy;
    private Double exclusionThreshold;
    private Integer minimumMeasurements;
    private Duration retryPeriod;
    private Duration scale;
    private Duration updateRate;

    @JsonProperty
    public LoadBalancingPolicyFactory getSubPolicy() {
        return this.subPolicy;
    }

    @JsonProperty
    public void setSubPolicy(LoadBalancingPolicyFactory subPolicy) {
        this.subPolicy = subPolicy;
    }

    @JsonProperty
    public Double getExclusionThreshold() {
        return this.exclusionThreshold;
    }

    @JsonProperty
    public void setExclusionThreshold(Double exclusionThreshold) {
        this.exclusionThreshold = exclusionThreshold;
    }

    @JsonProperty
    public Integer getMinimumMeasurements() {
        return this.minimumMeasurements;
    }

    @JsonProperty
    public void setMinimumMeasurements(Integer minimumMeasurements) {
        this.minimumMeasurements = minimumMeasurements;
    }

    @JsonProperty
    public Duration getRetryPeriod() {
        return this.retryPeriod;
    }

    @JsonProperty
    public void setRetryPeriod(Duration retryPeriod) {
        this.retryPeriod = retryPeriod;
    }

    @JsonProperty
    public Duration getScale() {
        return this.scale;
    }

    @JsonProperty
    public void setScale(Duration scale) {
        this.scale = scale;
    }

    @JsonProperty
    public Duration getUpdateRate() {
        return this.updateRate;
    }

    @JsonProperty
    public void setUpdateRate(Duration updateRate) {
        this.updateRate = updateRate;
    }

    @Override
    public LoadBalancingPolicy build() {
        LatencyAwarePolicy.Builder builder = LatencyAwarePolicy.builder((LoadBalancingPolicy)this.subPolicy.build());
        if (this.exclusionThreshold != null) {
            builder.withExclusionThreshold(this.exclusionThreshold.doubleValue());
        }
        if (this.minimumMeasurements != null) {
            builder.withMininumMeasurements(this.minimumMeasurements.intValue());
        }
        if (this.retryPeriod != null) {
            builder.withRetryPeriod(this.retryPeriod.getQuantity(), this.retryPeriod.getUnit());
        }
        if (this.scale != null) {
            builder.withScale(this.scale.getQuantity(), this.scale.getUnit());
        }
        if (this.updateRate != null) {
            builder.withUpdateRate(this.updateRate.getQuantity(), this.updateRate.getUnit());
        }
        return builder.build();
    }
}

