/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import systems.comodal.collision.cache.AtomicLogCounters;
import systems.comodal.collision.cache.BaseEntryCollisionCache;
import systems.comodal.collision.cache.KeyVal;

final class SparseEntryCollisionCache<K, L, V>
extends BaseEntryCollisionCache<K, L, V> {
    private final int capacity;
    private final boolean strict;
    private final AtomicInteger size;

    SparseEntryCollisionCache(int capacity, boolean strictCapacity, int maxCollisionsShift, KeyVal<K, V>[][] hashTable, IntFunction<KeyVal<K, V>[]> getBucket, AtomicLogCounters counters, ToIntFunction<K> hashCoder, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        super(maxCollisionsShift, hashTable, getBucket, counters, hashCoder, loader, mapper);
        this.capacity = capacity;
        this.strict = strictCapacity;
        this.size = new AtomicInteger();
    }

    @Override
    public <I> V getAggressive(K key, Function<K, I> loader, BiFunction<K, I, V> mapper) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int counterOffset = hash << this.maxCollisionsShift;
        int index = 0;
        do {
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                I loaded = loader.apply(key);
                if (loaded == null) {
                    return null;
                }
                if (index == 0) {
                    if (this.strict && this.size.get() > this.capacity) {
                        return mapper.apply(key, loaded);
                    }
                } else if (this.size.get() > this.capacity) {
                    return this.checkDecayAndProbSwap(counterOffset, collisions, key, loaded, mapper);
                }
                KeyVal<K, V> entry = new KeyVal<K, V>(key, mapper.apply(key, loaded));
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque(counterOffset + index);
                        this.size.getAndIncrement();
                        return entry.val;
                    }
                    if (!key.equals(collision.key)) continue;
                    this.counters.increment(counterOffset + index);
                    return collision.val;
                } while (++index < collisions.length && this.size.get() <= this.capacity);
                return this.checkDecayAndProbSwap(counterOffset, collisions, entry);
            }
            if (!key.equals(collision.key)) continue;
            this.counters.increment(counterOffset + index);
            return collision.val;
        } while (++index < collisions.length);
        I loaded = loader.apply(key);
        return loaded == null ? null : (V)this.checkDecayAndProbSwap(counterOffset, collisions, key, loaded, mapper);
    }

    private <I> V checkDecayAndProbSwap(int counterOffset, KeyVal<K, V>[] collisions, K key, I loaded, BiFunction<K, I, V> mapper) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal<K, V>[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = mapper.apply(key, loaded);
                    KeyVal<K, V> entry = new KeyVal<K, V>(key, val);
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, entry);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var10_10] (shouldn't be in output)
                            return val;
                        }
                        if (key.equals(collision.key)) {
                            this.counters.increment(counterIndex);
                            // ** MonitorExit[var10_10] (shouldn't be in output)
                            return collision.val;
                        }
                        // ** MonitorExit[var10_10] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return val;
                }
                if (key.equals(collision.key)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return collision.val;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            V val = mapper.apply(key, loaded);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, new KeyVal<K, V>(key, val));
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var10_10] (shouldn't be in output)
                return val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var10_10] (shouldn't be in output)
            return val;
        }
    }

    private V checkDecayAndProbSwap(int counterOffset, KeyVal<K, V>[] collisions, KeyVal<K, V> entry) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal<K, V>[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, entry);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var8_8] (shouldn't be in output)
                            return entry.val;
                        }
                        if (entry.key.equals(collision.key)) {
                            this.counters.increment(counterIndex);
                            // ** MonitorExit[var8_8] (shouldn't be in output)
                            return collision.val;
                        }
                        // ** MonitorExit[var8_8] (shouldn't be in output)
                        return entry.val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return entry.val;
                }
                if (entry.key.equals(collision.key)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return collision.val;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var8_8] (shouldn't be in output)
                return entry.val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return entry.val;
        }
    }

    @Override
    V checkDecayAndSwap(int counterOffset, KeyVal<K, V>[] collisions, K key, Function<K, V> loadAndMap) {
        if (this.size.get() > this.capacity) {
            return this.checkDecayAndProbSwap(counterOffset, collisions, key, loadAndMap);
        }
        int index = 0;
        KeyVal<K, V>[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = loadAndMap.apply(key);
                    if (val == null) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return null;
                    }
                    if (index == 0) {
                        if (this.strict && this.size.get() > this.capacity) {
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return val;
                        }
                    } else if (this.size.get() > this.capacity) {
                        this.decaySwapAndDrop(counterOffset, counterOffset + index, collisions, new KeyVal<K, V>(key, val));
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return val;
                    }
                    KeyVal<K, V> entry = new KeyVal<K, V>(key, val);
                    do {
                        if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                            this.counters.initializeOpaque(counterOffset + index);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return val;
                        }
                        if (!key.equals(collision.key)) continue;
                        this.counters.increment(counterOffset + index);
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return collision.val;
                    } while (++index == collisions.length);
                    this.decayAndSwap(counterOffset, counterOffset + collisions.length, collisions, entry);
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return val;
                }
                if (!key.equals(collision.key)) continue;
                this.counters.increment(counterOffset + index);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return collision.val;
            } while (++index != collisions.length);
            V val = loadAndMap.apply(key);
            if (val == null) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return null;
            }
            if (this.size.get() > this.capacity) {
                this.decaySwapAndDrop(counterOffset, counterOffset + collisions.length, collisions, new KeyVal<K, V>(key, val));
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return val;
            }
            this.decayAndSwap(counterOffset, counterOffset + collisions.length, collisions, new KeyVal<K, V>(key, val));
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return val;
        }
    }

    @Override
    V checkDecayAndProbSwap(int counterOffset, KeyVal<K, V>[] collisions, K key, Function<K, V> loadAndMap) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal<K, V>[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = loadAndMap.apply(key);
                    if (val == null) {
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return null;
                    }
                    if (index == 0) {
                        if (this.strict && this.size.get() > this.capacity) {
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return val;
                        }
                    } else if (this.size.get() > this.capacity) {
                        COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, new KeyVal<K, V>(key, val));
                        this.counters.initializeOpaque(minCounterIndex);
                        this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return val;
                    }
                    KeyVal<K, V> entry = new KeyVal<K, V>(key, val);
                    do {
                        if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                            this.counters.initializeOpaque(counterOffset + index);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return val;
                        }
                        if (!key.equals(collision.key)) continue;
                        this.counters.increment(counterOffset + index);
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return collision.val;
                    } while (++index == collisions.length);
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.counters.decay(counterOffset, counterOffset + collisions.length, minCounterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return val;
                }
                if (key.equals(collision.key)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return collision.val;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            V val = loadAndMap.apply(key);
            if (val == null) {
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return null;
            }
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, new KeyVal<K, V>(key, val));
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return val;
        }
    }

    private void decayAndDrop(int counterOffset, int maxCounterIndex, int skipIndex, KeyVal<K, V>[] collisions) {
        int counterIndex = counterOffset;
        do {
            if (counterIndex == skipIndex) continue;
            int count = this.counters.getOpaque(counterIndex);
            if (count == 0) {
                if (counterIndex < skipIndex) continue;
                if (this.size.getAndDecrement() <= this.capacity) {
                    this.size.getAndIncrement();
                    continue;
                }
                int collisionIndex = counterIndex - counterOffset;
                int nextCollisionIndex = collisionIndex + 1;
                while (true) {
                    if (nextCollisionIndex == collisions.length) {
                        COLLISIONS.setOpaque(collisions, collisionIndex, null);
                        return;
                    }
                    Object next = COLLISIONS.getOpaque(collisions, nextCollisionIndex);
                    if (next == null) {
                        COLLISIONS.setOpaque(collisions, collisionIndex, null);
                        next = COLLISIONS.getOpaque(collisions, nextCollisionIndex);
                        if (next == null || COLLISIONS.compareAndExchange(collisions, collisionIndex, null, next) != null) {
                            return;
                        }
                    } else {
                        COLLISIONS.setOpaque(collisions, collisionIndex, next);
                    }
                    count = this.counters.getOpaque(++counterIndex);
                    this.counters.setOpaque(counterIndex - 1, count >> 1);
                    ++collisionIndex;
                    ++nextCollisionIndex;
                }
            }
            this.counters.setOpaque(counterIndex, count >> 1);
        } while (++counterIndex < maxCounterIndex);
    }

    private void decaySwapAndDrop(int counterOffset, int maxCounterIndex, KeyVal<K, V>[] collisions, KeyVal<K, V> entry) {
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        do {
            int count;
            if ((count = this.counters.getOpaque(counterIndex)) == 0) {
                COLLISIONS.setOpaque(collisions, counterIndex - counterOffset, entry);
                this.counters.initializeOpaque(counterIndex);
                while (++counterIndex < maxCounterIndex) {
                    count = this.counters.getOpaque(counterIndex);
                    if (count > 0) {
                        this.counters.setOpaque(counterIndex, count >> 1);
                        continue;
                    }
                    if (this.size.getAndDecrement() <= this.capacity) {
                        this.size.getAndIncrement();
                        continue;
                    }
                    int collisionIndex = counterIndex - counterOffset;
                    int nextCollisionIndex = collisionIndex + 1;
                    while (true) {
                        if (nextCollisionIndex == collisions.length) {
                            COLLISIONS.setOpaque(collisions, collisionIndex, null);
                            return;
                        }
                        Object next = COLLISIONS.getOpaque(collisions, nextCollisionIndex);
                        if (next == null) {
                            COLLISIONS.setOpaque(collisions, collisionIndex, null);
                            next = COLLISIONS.getOpaque(collisions, nextCollisionIndex);
                            if (next == null || COLLISIONS.compareAndExchange(collisions, collisionIndex, null, next) != null) {
                                return;
                            }
                        } else {
                            COLLISIONS.setOpaque(collisions, collisionIndex, next);
                        }
                        count = this.counters.getOpaque(++counterIndex);
                        this.counters.setOpaque(counterIndex - 1, count >> 1);
                        ++collisionIndex;
                        ++nextCollisionIndex;
                    }
                }
                return;
            }
            this.counters.setOpaque(counterIndex, count >> 1);
            if (count >= minCount) continue;
            minCount = count;
            minCounterIndex = counterIndex;
        } while (++counterIndex < maxCounterIndex);
        COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
        this.counters.initializeOpaque(minCounterIndex);
    }

    @Override
    public V putReplace(K key, V val) {
        int counterOffset;
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int index = 0;
        KeyVal<K, V> entry = null;
        do {
            KeyVal witness;
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                if (index == 0) {
                    if (this.strict && this.size.get() > this.capacity) {
                        return val;
                    }
                } else if (this.size.get() > this.capacity) break;
                if (entry == null) {
                    entry = new KeyVal<K, V>(key, val);
                }
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (!key.equals(collision.key)) continue;
                    return collision.val;
                } while (++index < collisions.length && this.size.get() <= this.capacity);
                break;
            }
            if (collision.val == val) {
                return val;
            }
            if (!key.equals(collision.key)) continue;
            if (entry == null) {
                entry = new KeyVal<K, V>(key, val);
            }
            if ((witness = COLLISIONS.compareAndExchange(collisions, index, collision, entry)) == collision) {
                return val;
            }
            if (!key.equals(witness.key)) continue;
            return witness.val;
        } while (++index < collisions.length);
        index = 0;
        int counterIndex = counterOffset = hash << this.maxCollisionsShift;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal[] keyValArray = collisions;
        synchronized (collisions) {
            while (true) {
                int count;
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    if (entry == null) {
                        entry = new KeyVal<K, V>(key, val);
                    }
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, entry);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var11_13] (shouldn't be in output)
                            return val;
                        }
                        if (key.equals(collision.key)) {
                            // ** MonitorExit[var11_13] (shouldn't be in output)
                            return collision.val;
                        }
                        // ** MonitorExit[var11_13] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                    // ** MonitorExit[var11_13] (shouldn't be in output)
                    return val;
                }
                if (collision.val == val) {
                    // ** MonitorExit[var11_13] (shouldn't be in output)
                    return val;
                }
                if (key.equals(collision.key)) {
                    KeyVal witness;
                    if (entry == null) {
                        entry = new KeyVal<K, V>(key, val);
                    }
                    if ((witness = COLLISIONS.compareAndExchange(collisions, index, collision, entry)) == collision) {
                        // ** MonitorExit[var11_13] (shouldn't be in output)
                        return val;
                    }
                    if (key.equals(witness.key)) {
                        // ** MonitorExit[var11_13] (shouldn't be in output)
                        return witness.val;
                    }
                }
                if ((count = this.counters.getOpaque(counterIndex)) < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                if (++index == collisions.length) {
                    if (entry == null) {
                        entry = new KeyVal<K, V>(key, val);
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    if (this.size.get() > this.capacity) {
                        this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                        // ** MonitorExit[var11_13] (shouldn't be in output)
                        return val;
                    }
                    this.counters.decay(counterOffset, counterIndex, minCounterIndex);
                    // ** MonitorExit[var11_13] (shouldn't be in output)
                    return val;
                }
                ++counterIndex;
            }
        }
    }

    @Override
    public V putIfAbsent(K key, V val) {
        int counterOffset;
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int index = 0;
        KeyVal<K, V> entry = null;
        do {
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                if (index == 0) {
                    if (this.strict && this.size.get() > this.capacity) {
                        return val;
                    }
                } else if (this.size.get() > this.capacity) break;
                entry = new KeyVal<K, V>(key, val);
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (!key.equals(collision.key)) continue;
                    return collision.val;
                } while (++index < collisions.length && this.size.get() <= this.capacity);
                break;
            }
            if (!key.equals(collision.key)) continue;
            return collision.val;
        } while (++index < collisions.length);
        index = 0;
        int counterIndex = counterOffset = hash << this.maxCollisionsShift;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    if (entry == null) {
                        entry = new KeyVal<K, V>(key, val);
                    }
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, entry);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var11_12] (shouldn't be in output)
                            return val;
                        }
                        if (key.equals(collision.key)) {
                            // ** MonitorExit[var11_12] (shouldn't be in output)
                            return collision.val;
                        }
                        // ** MonitorExit[var11_12] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                    // ** MonitorExit[var11_12] (shouldn't be in output)
                    return val;
                }
                if (key.equals(collision.key)) {
                    // ** MonitorExit[var11_12] (shouldn't be in output)
                    return collision.val;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            if (entry == null) {
                entry = new KeyVal<K, V>(key, val);
            }
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var11_12] (shouldn't be in output)
                return val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var11_12] (shouldn't be in output)
            return val;
        }
    }

    @Override
    public V putIfSpaceAbsent(K key, V val) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int index = 0;
        do {
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                if (this.size.get() > this.capacity) {
                    return null;
                }
                KeyVal<K, V> entry = new KeyVal<K, V>(key, val);
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (!key.equals(collision.key)) continue;
                    return collision.val;
                } while (++index < collisions.length && this.size.get() <= this.capacity);
                return null;
            }
            if (!key.equals(collision.key)) continue;
            return collision.val;
        } while (++index < collisions.length);
        return null;
    }

    @Override
    public V putIfSpaceReplace(K key, V val) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int index = 0;
        KeyVal<K, V> entry = null;
        do {
            KeyVal witness;
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                if (this.size.get() > this.capacity) {
                    return null;
                }
                if (entry == null) {
                    entry = new KeyVal<K, V>(key, val);
                }
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (!key.equals(collision.key)) continue;
                    return collision.val;
                } while (++index < collisions.length && this.size.get() <= this.capacity);
                return null;
            }
            if (collision.val == val) {
                return val;
            }
            if (!key.equals(collision.key)) continue;
            if (entry == null) {
                entry = new KeyVal<K, V>(key, val);
            }
            if ((witness = COLLISIONS.compareAndExchange(collisions, index, collision, entry)) == collision) {
                return val;
            }
            if (!key.equals(witness.key)) continue;
            return witness.val;
        } while (++index < collisions.length);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) {
        KeyVal[] collisions;
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] keyValArray = collisions = (KeyVal[])this.getBucket.apply(hash);
        synchronized (collisions) {
            int index = 0;
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                if (!key.equals(collision.key)) continue;
                this.size.getAndDecrement();
                int counterOffset = hash << this.maxCollisionsShift;
                int counterIndex = counterOffset + index;
                int nextIndex = index + 1;
                while (true) {
                    if (nextIndex == collisions.length) {
                        COLLISIONS.setOpaque(collisions, index, null);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return true;
                    }
                    Object next = COLLISIONS.getOpaque(collisions, nextIndex);
                    if (next == null) {
                        COLLISIONS.setOpaque(collisions, index, null);
                        next = COLLISIONS.getOpaque(collisions, nextIndex);
                        if (next == null || COLLISIONS.compareAndExchange(collisions, index, null, next) != null) {
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return true;
                        }
                    } else {
                        COLLISIONS.setOpaque(collisions, index, next);
                    }
                    int count = this.counters.getOpaque(++counterIndex);
                    this.counters.setOpaque(counterIndex - 1, count >> 1);
                    ++index;
                    ++nextIndex;
                }
            } while (++index < collisions.length);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        KeyVal[][] keyValArray = this.hashTable;
        synchronized (this.hashTable) {
            IntStream.range(0, this.hashTable.length).parallel().forEach(i -> {
                KeyVal[] collisions = COLLISIONS.getOpaque(this.hashTable, i);
                if (collisions == null) {
                    return;
                }
                int index = 0;
                do {
                    Object collision;
                    if ((collision = COLLISIONS.getAndSet(collisions, index, null)) == null) continue;
                    this.size.getAndDecrement();
                } while (++index < collisions.length);
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String toString() {
        return "SparseEntryCollisionCache{capacity=" + this.capacity + ", strictCapacity=" + this.strict + ", size=" + this.size.get() + ", " + super.toString() + "}";
    }
}

