/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import systems.comodal.collision.cache.AtomicLogCounters;
import systems.comodal.collision.cache.BaseCollisionCache;

final class SparseCollisionCache<K, L, V>
extends BaseCollisionCache<K, L, V> {
    private final int capacity;
    private final boolean strict;
    private final AtomicInteger size;

    SparseCollisionCache(int capacity, boolean strictCapacity, Class<V> valueType, int maxCollisionsShift, V[][] hashTable, IntFunction<V[]> getBucket, AtomicLogCounters counters, ToIntFunction<K> hashCoder, BiPredicate<K, V> isValForKey, Function<K, L> loader, BiFunction<K, L, V> finalizer) {
        super(valueType, maxCollisionsShift, hashTable, getBucket, counters, hashCoder, isValForKey, loader, finalizer);
        this.capacity = capacity;
        this.strict = strictCapacity;
        this.size = new AtomicInteger();
    }

    @Override
    public <I> V getAggressive(K key, Function<K, I> loader, BiFunction<K, I, V> mapper) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int counterOffset = hash << this.maxCollisionsShift;
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                I loaded = loader.apply(key);
                if (loaded == null) {
                    return null;
                }
                if (index == 0) {
                    if (this.strict && this.size.get() > this.capacity) {
                        return mapper.apply(key, loaded);
                    }
                } else if (this.size.get() > this.capacity) {
                    return (V)this.checkDecayAndProbSwap(counterOffset, collisions, key, loaded, mapper);
                }
                V val = mapper.apply(key, loaded);
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                        this.counters.initializeOpaque(counterOffset + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (!this.isValForKey.test(key, collision)) continue;
                    this.counters.increment(counterOffset + index);
                    return (V)collision;
                } while (++index < collisions.length && this.size.get() <= this.capacity);
                return (V)this.checkDecayAndProbSwap(counterOffset, collisions, key, val);
            }
            if (!this.isValForKey.test(key, collision)) continue;
            this.counters.increment(counterOffset + index);
            return (V)collision;
        } while (++index < collisions.length);
        I loaded = loader.apply(key);
        return (V)(loaded == null ? null : this.checkDecayAndProbSwap(counterOffset, collisions, key, loaded, mapper));
    }

    private <I> V checkDecayAndProbSwap(int counterOffset, V[] collisions, K key, I loaded, BiFunction<K, I, V> mapper) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        V[] VArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = mapper.apply(key, loaded);
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, val);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var10_10] (shouldn't be in output)
                            return val;
                        }
                        if (this.isValForKey.test(key, collision)) {
                            this.counters.increment(counterIndex);
                            // ** MonitorExit[var10_10] (shouldn't be in output)
                            return (V)collision;
                        }
                        // ** MonitorExit[var10_10] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return (V)collision;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            V val = mapper.apply(key, loaded);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var10_10] (shouldn't be in output)
                return val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var10_10] (shouldn't be in output)
            return val;
        }
    }

    private V checkDecayAndProbSwap(int counterOffset, V[] collisions, K key, V val) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        V[] VArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, val);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return val;
                        }
                        if (this.isValForKey.test(key, collision)) {
                            this.counters.increment(counterIndex);
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return (V)collision;
                        }
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return (V)collision;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return val;
        }
    }

    @Override
    V checkDecayAndSwap(int counterOffset, V[] collisions, K key, Function<K, V> loadAndMap) {
        if (this.size.get() > this.capacity) {
            return this.checkDecayAndProbSwap(counterOffset, collisions, key, loadAndMap);
        }
        int index = 0;
        V[] VArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = loadAndMap.apply(key);
                    if (val == null) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return null;
                    }
                    if (index == 0) {
                        if (this.strict && this.size.get() > this.capacity) {
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return val;
                        }
                    } else if (this.size.get() > this.capacity) {
                        this.decaySwapAndDrop(counterOffset, counterOffset + index, collisions, val);
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return val;
                    }
                    do {
                        if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                            this.counters.initializeOpaque(counterOffset + index);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return val;
                        }
                        if (!this.isValForKey.test(key, collision)) continue;
                        this.counters.increment(counterOffset + index);
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return (V)collision;
                    } while (++index == collisions.length);
                    this.decayAndSwap(counterOffset, counterOffset + collisions.length, collisions, val);
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return val;
                }
                if (!this.isValForKey.test(key, collision)) continue;
                this.counters.increment(counterOffset + index);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return (V)collision;
            } while (++index != collisions.length);
            V val = loadAndMap.apply(key);
            if (val == null) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return null;
            }
            if (this.size.get() > this.capacity) {
                this.decaySwapAndDrop(counterOffset, counterOffset + collisions.length, collisions, val);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return val;
            }
            this.decayAndSwap(counterOffset, counterOffset + collisions.length, collisions, val);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return val;
        }
    }

    @Override
    V checkDecayAndProbSwap(int counterOffset, V[] collisions, K key, Function<K, V> loadAndMap) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        V[] VArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = loadAndMap.apply(key);
                    if (val == null) {
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return null;
                    }
                    if (index == 0) {
                        if (this.strict && this.size.get() > this.capacity) {
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return val;
                        }
                    } else if (this.size.get() > this.capacity) {
                        COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                        this.counters.initializeOpaque(minCounterIndex);
                        this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return val;
                    }
                    do {
                        if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                            this.counters.initializeOpaque(counterOffset + index);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return val;
                        }
                        if (!this.isValForKey.test(key, collision)) continue;
                        this.counters.increment(counterOffset + index);
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return (V)collision;
                    } while (++index == collisions.length);
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.counters.decay(counterOffset, counterOffset + collisions.length, minCounterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return (V)collision;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            V val = loadAndMap.apply(key);
            if (val == null) {
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return null;
            }
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return val;
        }
    }

    private void decaySwapAndDrop(int counterOffset, int maxCounterIndex, V[] collisions, V val) {
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        do {
            int count;
            if ((count = this.counters.getOpaque(counterIndex)) == 0) {
                COLLISIONS.setOpaque(collisions, counterIndex - counterOffset, val);
                this.counters.initializeOpaque(counterIndex);
                while (++counterIndex < maxCounterIndex) {
                    count = this.counters.getOpaque(counterIndex);
                    if (count > 0) {
                        this.counters.setOpaque(counterIndex, count >> 1);
                        continue;
                    }
                    if (this.size.getAndDecrement() <= this.capacity) {
                        this.size.getAndIncrement();
                        continue;
                    }
                    int collisionIndex = counterIndex - counterOffset;
                    int nextCollisionIndex = collisionIndex + 1;
                    while (true) {
                        if (nextCollisionIndex == collisions.length) {
                            COLLISIONS.setOpaque(collisions, collisionIndex, null);
                            return;
                        }
                        Object next = COLLISIONS.getOpaque(collisions, nextCollisionIndex);
                        if (next == null) {
                            COLLISIONS.setOpaque(collisions, collisionIndex, null);
                            next = COLLISIONS.getOpaque(collisions, nextCollisionIndex);
                            if (next == null || COLLISIONS.compareAndExchange(collisions, collisionIndex, null, next) != null) {
                                return;
                            }
                        } else {
                            COLLISIONS.setOpaque(collisions, collisionIndex, next);
                        }
                        count = this.counters.getOpaque(++counterIndex);
                        this.counters.setOpaque(counterIndex - 1, count >> 1);
                        ++collisionIndex;
                        ++nextCollisionIndex;
                    }
                }
                return;
            }
            this.counters.setOpaque(counterIndex, count >> 1);
            if (count >= minCount) continue;
            minCount = count;
            minCounterIndex = counterIndex;
        } while (++counterIndex < maxCounterIndex);
        COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
        this.counters.initializeOpaque(minCounterIndex);
    }

    @Override
    public V putReplace(K key, V val) {
        int counterOffset;
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                if (index == 0) {
                    if (this.strict && this.size.get() > this.capacity) {
                        return val;
                    }
                } else if (this.size.get() > this.capacity) break;
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (!this.isValForKey.test(key, collision)) continue;
                    return (V)collision;
                } while (++index < collisions.length && this.size.get() <= this.capacity);
                break;
            }
            if (collision == val) {
                return val;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            Object witness = COLLISIONS.compareAndExchange(collisions, index, collision, val);
            if (witness == collision) {
                return val;
            }
            if (!this.isValForKey.test(key, witness)) continue;
            return (V)witness;
        } while (++index < collisions.length);
        index = 0;
        int counterIndex = counterOffset = hash << this.maxCollisionsShift;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        Object[] objectArray = collisions;
        synchronized (collisions) {
            do {
                int count;
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, val);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var10_12] (shouldn't be in output)
                            return val;
                        }
                        if (this.isValForKey.test(key, collision)) {
                            // ** MonitorExit[var10_12] (shouldn't be in output)
                            return (V)collision;
                        }
                        // ** MonitorExit[var10_12] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                    // ** MonitorExit[var10_12] (shouldn't be in output)
                    return val;
                }
                if (collision == val) {
                    // ** MonitorExit[var10_12] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    Object witness = COLLISIONS.compareAndExchange(collisions, index, collision, val);
                    if (witness == collision) {
                        // ** MonitorExit[var10_12] (shouldn't be in output)
                        return val;
                    }
                    if (this.isValForKey.test(key, witness)) {
                        // ** MonitorExit[var10_12] (shouldn't be in output)
                        return (V)witness;
                    }
                }
                if ((count = this.counters.getOpaque(counterIndex)) < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var10_12] (shouldn't be in output)
                return val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var10_12] (shouldn't be in output)
            return val;
        }
    }

    @Override
    public V putIfAbsent(K key, V val) {
        int counterOffset;
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                if (index == 0) {
                    if (this.strict && this.size.get() > this.capacity) {
                        return val;
                    }
                } else if (this.size.get() > this.capacity) break;
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (!this.isValForKey.test(key, collision)) continue;
                    return (V)collision;
                } while (++index < collisions.length && this.size.get() <= this.capacity);
                break;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            return (V)collision;
        } while (++index < collisions.length);
        index = 0;
        int counterIndex = counterOffset = hash << this.maxCollisionsShift;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        Object[] objectArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, val);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            this.size.getAndIncrement();
                            // ** MonitorExit[var10_11] (shouldn't be in output)
                            return val;
                        }
                        if (this.isValForKey.test(key, collision)) {
                            // ** MonitorExit[var10_11] (shouldn't be in output)
                            return (V)collision;
                        }
                        // ** MonitorExit[var10_11] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                    // ** MonitorExit[var10_11] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    // ** MonitorExit[var10_11] (shouldn't be in output)
                    return (V)collision;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            if (this.size.get() > this.capacity) {
                this.decayAndDrop(counterOffset, counterIndex, minCounterIndex, collisions);
                // ** MonitorExit[var10_11] (shouldn't be in output)
                return val;
            }
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var10_11] (shouldn't be in output)
            return val;
        }
    }

    private void decayAndDrop(int counterOffset, int maxCounterIndex, int skipIndex, V[] collisions) {
        int counterIndex = counterOffset;
        do {
            if (counterIndex == skipIndex) continue;
            int count = this.counters.getOpaque(counterIndex);
            if (count == 0) {
                if (counterIndex < skipIndex) continue;
                if (this.size.getAndDecrement() <= this.capacity) {
                    this.size.getAndIncrement();
                    continue;
                }
                int collisionIndex = counterIndex - counterOffset;
                int nextCollisionIndex = collisionIndex + 1;
                while (true) {
                    if (nextCollisionIndex == collisions.length) {
                        COLLISIONS.setOpaque(collisions, collisionIndex, null);
                        return;
                    }
                    Object next = COLLISIONS.getOpaque(collisions, nextCollisionIndex);
                    if (next == null) {
                        COLLISIONS.setOpaque(collisions, collisionIndex, null);
                        next = COLLISIONS.getOpaque(collisions, nextCollisionIndex);
                        if (next == null || COLLISIONS.compareAndExchange(collisions, collisionIndex, null, next) != null) {
                            return;
                        }
                    } else {
                        COLLISIONS.setOpaque(collisions, collisionIndex, next);
                    }
                    count = this.counters.getOpaque(++counterIndex);
                    this.counters.setOpaque(counterIndex - 1, count >> 1);
                    ++collisionIndex;
                    ++nextCollisionIndex;
                }
            }
            this.counters.setOpaque(counterIndex, count >> 1);
        } while (++counterIndex < maxCounterIndex);
    }

    @Override
    public V putIfSpaceAbsent(K key, V val) {
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                while (this.size.get() <= this.capacity) {
                    collision = COLLISIONS.compareAndExchange(collisions, index, null, val);
                    if (collision == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (this.isValForKey.test(key, collision)) {
                        return (V)collision;
                    }
                    if (++index != collisions.length) continue;
                    return null;
                }
                return null;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            return (V)collision;
        } while (++index < collisions.length);
        return null;
    }

    @Override
    public V putIfSpaceReplace(K key, V val) {
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                while (this.size.get() <= this.capacity) {
                    collision = COLLISIONS.compareAndExchange(collisions, index, null, val);
                    if (collision == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        this.size.getAndIncrement();
                        return val;
                    }
                    if (this.isValForKey.test(key, collision)) {
                        return (V)collision;
                    }
                    if (++index != collisions.length) continue;
                    return null;
                }
                return null;
            }
            if (collision == val) {
                return val;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            Object witness = COLLISIONS.compareAndExchange(collisions, index, collision, val);
            if (witness == collision) {
                return val;
            }
            if (!this.isValForKey.test(key, witness)) continue;
            return (V)witness;
        } while (++index < collisions.length);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) {
        Object[] collisions;
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] objectArray = collisions = (Object[])this.getBucket.apply(hash);
        synchronized (collisions) {
            int index = 0;
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                if (!this.isValForKey.test(key, collision)) continue;
                this.size.getAndDecrement();
                int counterOffset = hash << this.maxCollisionsShift;
                int counterIndex = counterOffset + index;
                int nextIndex = index + 1;
                while (true) {
                    if (nextIndex == collisions.length) {
                        COLLISIONS.setOpaque(collisions, index, null);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return true;
                    }
                    Object next = COLLISIONS.getOpaque(collisions, nextIndex);
                    if (next == null) {
                        COLLISIONS.setOpaque(collisions, index, null);
                        next = COLLISIONS.getOpaque(collisions, nextIndex);
                        if (next == null || COLLISIONS.compareAndExchange(collisions, index, null, next) != null) {
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return true;
                        }
                    } else {
                        COLLISIONS.setOpaque(collisions, index, next);
                    }
                    int count = this.counters.getOpaque(++counterIndex);
                    this.counters.setOpaque(counterIndex - 1, count >> 1);
                    ++index;
                    ++nextIndex;
                }
            } while (++index < collisions.length);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object[][] objectArray = this.hashTable;
        synchronized (this.hashTable) {
            IntStream.range(0, this.hashTable.length).parallel().forEach(i -> {
                Object[] collisions = COLLISIONS.getOpaque(this.hashTable, i);
                if (collisions == null) {
                    return;
                }
                int index = 0;
                do {
                    Object collision;
                    if ((collision = COLLISIONS.getAndSet(collisions, index, null)) == null) continue;
                    this.size.getAndDecrement();
                } while (++index < collisions.length);
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String toString() {
        return "SparseCollisionCache{capacity=" + this.capacity + ", strictCapacity=" + this.strict + ", size=" + this.size.get() + ", " + super.toString() + "}";
    }
}

