/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import systems.comodal.collision.cache.AtomicLogCounters;
import systems.comodal.collision.cache.BaseEntryCollisionCache;
import systems.comodal.collision.cache.KeyVal;

final class PackedEntryCollisionCache<K, L, V>
extends BaseEntryCollisionCache<K, L, V> {
    PackedEntryCollisionCache(int maxCollisionsShift, KeyVal<K, V>[][] hashTable, IntFunction<KeyVal<K, V>[]> getBucket, AtomicLogCounters counters, ToIntFunction<K> hashCoder, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        super(maxCollisionsShift, hashTable, getBucket, counters, hashCoder, loader, mapper);
    }

    @Override
    public <I> V getAggressive(K key, Function<K, I> loader, BiFunction<K, I, V> mapper) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int counterOffset = hash << this.maxCollisionsShift;
        int index = 0;
        do {
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                I loaded = loader.apply(key);
                if (loaded == null) {
                    return null;
                }
                KeyVal<K, V> entry = new KeyVal<K, V>(key, mapper.apply(key, loaded));
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque(counterOffset + index);
                        return entry.val;
                    }
                    if (!key.equals(collision.key)) continue;
                    this.counters.increment(counterOffset + index);
                    return collision.val;
                } while (++index < collisions.length);
                return this.checkDecayAndProbSwap(counterOffset, collisions, entry);
            }
            if (!key.equals(collision.key)) continue;
            this.counters.increment(counterOffset + index);
            return collision.val;
        } while (++index < collisions.length);
        I loaded = loader.apply(key);
        return loaded == null ? null : (V)this.checkDecayAndProbSwap(counterOffset, collisions, key, loaded, mapper);
    }

    private V checkDecayAndProbSwap(int counterOffset, KeyVal<K, V>[] collisions, KeyVal<K, V> entry) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal<K, V>[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, entry);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            // ** MonitorExit[var8_8] (shouldn't be in output)
                            return entry.val;
                        }
                        if (entry.key.equals(collision.key)) {
                            this.counters.increment(counterIndex);
                            // ** MonitorExit[var8_8] (shouldn't be in output)
                            return collision.val;
                        }
                        // ** MonitorExit[var8_8] (shouldn't be in output)
                        return entry.val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.counters.decay(counterOffset, counterIndex, minCounterIndex);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return entry.val;
                }
                if (entry.key.equals(collision.key)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return collision.val;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return entry.val;
        }
    }

    private <I> V checkDecayAndProbSwap(int counterOffset, KeyVal<K, V>[] collisions, K key, I loaded, BiFunction<K, I, V> mapper) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal<K, V>[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = mapper.apply(key, loaded);
                    KeyVal<K, V> entry = new KeyVal<K, V>(key, val);
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, entry);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            // ** MonitorExit[var10_10] (shouldn't be in output)
                            return val;
                        }
                        if (key.equals(collision.key)) {
                            this.counters.increment(counterIndex);
                            // ** MonitorExit[var10_10] (shouldn't be in output)
                            return collision.val;
                        }
                        // ** MonitorExit[var10_10] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.counters.decay(counterOffset, counterIndex, minCounterIndex);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return val;
                }
                if (key.equals(collision.key)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return collision.val;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            V val = mapper.apply(key, loaded);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, new KeyVal<K, V>(key, val));
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var10_10] (shouldn't be in output)
            return val;
        }
    }

    @Override
    V checkDecayAndSwap(int counterOffset, KeyVal<K, V>[] collisions, K key, Function<K, V> loadAndMap) {
        int index = 0;
        KeyVal<K, V>[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = loadAndMap.apply(key);
                    if (val == null) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return null;
                    }
                    KeyVal<K, V> entry = new KeyVal<K, V>(key, val);
                    do {
                        if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                            this.counters.initializeOpaque(counterOffset + index);
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return val;
                        }
                        if (!key.equals(collision.key)) continue;
                        this.counters.increment(counterOffset + index);
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return collision.val;
                    } while (++index == collisions.length);
                    this.decayAndSwap(counterOffset, counterOffset + collisions.length, collisions, entry);
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return val;
                }
                if (!key.equals(collision.key)) continue;
                this.counters.increment(counterOffset + index);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return collision.val;
            } while (++index != collisions.length);
            V val = loadAndMap.apply(key);
            if (val == null) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return null;
            }
            this.decayAndSwap(counterOffset, counterOffset + collisions.length, collisions, new KeyVal<K, V>(key, val));
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return val;
        }
    }

    @Override
    V checkDecayAndProbSwap(int counterOffset, KeyVal<K, V>[] collisions, K key, Function<K, V> loadAndMap) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal<K, V>[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = loadAndMap.apply(key);
                    if (val == null) {
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return null;
                    }
                    KeyVal<K, V> entry = new KeyVal<K, V>(key, val);
                    do {
                        if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                            this.counters.initializeOpaque(counterOffset + index);
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return val;
                        }
                        if (!key.equals(collision.key)) continue;
                        this.counters.increment(counterOffset + index);
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return collision.val;
                    } while (++index == collisions.length);
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.counters.decay(counterOffset, counterOffset + collisions.length, minCounterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return val;
                }
                if (key.equals(collision.key)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return collision.val;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            V val = loadAndMap.apply(key);
            if (val == null) {
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return null;
            }
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, new KeyVal<K, V>(key, val));
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return val;
        }
    }

    @Override
    public V putReplace(K key, V val) {
        int counterOffset;
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int index = 0;
        KeyVal<K, V> entry = null;
        do {
            KeyVal witness;
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                if (entry == null) {
                    entry = new KeyVal<K, V>(key, val);
                }
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        return val;
                    }
                    if (!key.equals(collision.key)) continue;
                    return collision.val;
                } while (++index < collisions.length);
                break;
            }
            if (collision.val == val) {
                return val;
            }
            if (!key.equals(collision.key)) continue;
            if (entry == null) {
                entry = new KeyVal<K, V>(key, val);
            }
            if ((witness = COLLISIONS.compareAndExchange(collisions, index, collision, entry)) == collision) {
                return val;
            }
            if (!key.equals(witness.key)) continue;
            return witness.val;
        } while (++index < collisions.length);
        index = 0;
        int counterIndex = counterOffset = hash << this.maxCollisionsShift;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                int count;
                KeyVal collision = COLLISIONS.getOpaque(collisions, index);
                if (collision.val == val) {
                    // ** MonitorExit[var11_13] (shouldn't be in output)
                    return val;
                }
                if (key.equals(collision.key)) {
                    KeyVal witness;
                    if (entry == null) {
                        entry = new KeyVal<K, V>(key, val);
                    }
                    if ((witness = COLLISIONS.compareAndExchange(collisions, index, collision, entry)) == collision) {
                        // ** MonitorExit[var11_13] (shouldn't be in output)
                        return val;
                    }
                    if (key.equals(witness.key)) {
                        // ** MonitorExit[var11_13] (shouldn't be in output)
                        return witness.val;
                    }
                }
                if ((count = this.counters.getOpaque(counterIndex)) < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            if (entry == null) {
                entry = new KeyVal<K, V>(key, val);
            }
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var11_13] (shouldn't be in output)
            return val;
        }
    }

    @Override
    public V putIfAbsent(K key, V val) {
        int counterOffset;
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int index = 0;
        KeyVal<K, V> entry = null;
        do {
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                entry = new KeyVal<K, V>(key, val);
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        return val;
                    }
                    if (!key.equals(collision.key)) continue;
                    return collision.val;
                } while (++index < collisions.length);
                break;
            }
            if (!key.equals(collision.key)) continue;
            return collision.val;
        } while (++index < collisions.length);
        index = 0;
        int counterIndex = counterOffset = hash << this.maxCollisionsShift;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        KeyVal[] keyValArray = collisions;
        synchronized (collisions) {
            do {
                KeyVal collision = COLLISIONS.getOpaque(collisions, index);
                if (key.equals(collision.key)) {
                    // ** MonitorExit[var11_12] (shouldn't be in output)
                    return collision.val;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            if (entry == null) {
                entry = new KeyVal<K, V>(key, val);
            }
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var11_12] (shouldn't be in output)
            return val;
        }
    }

    @Override
    public V putIfSpaceAbsent(K key, V val) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int index = 0;
        do {
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                KeyVal<K, V> entry = new KeyVal<K, V>(key, val);
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        return val;
                    }
                    if (!key.equals(collision.key)) continue;
                    return collision.val;
                } while (++index < collisions.length);
                return null;
            }
            if (!key.equals(collision.key)) continue;
            return collision.val;
        } while (++index < collisions.length);
        return null;
    }

    @Override
    public V putIfSpaceReplace(K key, V val) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = (KeyVal[])this.getBucket.apply(hash);
        int index = 0;
        KeyVal<K, V> entry = null;
        do {
            KeyVal witness;
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                if (entry == null) {
                    entry = new KeyVal<K, V>(key, val);
                }
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, entry)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        return val;
                    }
                    if (!key.equals(collision.key)) continue;
                    return collision.val;
                } while (++index < collisions.length);
                return null;
            }
            if (collision.val == val) {
                return val;
            }
            if (!key.equals(collision.key)) continue;
            if (entry == null) {
                entry = new KeyVal<K, V>(key, val);
            }
            if ((witness = COLLISIONS.compareAndExchange(collisions, index, collision, entry)) == collision) {
                return val;
            }
            if (!key.equals(witness.key)) continue;
            return witness.val;
        } while (++index < collisions.length);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) {
        KeyVal[] collisions;
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] keyValArray = collisions = (KeyVal[])this.getBucket.apply(hash);
        synchronized (collisions) {
            int index = 0;
            do {
                KeyVal collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                if (!key.equals(collision.key)) continue;
                int counterOffset = hash << this.maxCollisionsShift;
                int counterIndex = counterOffset + index;
                int nextIndex = index + 1;
                while (true) {
                    if (nextIndex == collisions.length) {
                        COLLISIONS.setOpaque(collisions, index, null);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return true;
                    }
                    Object next = COLLISIONS.getOpaque(collisions, nextIndex);
                    if (next == null) {
                        COLLISIONS.setOpaque(collisions, index, null);
                        next = COLLISIONS.getOpaque(collisions, nextIndex);
                        if (next == null || COLLISIONS.compareAndExchange(collisions, index, null, next) != null) {
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return true;
                        }
                    } else {
                        COLLISIONS.setOpaque(collisions, index, next);
                    }
                    int count = this.counters.getOpaque(++counterIndex);
                    this.counters.setOpaque(counterIndex - 1, count >> 1);
                    ++index;
                    ++nextIndex;
                }
            } while (++index < collisions.length);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public String toString() {
        return "PackedEntryCollisionCache{" + super.toString() + "}";
    }
}

