/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import systems.comodal.collision.cache.AtomicLogCounters;
import systems.comodal.collision.cache.BaseCollisionCache;

final class PackedCollisionCache<K, L, V>
extends BaseCollisionCache<K, L, V> {
    PackedCollisionCache(Class<V> valueType, int maxCollisionsShift, V[][] hashTable, IntFunction<V[]> getBucket, AtomicLogCounters counters, ToIntFunction<K> hashCoder, BiPredicate<K, V> isValForKey, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        super(valueType, maxCollisionsShift, hashTable, getBucket, counters, hashCoder, isValForKey, loader, mapper);
    }

    @Override
    public <I> V getAggressive(K key, Function<K, I> loader, BiFunction<K, I, V> mapper) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int counterOffset = hash << this.maxCollisionsShift;
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                I loaded = loader.apply(key);
                if (loaded == null) {
                    return null;
                }
                V val = mapper.apply(key, loaded);
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                        this.counters.initializeOpaque(counterOffset + index);
                        return val;
                    }
                    if (!this.isValForKey.test(key, collision)) continue;
                    this.counters.increment(counterOffset + index);
                    return (V)collision;
                } while (++index < collisions.length);
                return (V)this.checkDecayAndProbSwap(counterOffset, collisions, key, val);
            }
            if (!this.isValForKey.test(key, collision)) continue;
            this.counters.increment(counterOffset + index);
            return (V)collision;
        } while (++index < collisions.length);
        I loaded = loader.apply(key);
        return (V)(loaded == null ? null : this.checkDecayAndProbSwap(counterOffset, collisions, key, loaded, mapper));
    }

    private V checkDecayAndProbSwap(int counterOffset, V[] collisions, K key, V val) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        V[] VArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, val);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return val;
                        }
                        if (this.isValForKey.test(key, collision)) {
                            this.counters.increment(counterIndex);
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return (V)collision;
                        }
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.counters.decay(counterOffset, counterIndex, minCounterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return (V)collision;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return val;
        }
    }

    private <I> V checkDecayAndProbSwap(int counterOffset, V[] collisions, K key, I loaded, BiFunction<K, I, V> mapper) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        V[] VArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = mapper.apply(key, loaded);
                    if (index == 0) {
                        collision = COLLISIONS.compareAndExchange(collisions, index, null, val);
                        if (collision == null) {
                            this.counters.initializeOpaque(counterIndex);
                            // ** MonitorExit[var10_10] (shouldn't be in output)
                            return val;
                        }
                        if (this.isValForKey.test(key, collision)) {
                            this.counters.increment(counterIndex);
                            // ** MonitorExit[var10_10] (shouldn't be in output)
                            return (V)collision;
                        }
                        // ** MonitorExit[var10_10] (shouldn't be in output)
                        return val;
                    }
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.counters.decay(counterOffset, counterIndex, minCounterIndex);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var10_10] (shouldn't be in output)
                    return (V)collision;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            V val = mapper.apply(key, loaded);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var10_10] (shouldn't be in output)
            return val;
        }
    }

    @Override
    V checkDecayAndSwap(int counterOffset, V[] collisions, K key, Function<K, V> loadAndMap) {
        int index = 0;
        V[] VArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = loadAndMap.apply(key);
                    if (val == null) {
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return null;
                    }
                    do {
                        if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                            this.counters.initializeOpaque(counterOffset + index);
                            // ** MonitorExit[var6_6] (shouldn't be in output)
                            return val;
                        }
                        if (!this.isValForKey.test(key, collision)) continue;
                        this.counters.increment(counterOffset + index);
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return (V)collision;
                    } while (++index == collisions.length);
                    this.decayAndSwap(counterOffset, counterOffset + collisions.length, collisions, val);
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return val;
                }
                if (!this.isValForKey.test(key, collision)) continue;
                this.counters.increment(counterOffset + index);
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return (V)collision;
            } while (++index != collisions.length);
            V val = loadAndMap.apply(key);
            if (val == null) {
                // ** MonitorExit[var6_6] (shouldn't be in output)
                return null;
            }
            this.decayAndSwap(counterOffset, counterOffset + collisions.length, collisions, val);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return val;
        }
    }

    @Override
    V checkDecayAndProbSwap(int counterOffset, V[] collisions, K key, Function<K, V> loadAndMap) {
        int index = 0;
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        V[] VArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    V val = loadAndMap.apply(key);
                    if (val == null) {
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return null;
                    }
                    do {
                        if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                            this.counters.initializeOpaque(counterOffset + index);
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return val;
                        }
                        if (!this.isValForKey.test(key, collision)) continue;
                        this.counters.increment(counterOffset + index);
                        // ** MonitorExit[var9_9] (shouldn't be in output)
                        return (V)collision;
                    } while (++index == collisions.length);
                    COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
                    this.counters.initializeOpaque(minCounterIndex);
                    this.counters.decay(counterOffset, counterOffset + collisions.length, minCounterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    this.counters.increment(counterIndex);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return (V)collision;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            V val = loadAndMap.apply(key);
            if (val == null) {
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return null;
            }
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var9_9] (shouldn't be in output)
            return val;
        }
    }

    @Override
    public V putReplace(K key, V val) {
        int counterOffset;
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        return val;
                    }
                    if (!this.isValForKey.test(key, collision)) continue;
                    return (V)collision;
                } while (++index < collisions.length);
                break;
            }
            if (collision == val) {
                return val;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            Object witness = COLLISIONS.compareAndExchange(collisions, index, collision, val);
            if (witness == collision) {
                return val;
            }
            if (!this.isValForKey.test(key, witness)) continue;
            return (V)witness;
        } while (++index < collisions.length);
        index = 0;
        int counterIndex = counterOffset = hash << this.maxCollisionsShift;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        Object[] objectArray = collisions;
        synchronized (collisions) {
            do {
                int count;
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == val) {
                    // ** MonitorExit[var10_12] (shouldn't be in output)
                    return val;
                }
                if (this.isValForKey.test(key, collision)) {
                    Object witness = COLLISIONS.compareAndExchange(collisions, index, collision, val);
                    if (witness == collision) {
                        // ** MonitorExit[var10_12] (shouldn't be in output)
                        return val;
                    }
                    if (this.isValForKey.test(key, witness)) {
                        // ** MonitorExit[var10_12] (shouldn't be in output)
                        return (V)witness;
                    }
                }
                if ((count = this.counters.getOpaque(counterIndex)) < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var10_12] (shouldn't be in output)
            return val;
        }
    }

    @Override
    public V putIfAbsent(K key, V val) {
        int counterOffset;
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        return val;
                    }
                    if (!this.isValForKey.test(key, collision)) continue;
                    return (V)collision;
                } while (++index < collisions.length);
                break;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            return (V)collision;
        } while (++index < collisions.length);
        index = 0;
        int counterIndex = counterOffset = hash << this.maxCollisionsShift;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        Object[] objectArray = collisions;
        synchronized (collisions) {
            do {
                Object collision;
                if (this.isValForKey.test(key, collision = COLLISIONS.getOpaque(collisions, index))) {
                    // ** MonitorExit[var10_11] (shouldn't be in output)
                    return (V)collision;
                }
                int count = this.counters.getOpaque(counterIndex);
                if (count < minCount) {
                    minCount = count;
                    minCounterIndex = counterIndex;
                }
                ++counterIndex;
            } while (++index != collisions.length);
            COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
            this.counters.initializeOpaque(minCounterIndex);
            this.counters.decay(counterOffset, counterIndex, minCounterIndex);
            // ** MonitorExit[var10_11] (shouldn't be in output)
            return val;
        }
    }

    @Override
    public V putIfSpaceAbsent(K key, V val) {
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        return val;
                    }
                    if (!this.isValForKey.test(key, collision)) continue;
                    return (V)collision;
                } while (++index < collisions.length);
                return null;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            return (V)collision;
        } while (++index < collisions.length);
        return null;
    }

    @Override
    public V putIfSpaceReplace(K key, V val) {
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = (Object[])this.getBucket.apply(hash);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                do {
                    if ((collision = COLLISIONS.compareAndExchange(collisions, index, null, val)) == null) {
                        this.counters.initializeOpaque((hash << this.maxCollisionsShift) + index);
                        return val;
                    }
                    if (!this.isValForKey.test(key, collision)) continue;
                    return (V)collision;
                } while (++index < collisions.length);
                return null;
            }
            if (collision == val) {
                return val;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            Object witness = COLLISIONS.compareAndExchange(collisions, index, collision, val);
            if (witness == collision) {
                return val;
            }
            if (!key.equals(witness)) continue;
            return (V)witness;
        } while (++index < collisions.length);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key) {
        Object[] collisions;
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] objectArray = collisions = (Object[])this.getBucket.apply(hash);
        synchronized (collisions) {
            int index = 0;
            do {
                Object collision;
                if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                if (!this.isValForKey.test(key, collision)) continue;
                int counterOffset = hash << this.maxCollisionsShift;
                int counterIndex = counterOffset + index;
                int nextIndex = index + 1;
                while (true) {
                    if (nextIndex == collisions.length) {
                        COLLISIONS.setOpaque(collisions, index, null);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return true;
                    }
                    Object next = COLLISIONS.getOpaque(collisions, nextIndex);
                    if (next == null) {
                        COLLISIONS.setOpaque(collisions, index, null);
                        next = COLLISIONS.getOpaque(collisions, nextIndex);
                        if (next == null || COLLISIONS.compareAndExchange(collisions, index, null, next) != null) {
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return true;
                        }
                    } else {
                        COLLISIONS.setOpaque(collisions, index, next);
                    }
                    int count = this.counters.getOpaque(++counterIndex);
                    this.counters.setOpaque(counterIndex - 1, count >> 1);
                    ++index;
                    ++nextIndex;
                }
            } while (++index < collisions.length);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return false;
        }
    }

    @Override
    public String toString() {
        return "PackedCollisionCache{" + super.toString() + "}";
    }
}

