/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import systems.comodal.collision.cache.KeyedCollisionBuilder;
import systems.comodal.collision.cache.LoadingCollisionCache;

public final class LoadingCollisionBuilder<K, L, V> {
    private final KeyedCollisionBuilder<K, V> delegate;
    private final Function<K, L> loader;
    private final BiFunction<K, L, V> mapper;

    LoadingCollisionBuilder(KeyedCollisionBuilder<K, V> delegate, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        this.delegate = delegate;
        this.loader = loader;
        this.mapper = mapper;
    }

    public LoadingCollisionCache<K, L, V> buildSparse() {
        return this.buildSparse(3.0);
    }

    public LoadingCollisionCache<K, L, V> buildSparse(double sparseFactor) {
        return this.delegate.buildSparse(sparseFactor, this.loader, this.mapper);
    }

    public LoadingCollisionCache<K, L, V> buildPacked() {
        return this.delegate.buildPacked(this.loader, this.mapper);
    }

    public int getCapacity() {
        return this.delegate.getCapacity();
    }

    public ToIntFunction<K> getHashCoder() {
        return this.delegate.getHashCoder();
    }

    public LoadingCollisionBuilder<K, L, V> setHashCoder(ToIntFunction<K> hashCoder) {
        this.delegate.setHashCoder(hashCoder);
        return this;
    }

    public BiPredicate<K, V> getIsValForKey() {
        return this.delegate.getIsValForKey();
    }

    public LoadingCollisionBuilder<K, L, V> setIsValForKey(BiPredicate<K, V> isValForKey) {
        this.delegate.setIsValForKey(isValForKey);
        return this;
    }

    public boolean isStrictCapacity() {
        return this.delegate.isStrictCapacity();
    }

    public LoadingCollisionBuilder<K, L, V> setStrictCapacity(boolean strictCapacity) {
        this.delegate.setStrictCapacity(strictCapacity);
        return this;
    }

    public Class<V> getValueType() {
        return this.delegate.getValueType();
    }

    public LoadingCollisionBuilder<K, L, V> setValueType(Class<V> valueType) {
        this.delegate.setValueType(valueType);
        return this;
    }

    public int getBucketSize() {
        return this.delegate.getBucketSize();
    }

    public LoadingCollisionBuilder<K, L, V> setBucketSize(int bucketSize) {
        this.delegate.setBucketSize(bucketSize);
        return this;
    }

    public int getInitCount() {
        return this.delegate.getInitCount();
    }

    public LoadingCollisionBuilder<K, L, V> setInitCount(int initCount) {
        this.delegate.setInitCount(initCount);
        return this;
    }

    public int getMaxCounterVal() {
        return this.delegate.getMaxCounterVal();
    }

    public LoadingCollisionBuilder<K, L, V> setMaxCounterVal(int maxCounterVal) {
        this.delegate.setMaxCounterVal(maxCounterVal);
        return this;
    }

    public boolean isLazyInitBuckets() {
        return this.delegate.isLazyInitBuckets();
    }

    public LoadingCollisionBuilder<K, L, V> setLazyInitBuckets(boolean lazyInitBuckets) {
        this.delegate.setLazyInitBuckets(lazyInitBuckets);
        return this;
    }

    public boolean isStoreKeys() {
        return this.delegate.isStoreKeys();
    }

    public LoadingCollisionBuilder<K, L, V> setStoreKeys(boolean storeKeys) {
        this.delegate.setStoreKeys(storeKeys);
        return this;
    }
}

