/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import systems.comodal.collision.cache.CollisionBuilder;
import systems.comodal.collision.cache.CollisionCache;
import systems.comodal.collision.cache.LoadingCollisionBuilder;
import systems.comodal.collision.cache.LoadingCollisionCache;

public final class KeyedCollisionBuilder<K, V> {
    private final CollisionBuilder<V> delegate;
    private ToIntFunction<K> hashCoder;
    private BiPredicate<K, V> isValForKey;

    KeyedCollisionBuilder(CollisionBuilder<V> delegate, ToIntFunction<K> hashCoder) {
        this(delegate, hashCoder, null);
    }

    KeyedCollisionBuilder(CollisionBuilder<V> delegate, BiPredicate<K, V> isValForKey) {
        this(delegate, null, isValForKey);
    }

    KeyedCollisionBuilder(CollisionBuilder<V> delegate) {
        this(delegate, null, null);
    }

    KeyedCollisionBuilder(CollisionBuilder<V> delegate, ToIntFunction<K> hashCoder, BiPredicate<K, V> isValForKey) {
        this.delegate = delegate;
        this.hashCoder = hashCoder;
        this.isValForKey = isValForKey;
        if (isValForKey != null) {
            delegate.setStoreKeys(false);
        }
    }

    public CollisionCache<K, V> buildSparse() {
        return this.buildSparse(3.0);
    }

    public CollisionCache<K, V> buildSparse(double sparseFactor) {
        return this.buildSparse(sparseFactor, key -> null, null);
    }

    <L> LoadingCollisionCache<K, L, V> buildSparse(double sparseFactor, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        return this.delegate.buildSparse(sparseFactor, this.getHashCoder(), this.getIsValForKey(), loader, mapper);
    }

    public CollisionCache<K, V> buildPacked() {
        return this.buildPacked(key -> null, null);
    }

    <L> LoadingCollisionCache<K, L, V> buildPacked(Function<K, L> loader, BiFunction<K, L, V> mapper) {
        return this.delegate.buildPacked(this.getHashCoder(), this.getIsValForKey(), loader, mapper);
    }

    public int getCapacity() {
        return this.delegate.getCapacity();
    }

    public LoadingCollisionBuilder<K, V, V> setLoader(Function<K, V> loader) {
        return this.setLoader(loader, (key, val) -> val);
    }

    public <L> LoadingCollisionBuilder<K, L, V> setLoader(Function<K, L> loader, BiFunction<K, L, V> mapper) {
        return new LoadingCollisionBuilder<K, L, V>(this, loader, mapper);
    }

    public ToIntFunction<K> getHashCoder() {
        return this.hashCoder == null ? CollisionBuilder.DEFAULT_HASH_CODER : this.hashCoder;
    }

    public KeyedCollisionBuilder<K, V> setHashCoder(ToIntFunction<K> hashCoder) {
        this.hashCoder = hashCoder;
        return this;
    }

    public BiPredicate<K, V> getIsValForKey() {
        return this.isValForKey == null ? CollisionBuilder.DEFAULT_IS_VAL_FOR_KEY : this.isValForKey;
    }

    public KeyedCollisionBuilder<K, V> setIsValForKey(BiPredicate<K, V> isValForKey) {
        this.delegate.setStoreKeys(false);
        this.isValForKey = isValForKey;
        return this;
    }

    public boolean isStrictCapacity() {
        return this.delegate.isStrictCapacity();
    }

    public KeyedCollisionBuilder<K, V> setStrictCapacity(boolean strictCapacity) {
        this.delegate.setStrictCapacity(strictCapacity);
        return this;
    }

    public Class<V> getValueType() {
        return this.delegate.getValueType();
    }

    public KeyedCollisionBuilder<K, V> setValueType(Class<V> valueType) {
        this.delegate.setValueType(valueType);
        return this;
    }

    public int getBucketSize() {
        return this.delegate.getBucketSize();
    }

    public KeyedCollisionBuilder<K, V> setBucketSize(int bucketSize) {
        this.delegate.setBucketSize(bucketSize);
        return this;
    }

    public int getInitCount() {
        return this.delegate.getInitCount();
    }

    public KeyedCollisionBuilder<K, V> setInitCount(int initCount) {
        this.delegate.setInitCount(initCount);
        return this;
    }

    public int getMaxCounterVal() {
        return this.delegate.getMaxCounterVal();
    }

    public KeyedCollisionBuilder<K, V> setMaxCounterVal(int maxCounterVal) {
        this.delegate.setMaxCounterVal(maxCounterVal);
        return this;
    }

    public boolean isLazyInitBuckets() {
        return this.delegate.isLazyInitBuckets();
    }

    public KeyedCollisionBuilder<K, V> setLazyInitBuckets(boolean lazyInitBuckets) {
        this.delegate.setLazyInitBuckets(lazyInitBuckets);
        return this;
    }

    public boolean isStoreKeys() {
        return this.delegate.isStoreKeys();
    }

    public KeyedCollisionBuilder<K, V> setStoreKeys(boolean storeKeys) {
        this.delegate.setStoreKeys(storeKeys);
        return this;
    }
}

