/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.util.function.BiFunction;
import java.util.function.Function;
import systems.comodal.collision.cache.CollisionBuilder;

public interface CollisionCache<K, V> {
    public static <V> CollisionBuilder<V> withCapacity(int capacity) {
        return new CollisionBuilder(capacity);
    }

    public static <V> CollisionBuilder<V> withCapacity(int capacity, Class<V> valueType) {
        return new CollisionBuilder<V>(capacity).setValueType(valueType);
    }

    public V get(K var1);

    public V get(K var1, Function<K, V> var2);

    public V getAggressive(K var1);

    public <I> V getAggressive(K var1, Function<K, I> var2, BiFunction<K, I, V> var3);

    public V putReplace(K var1, V var2);

    public V replace(K var1, V var2);

    public V putIfAbsent(K var1, V var2);

    public V putIfSpaceAbsent(K var1, V var2);

    public V putIfSpaceReplace(K var1, V var2);

    public V getIfPresent(K var1);

    public boolean remove(K var1);

    public void clear();
}

