/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import systems.comodal.collision.cache.AtomicLogCounters;
import systems.comodal.collision.cache.CollisionCache;
import systems.comodal.collision.cache.KeyVal;
import systems.comodal.collision.cache.KeyedCollisionBuilder;
import systems.comodal.collision.cache.LoadingCollisionBuilder;
import systems.comodal.collision.cache.LoadingCollisionCache;
import systems.comodal.collision.cache.PackedCollisionCache;
import systems.comodal.collision.cache.PackedEntryCollisionCache;
import systems.comodal.collision.cache.SparseCollisionCache;
import systems.comodal.collision.cache.SparseEntryCollisionCache;

public final class CollisionBuilder<V> {
    static final int DEFAULT_SPARSE_BUCKET_SIZE = 4;
    static final int DEFAULT_PACKED_BUCKET_SIZE = 8;
    static final Function<?, ?> NULL_LOADER = key -> null;
    static final ToIntFunction<?> DEFAULT_HASH_CODER = key -> CollisionBuilder.spread(key.hashCode());
    static final BiPredicate<?, ?> DEFAULT_IS_VAL_FOR_KEY = (val, key) -> val.equals(key);
    static final double DEFAULT_SPARSE_FACTOR = 3.0;
    static final VarHandle BUCKETS = MethodHandles.arrayElementVarHandle(Object[][].class);
    private final int capacity;
    private boolean strictCapacity = false;
    private Class<V> valueType;
    private int bucketSize = 0;
    private int initCount = 5;
    private int maxCounterVal = 0x100000;
    private boolean lazyInitBuckets = false;
    private boolean storeKeys = true;

    CollisionBuilder(int capacity) {
        this.capacity = capacity;
    }

    private static int spread(int hash) {
        return hash ^ hash >>> 16;
    }

    public <K> CollisionCache<K, V> buildSparse() {
        return this.buildSparse(3.0);
    }

    public <K> CollisionCache<K, V> buildSparse(double sparseFactor) {
        return this.buildSparse(sparseFactor, DEFAULT_HASH_CODER, DEFAULT_IS_VAL_FOR_KEY, NULL_LOADER, null);
    }

    <K, L> LoadingCollisionCache<K, L, V> buildSparse(double sparseFactor, ToIntFunction<K> hashCoder, BiPredicate<K, V> isValForKey, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        int bucketSize = this.bucketSize > 0 ? this.bucketSize : 4;
        int maxCollisions = Integer.highestOneBit(bucketSize - 1) << 1;
        int maxCollisionsShift = Integer.numberOfTrailingZeros(maxCollisions);
        AtomicLogCounters counters = AtomicLogCounters.create(Integer.highestOneBit((int)((double)this.capacity * Math.max(1.0, sparseFactor)) - 1) << 1, this.initCount, this.maxCounterVal);
        int hashTableLength = counters.getNumCounters() >> maxCollisionsShift;
        if (this.isStoreKeys()) {
            KeyVal<K, V>[][] hashTable = this.createEntryHashTable(hashTableLength, maxCollisions);
            return new SparseEntryCollisionCache<K, L, V>(this.capacity, this.strictCapacity, maxCollisionsShift, hashTable, this.createEntryGetBucket(hashTable, maxCollisionsShift), counters, hashCoder, loader, mapper);
        }
        V[][] hashTable = this.createHashTable(hashTableLength, maxCollisions);
        return new SparseCollisionCache<K, L, V>(this.capacity, this.strictCapacity, this.valueType, maxCollisionsShift, hashTable, this.createGetBucket(hashTable, maxCollisionsShift), counters, hashCoder, isValForKey, loader, mapper);
    }

    public <K> CollisionCache<K, V> buildPacked() {
        return this.buildPacked(DEFAULT_HASH_CODER, DEFAULT_IS_VAL_FOR_KEY, NULL_LOADER, null);
    }

    <K, L> LoadingCollisionCache<K, L, V> buildPacked(ToIntFunction<K> hashCoder, BiPredicate<K, V> isValForKey, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        int bucketSize = this.bucketSize > 0 ? this.bucketSize : 8;
        int maxCollisions = Integer.highestOneBit(bucketSize - 1) << 1;
        int maxCollisionsShift = Integer.numberOfTrailingZeros(maxCollisions);
        AtomicLogCounters counters = AtomicLogCounters.create(Integer.highestOneBit(this.capacity - 1) << 1, this.initCount, this.maxCounterVal);
        int hashTableLength = counters.getNumCounters() >> maxCollisionsShift;
        if (this.isStoreKeys()) {
            KeyVal<K, V>[][] hashTable = this.createEntryHashTable(hashTableLength, maxCollisions);
            return new PackedEntryCollisionCache<K, L, V>(maxCollisionsShift, hashTable, this.createEntryGetBucket(hashTable, maxCollisionsShift), counters, hashCoder, loader, mapper);
        }
        V[][] hashTable = this.createHashTable(hashTableLength, maxCollisions);
        return new PackedCollisionCache<K, L, V>(this.valueType, maxCollisionsShift, hashTable, this.createGetBucket(hashTable, maxCollisionsShift), counters, hashCoder, isValForKey, loader, mapper);
    }

    private <K, V> KeyVal<K, V>[][] createEntryHashTable(int hashTableLength, int maxCollisions) {
        if (this.lazyInitBuckets) {
            Class<?> valueArrayType = Array.newInstance(KeyVal.class, 0).getClass();
            return (KeyVal[][])Array.newInstance(valueArrayType, hashTableLength);
        }
        return (KeyVal[][])Array.newInstance(KeyVal.class, hashTableLength, maxCollisions);
    }

    private <K, V> IntFunction<KeyVal<K, V>[]> createEntryGetBucket(KeyVal<K, V>[][] hashTable, int maxCollisionsShift) {
        return !this.lazyInitBuckets ? hash -> hashTable[hash] : hash -> {
            KeyVal[] collisions = hashTable[hash];
            if (collisions == null) {
                collisions = (KeyVal[])Array.newInstance(KeyVal.class, 1 << maxCollisionsShift);
                Object witness = BUCKETS.compareAndExchange(hashTable, hash, null, collisions);
                return witness == null ? collisions : (KeyVal[])witness;
            }
            return collisions;
        };
    }

    private V[][] createHashTable(int hashTableLength, int maxCollisions) {
        if (this.valueType == null) {
            throw new IllegalStateException("valueType needed.");
        }
        if (this.lazyInitBuckets) {
            Class<?> valueArrayType = Array.newInstance(this.valueType, 0).getClass();
            return (Object[][])Array.newInstance(valueArrayType, hashTableLength);
        }
        return (Object[][])Array.newInstance(this.valueType, hashTableLength, maxCollisions);
    }

    private <V> IntFunction<V[]> createGetBucket(V[][] hashTable, int maxCollisionsShift) {
        return !this.lazyInitBuckets ? hash -> hashTable[hash] : hash -> {
            Object[] collisions = hashTable[hash];
            if (collisions == null) {
                collisions = (Object[])Array.newInstance(this.valueType, 1 << maxCollisionsShift);
                Object witness = BUCKETS.compareAndExchange(hashTable, hash, null, collisions);
                return witness == null ? collisions : (Object[])witness;
            }
            return collisions;
        };
    }

    public <K> KeyedCollisionBuilder<K, V> setHashCoder(ToIntFunction<K> hashCoder) {
        return new KeyedCollisionBuilder(this, hashCoder);
    }

    public <K> KeyedCollisionBuilder<K, V> setIsValForKey(BiPredicate<K, V> isValForKey) {
        return new KeyedCollisionBuilder<K, V>(this, isValForKey);
    }

    public <K> LoadingCollisionBuilder<K, V, V> setLoader(Function<K, V> loader) {
        return this.setLoader(loader, (key, val) -> val);
    }

    public <K, L> LoadingCollisionBuilder<K, L, V> setLoader(Function<K, L> loader, BiFunction<K, L, V> mapper) {
        return new LoadingCollisionBuilder(new KeyedCollisionBuilder(this), loader, mapper);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isStrictCapacity() {
        return this.strictCapacity;
    }

    public CollisionBuilder<V> setStrictCapacity(boolean strictCapacity) {
        this.strictCapacity = strictCapacity;
        return this;
    }

    public Class<V> getValueType() {
        return this.valueType;
    }

    public CollisionBuilder<V> setValueType(Class<V> valueType) {
        this.valueType = valueType;
        return this;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public CollisionBuilder<V> setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public int getInitCount() {
        return this.initCount;
    }

    public CollisionBuilder<V> setInitCount(int initCount) {
        if (initCount > 32) {
            throw new IllegalStateException("Setting a large initial counter count is pointless.");
        }
        if (initCount < 0) {
            throw new IllegalStateException("Initial counter count must be >= 0.");
        }
        this.initCount = initCount;
        return this;
    }

    public int getMaxCounterVal() {
        return this.maxCounterVal;
    }

    public CollisionBuilder<V> setMaxCounterVal(int maxCounterVal) {
        if (maxCounterVal < 256) {
            throw new IllegalStateException("The maximum counter count should be large to increase the likelihood of choosing the least frequently used entry for eviction.");
        }
        this.maxCounterVal = maxCounterVal;
        return this;
    }

    public boolean isLazyInitBuckets() {
        return this.lazyInitBuckets;
    }

    public CollisionBuilder<V> setLazyInitBuckets(boolean lazyInitBuckets) {
        this.lazyInitBuckets = lazyInitBuckets;
        return this;
    }

    public boolean isStoreKeys() {
        return this.storeKeys;
    }

    public CollisionBuilder<V> setStoreKeys(boolean storeKeys) {
        this.storeKeys = storeKeys;
        return this;
    }
}

