/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import systems.comodal.collision.cache.AtomicLogCounters;
import systems.comodal.collision.cache.KeyVal;
import systems.comodal.collision.cache.LoadingCollisionCache;

abstract class BaseEntryCollisionCache<K, L, V>
implements LoadingCollisionCache<K, L, V> {
    static final VarHandle COLLISIONS = MethodHandles.arrayElementVarHandle(Object[].class);
    final int maxCollisionsShift;
    final KeyVal<K, V>[][] hashTable;
    final int mask;
    final IntFunction<KeyVal<K, V>[]> getBucket;
    final AtomicLogCounters counters;
    final ToIntFunction<K> hashCoder;
    private final Function<K, L> loader;
    private final BiFunction<K, L, V> mapper;
    private final Function<K, V> loadAndMap;

    BaseEntryCollisionCache(int maxCollisionsShift, KeyVal<K, V>[][] hashTable, IntFunction<KeyVal<K, V>[]> getBucket, AtomicLogCounters counters, ToIntFunction<K> hashCoder, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        this.maxCollisionsShift = maxCollisionsShift;
        this.hashTable = hashTable;
        this.mask = hashTable.length - 1;
        this.getBucket = getBucket;
        this.counters = counters;
        this.hashCoder = hashCoder;
        this.loader = loader;
        this.mapper = mapper;
        this.loadAndMap = key -> {
            Object loaded = loader.apply(key);
            return loaded == null ? null : mapper.apply(key, loaded);
        };
    }

    @Override
    public final V getAggressive(K key) {
        return this.getAggressive(key, this.loader, this.mapper);
    }

    @Override
    public final V getAggressive(K key, Function<K, L> loader) {
        return this.getAggressive(key, loader, this.mapper);
    }

    @Override
    public final V get(K key) {
        return this.get(key, this.loadAndMap);
    }

    @Override
    public final V get(K key, Function<K, V> loadAndMap) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = this.getBucket.apply(hash);
        int counterOffset = hash << this.maxCollisionsShift;
        int index = 0;
        do {
            KeyVal collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                return this.checkDecayAndSwap(counterOffset, collisions, key, loadAndMap);
            }
            if (!key.equals(collision.key)) continue;
            this.counters.increment(counterOffset + index);
            return collision.val;
        } while (++index != collisions.length);
        return this.checkDecayAndProbSwap(counterOffset, collisions, key, loadAndMap);
    }

    abstract V checkDecayAndSwap(int var1, KeyVal<K, V>[] var2, K var3, Function<K, V> var4);

    abstract V checkDecayAndProbSwap(int var1, KeyVal<K, V>[] var2, K var3, Function<K, V> var4);

    final void decayAndSwap(int counterOffset, int maxCounterIndex, KeyVal<K, V>[] collisions, KeyVal<K, V> entry) {
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        do {
            int count;
            if ((count = this.counters.getOpaque(counterIndex)) == 0) {
                COLLISIONS.setOpaque(collisions, counterIndex - counterOffset, entry);
                this.counters.initializeOpaque(counterIndex);
                while (++counterIndex < maxCounterIndex) {
                    count = this.counters.getOpaque(counterIndex);
                    if (count == 0) continue;
                    this.counters.setOpaque(counterIndex, count >> 1);
                }
                return;
            }
            this.counters.setOpaque(counterIndex, count >> 1);
            if (count >= minCount) continue;
            minCount = count;
            minCounterIndex = counterIndex;
        } while (++counterIndex < maxCounterIndex);
        COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, entry);
        this.counters.initializeOpaque(minCounterIndex);
    }

    @Override
    public final V getIfPresent(K key) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        KeyVal[] collisions = this.getBucket.apply(hash);
        int index = 0;
        do {
            KeyVal entry;
            if ((entry = COLLISIONS.getOpaque(collisions, index)) == null) {
                return null;
            }
            if (!key.equals(entry.key)) continue;
            this.counters.increment((hash << this.maxCollisionsShift) + index);
            return entry.val;
        } while (++index < collisions.length);
        return null;
    }

    @Override
    public final V replace(K key, V val) {
        KeyVal[] collisions = this.getBucket.apply(this.hashCoder.applyAsInt(key) & this.mask);
        int index = 0;
        do {
            KeyVal entry;
            if ((entry = COLLISIONS.getOpaque(collisions, index)) == null) {
                return null;
            }
            if (entry.val == val) {
                return val;
            }
            if (!key.equals(entry.key)) continue;
            KeyVal witness = COLLISIONS.compareAndExchange(collisions, index, entry, new KeyVal<K, V>(key, val));
            if (witness == entry) {
                return val;
            }
            if (!key.equals(witness.key)) continue;
            return witness.val;
        } while (++index < collisions.length);
        return null;
    }

    @Override
    public void clear() {
        IntStream.range(0, this.hashTable.length).parallel().forEach(i -> {
            KeyVal[] collisions = this.hashTable[i];
            if (collisions == null) {
                return;
            }
            int index = 0;
            do {
                COLLISIONS.setOpaque(collisions, index++, null);
            } while (index < collisions.length);
        });
    }

    public String toString() {
        return "CollisionCache{maxCollisions=" + (1 << this.maxCollisionsShift) + ", hashTableLength=" + this.hashTable.length + ", counters=" + this.counters + "}";
    }
}

