/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import systems.comodal.collision.cache.AtomicLogCounters;
import systems.comodal.collision.cache.LoadingCollisionCache;

abstract class BaseCollisionCache<K, L, V>
implements LoadingCollisionCache<K, L, V> {
    static final VarHandle COLLISIONS = MethodHandles.arrayElementVarHandle(Object[].class);
    final int maxCollisionsShift;
    final V[][] hashTable;
    final int mask;
    final IntFunction<V[]> getBucket;
    final AtomicLogCounters counters;
    final ToIntFunction<K> hashCoder;
    final BiPredicate<K, V> isValForKey;
    private final Class<V> valueType;
    private final Function<K, L> loader;
    private final BiFunction<K, L, V> mapper;
    private final Function<K, V> loadAndMap;

    BaseCollisionCache(Class<V> valueType, int maxCollisionsShift, V[][] hashTable, IntFunction<V[]> getBucket, AtomicLogCounters counters, ToIntFunction<K> hashCoder, BiPredicate<K, V> isValForKey, Function<K, L> loader, BiFunction<K, L, V> mapper) {
        this.valueType = valueType;
        this.maxCollisionsShift = maxCollisionsShift;
        this.hashTable = hashTable;
        this.mask = hashTable.length - 1;
        this.getBucket = getBucket;
        this.counters = counters;
        this.hashCoder = hashCoder;
        this.isValForKey = isValForKey;
        this.loader = loader;
        this.mapper = mapper;
        this.loadAndMap = key -> {
            Object loaded = loader.apply(key);
            return loaded == null ? null : mapper.apply(key, loaded);
        };
    }

    @Override
    public final V getAggressive(K key) {
        return this.getAggressive(key, this.loader, this.mapper);
    }

    @Override
    public final V getAggressive(K key, Function<K, L> loader) {
        return this.getAggressive(key, loader, this.mapper);
    }

    @Override
    public final V get(K key) {
        return this.get(key, this.loadAndMap);
    }

    @Override
    public final V get(K key, Function<K, V> loadAndMap) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = this.getBucket.apply(hash);
        int counterOffset = hash << this.maxCollisionsShift;
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                return (V)this.checkDecayAndSwap(counterOffset, collisions, key, loadAndMap);
            }
            if (!this.isValForKey.test(key, collision)) continue;
            this.counters.increment(counterOffset + index);
            return (V)collision;
        } while (++index != collisions.length);
        return (V)this.checkDecayAndProbSwap(counterOffset, collisions, key, loadAndMap);
    }

    abstract V checkDecayAndSwap(int var1, V[] var2, K var3, Function<K, V> var4);

    abstract V checkDecayAndProbSwap(int var1, V[] var2, K var3, Function<K, V> var4);

    final void decayAndSwap(int counterOffset, int maxCounterIndex, V[] collisions, V val) {
        int counterIndex = counterOffset;
        int minCounterIndex = counterOffset;
        int minCount = 255;
        do {
            int count;
            if ((count = this.counters.getOpaque(counterIndex)) == 0) {
                COLLISIONS.setOpaque(collisions, counterIndex - counterOffset, val);
                this.counters.initializeOpaque(counterIndex);
                while (++counterIndex < maxCounterIndex) {
                    count = this.counters.getOpaque(counterIndex);
                    if (count == 0) continue;
                    this.counters.setOpaque(counterIndex, count >> 1);
                }
                return;
            }
            this.counters.setOpaque(counterIndex, count >> 1);
            if (count >= minCount) continue;
            minCount = count;
            minCounterIndex = counterIndex;
        } while (++counterIndex < maxCounterIndex);
        COLLISIONS.setOpaque(collisions, minCounterIndex - counterOffset, val);
        this.counters.initializeOpaque(counterIndex);
    }

    @Override
    public final V getIfPresent(K key) {
        int hash = this.hashCoder.applyAsInt(key) & this.mask;
        Object[] collisions = this.getBucket.apply(hash);
        int index = 0;
        do {
            Object val;
            if ((val = COLLISIONS.getOpaque(collisions, index)) == null) {
                return null;
            }
            if (!this.isValForKey.test(key, val)) continue;
            this.counters.increment((hash << this.maxCollisionsShift) + index);
            return (V)val;
        } while (++index < collisions.length);
        return null;
    }

    @Override
    public final V replace(K key, V val) {
        if (val == null) {
            throw new NullPointerException("Cannot cache a null val.");
        }
        Object[] collisions = this.getBucket.apply(this.hashCoder.applyAsInt(key) & this.mask);
        int index = 0;
        do {
            Object collision;
            if ((collision = COLLISIONS.getOpaque(collisions, index)) == null) {
                return null;
            }
            if (collision == val) {
                return val;
            }
            if (!this.isValForKey.test(key, collision)) continue;
            Object witness = COLLISIONS.compareAndExchange(collisions, index, collision, val);
            if (witness == collision) {
                return val;
            }
            if (!this.isValForKey.test(key, witness)) continue;
            return (V)witness;
        } while (++index < collisions.length);
        return null;
    }

    @Override
    public void clear() {
        IntStream.range(0, this.hashTable.length).parallel().forEach(i -> {
            Object[] collisions = this.hashTable[i];
            if (collisions == null) {
                return;
            }
            int index = 0;
            do {
                COLLISIONS.setOpaque(collisions, index++, null);
            } while (index < collisions.length);
        });
    }

    public String toString() {
        return "CollisionCache{valueType=" + this.valueType + ", maxCollisions=" + (1 << this.maxCollisionsShift) + ", hashTableLength=" + this.hashTable.length + ", counters=" + this.counters + "}";
    }
}

