/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.collision.cache;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.ThreadLocalRandom;

public final class AtomicLogCounters {
    static final int MAX_COUNT = 255;
    private static final VarHandle COUNTERS = MethodHandles.arrayElementVarHandle(byte[].class);
    private final byte[] counters;
    private final byte initialCount;
    private final double[] thresholds;

    private AtomicLogCounters(byte[] counters, int initialCount, double[] thresholds) {
        this.counters = counters;
        this.initialCount = (byte)initialCount;
        this.thresholds = thresholds;
    }

    public static AtomicLogCounters create(int numCounters, int initialCount, int maxCounterVal) {
        int pow2LogFactor = AtomicLogCounters.calcLogFactorShift(maxCounterVal);
        byte[] counters = new byte[numCounters];
        double[] thresholds = new double[255];
        thresholds[0] = 1.0;
        for (int i = 1; i < 255; ++i) {
            thresholds[i] = 1.0 / (double)((long)i << pow2LogFactor);
        }
        return new AtomicLogCounters(counters, initialCount, thresholds);
    }

    private static int calcLogFactorShift(int maxCount) {
        return Integer.numberOfTrailingZeros(Integer.highestOneBit(maxCount - 1) >> 14);
    }

    public int getNumCounters() {
        return this.counters.length;
    }

    public void initializeOpaque(int index) {
        COUNTERS.setOpaque(this.counters, index, this.initialCount);
    }

    public void setOpaque(int index, int initialCount) {
        COUNTERS.setOpaque(this.counters, index, (byte)initialCount);
    }

    public int getOpaque(int index) {
        return COUNTERS.getOpaque(this.counters, index) & 0xFF;
    }

    public void increment(int index) {
        int expected;
        int witness = COUNTERS.getOpaque(this.counters, index);
        int count = witness & 0xFF;
        if (count == 255) {
            return;
        }
        while (count <= this.initialCount) {
            expected = witness;
            if (expected != (witness = COUNTERS.compareAndExchange(this.counters, index, (byte)expected, (byte)(count + 1))) && (count = witness & 0xFF) != 255) continue;
            return;
        }
        if (this.thresholds[count] < (double)ThreadLocalRandom.current().nextFloat()) {
            return;
        }
        while ((expected = witness) != (witness = COUNTERS.compareAndExchange(this.counters, index, (byte)expected, (byte)(count + 1))) && (count = witness & 0xFF) != 255) {
        }
    }

    void decay(int from, int to, int skip) {
        this.decay(from, skip);
        this.decay(skip + 1, to);
    }

    void decay(int from, int to) {
        for (int counterIndex = from; counterIndex < to; ++counterIndex) {
            int count = COUNTERS.getOpaque(this.counters, counterIndex) & 0xFF;
            if (count == 0) continue;
            COUNTERS.setOpaque(this.counters, counterIndex, (byte)(count >> 1));
        }
    }

    public String toString() {
        return "AtomicLogCounters{numCounters=" + this.counters.length + ", initialCount=" + this.initialCount + "}";
    }
}

