/*
 * Decompiled with CFR 0.152.
 */
package sy.iyad.idlib.Roots;

import java.util.Locale;
import sy.iyad.idlib.Roots.ScanException;

class Scanner {
    private final String line;
    private int pos = 0;
    private char c;
    private StringBuilder text;

    Scanner(String line) {
        this.line = line;
        this.nextChar();
    }

    Token next() throws ScanException {
        this.text = null;
        switch (this.c) {
            case '\n': {
                return Token.EOL;
            }
            case '\t': 
            case ' ': {
                return this.whiteSpace();
            }
            case ',': {
                this.nextChar();
                return Token.COMMA;
            }
            case '/': {
                this.nextChar();
                return Token.SLASH;
            }
            case '<': {
                this.nextChar();
                return Token.LESS;
            }
            case '>': {
                this.nextChar();
                return Token.MORE;
            }
            case '=': {
                this.nextChar();
                return Token.EQUALS;
            }
            case '(': {
                this.nextChar();
                return Token.LEFT_BRACKET;
            }
            case ')': {
                this.nextChar();
                return Token.RIGHT_BRACKET;
            }
            case '!': {
                return this.pipe();
            }
            case '\"': {
                return this.quotedText('\"');
            }
            case '\'': {
                return this.quotedText('\'');
            }
        }
        return this.name();
    }

    String text() {
        if (this.text != null) {
            return this.text.toString();
        }
        return "";
    }

    int pos() {
        return this.pos;
    }

    private Token name() throws ScanException {
        String val;
        this.text = new StringBuilder();
        while (!this.in(this.c, "[ \t\r\n=<>!)]")) {
            this.text.append(this.c);
            this.nextChar();
        }
        switch (val = this.text.toString().toLowerCase(Locale.getDefault())) {
            case "where": {
                return Token.WHERE;
            }
            case "not": {
                return Token.NOT;
            }
            case "and": {
                return Token.AND;
            }
            case "or": {
                return Token.OR;
            }
            case "return": {
                return Token.RETURN;
            }
        }
        return Token.TEXT;
    }

    private Token quotedText(char quote) throws ScanException {
        this.nextChar();
        this.text = new StringBuilder();
        while (this.c != quote) {
            if (this.c == '\n') {
                throw new ScanException("Unclosed quoted text, reached end of line.");
            }
            this.text.append(this.c);
            this.nextChar();
        }
        this.nextChar();
        return Token.TEXT;
    }

    private Token pipe() {
        this.nextChar();
        if (this.c == '=') {
            this.nextChar();
            return Token.NOT_EQUALS;
        }
        return Token.PIPE;
    }

    private Token whiteSpace() {
        while (this.c == ' ' || this.c == '\t') {
            this.nextChar();
        }
        return Token.WS;
    }

    private void nextChar() {
        if (this.pos < this.line.length()) {
            this.c = this.line.charAt(this.pos);
            ++this.pos;
        } else {
            this.c = (char)10;
        }
    }

    private boolean in(char c, String cs) {
        return ("" + c).matches(cs);
    }

    static enum Token {
        SLASH("/"),
        COMMA(","),
        EOL,
        WS,
        TEXT,
        LESS("<"),
        MORE(">"),
        EQUALS("="),
        NOT_EQUALS("!="),
        PIPE("!"),
        LEFT_BRACKET("("),
        RIGHT_BRACKET(")"),
        WHERE,
        NOT,
        AND,
        OR,
        RETURN;

        private final String symb;

        public String toString() {
            return this.symb == null ? this.name() : this.symb;
        }

        private Token(String symb) {
            this.symb = symb;
        }

        private Token() {
            this.symb = null;
        }
    }
}

