/*
 * Decompiled with CFR 0.152.
 */
package suryagaddipati.codeclimate;

import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.FilesParser;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.tasks.Shell;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import suryagaddipati.codeclimate.CodeClimateResult;
import suryagaddipati.codeclimate.CodeClimateResultAction;
import suryagaddipati.codeclimate.CodeClimateResultParser;

public class CodeClimatePublisher
extends HealthAwarePublisher {
    private static final String DEFAULT_FILE_NAME = "code-climate-result.json";
    private String resultFile;

    @DataBoundConstructor
    public CodeClimatePublisher() {
        super("CODECLIMATE");
    }

    protected boolean perform(Run<?, ?> build, FilePath workspace, Launcher launcher, PluginLogger logger) throws IOException, InterruptedException {
        try {
            String codeClimateCommand = "docker run   --interactive  --rm    --env CODE_PATH=\"$PWD\"   --volume \"$PWD\":/code   --volume /var/run/docker.sock:/var/run/docker.sock   --volume /tmp/cc:/tmp/cc   codeclimate/codeclimate analyze -f json> code-climate-result.json";
            Shell execution = new Shell("#!/bin/bash  -ex \n" + codeClimateCommand);
            execution.perform((AbstractBuild)build, launcher, launcher.getListener());
            FilesParser parser = new FilesParser("CODE_CLIMATE", StringUtils.defaultIfEmpty((String)this.getResultFile(), (String)DEFAULT_FILE_NAME), (AnnotationParser)new CodeClimateResultParser(this.getDefaultEncoding()), false, false);
            ParserResult project = (ParserResult)((AbstractBuild)build).getWorkspace().act((FilePath.FileCallable)parser);
            CodeClimateResult result = new CodeClimateResult(build, this.getDefaultEncoding(), project, this.usePreviousBuildAsReference(), this.useOnlyStableBuildsAsReference());
            build.addAction((Action)new CodeClimateResultAction(build, (HealthDescriptor)this, result));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public MatrixAggregator createAggregator(MatrixBuild matrixBuild, Launcher launcher, BuildListener buildListener) {
        return null;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    @DataBoundSetter
    public void setResultFile(String resultFile) {
        this.resultFile = resultFile;
    }
}

