/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.Debug;

public class TimeThread
extends DirectoryThread {
    private static final String CLASS_NAME = "org.opends.server.util.TimeThread";
    private static final TimeThread threadInstance = new TimeThread();
    private static GregorianCalendar calendar;
    private static CopyOnWriteArrayList<SimpleDateFormat> userDefinedFormatters;
    private static ConcurrentHashMap<String, String> userDefinedTimeStrings;
    private static Date date;
    private static int hourAndMinute;
    private static long time;
    private static SimpleDateFormat generalizedTimeFormatter;
    private static SimpleDateFormat localTimestampFormatter;
    private static SimpleDateFormat utcTimestampFormatter;
    private static String generalizedTime;
    private static String localTimestamp;
    private static String utcTimestamp;

    private TimeThread() {
        super("Time Thread");
        this.setDaemon(true);
        userDefinedFormatters = new CopyOnWriteArrayList();
        userDefinedTimeStrings = new ConcurrentHashMap();
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        generalizedTimeFormatter = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        generalizedTimeFormatter.setTimeZone(timeZone);
        utcTimestampFormatter = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        utcTimestampFormatter.setTimeZone(timeZone);
        localTimestampFormatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
        calendar = new GregorianCalendar();
        date = calendar.getTime();
        time = date.getTime();
        generalizedTime = generalizedTimeFormatter.format(date);
        localTimestamp = localTimestampFormatter.format(date);
        utcTimestamp = utcTimestampFormatter.format(date);
        hourAndMinute = calendar.get(11) * 100 + calendar.get(12);
        this.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    calendar = new GregorianCalendar();
                    date = calendar.getTime();
                    time = date.getTime();
                    generalizedTime = generalizedTimeFormatter.format(date);
                    localTimestamp = localTimestampFormatter.format(date);
                    utcTimestamp = utcTimestampFormatter.format(date);
                    hourAndMinute = calendar.get(11) * 100 + calendar.get(12);
                    for (SimpleDateFormat simpleDateFormat : userDefinedFormatters) {
                        userDefinedTimeStrings.put(simpleDateFormat.toPattern(), simpleDateFormat.format(date));
                    }
                    Thread.sleep(200L);
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) continue;
                throw new AssertionError();
            }
            break;
        }
    }

    public static Calendar getCalendar() {
        return calendar;
    }

    public static Date getDate() {
        return date;
    }

    public static long getTime() {
        return time;
    }

    public static String getGeneralizedTime() {
        return generalizedTime;
    }

    public static String getLocalTime() {
        return localTimestamp;
    }

    public static String getUTCTime() {
        return utcTimestamp;
    }

    public static int getHourAndMinute() {
        return hourAndMinute;
    }

    public static String getUserDefinedTime(String string) throws IllegalArgumentException {
        String string2 = userDefinedTimeStrings.get(string);
        if (string2 == null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            string2 = simpleDateFormat.format(date);
            userDefinedTimeStrings.put(string, string2);
            userDefinedFormatters.add(simpleDateFormat);
        }
        return string2;
    }

    public static void removeUserDefinedFormatter(String string) {
        Iterator<SimpleDateFormat> iterator = userDefinedFormatters.iterator();
        while (iterator.hasNext()) {
            SimpleDateFormat simpleDateFormat = iterator.next();
            if (!simpleDateFormat.toPattern().equals(string)) continue;
            iterator.remove();
        }
        userDefinedTimeStrings.remove(string);
    }
}

