/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClassType;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectClass {
    private static final String CLASS_NAME = "org.opends.server.types.ObjectClass";
    private boolean isObsolete;
    private ConcurrentHashMap<String, CopyOnWriteArrayList<String>> extraProperties;
    private ConcurrentHashMap<String, String> names;
    private CopyOnWriteArraySet<AttributeType> optionalAttributes;
    private CopyOnWriteArraySet<AttributeType> requiredAttributes;
    private ObjectClass superiorClass;
    private ObjectClassType objectClassType;
    private String description;
    private String oid;
    private String primaryName;
    private String schemaFile;

    public ObjectClass(String string, ConcurrentHashMap<String, String> concurrentHashMap, String string2, String string3, ObjectClass objectClass, CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet, CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet2, ObjectClassType objectClassType, boolean bl, ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(concurrentHashMap), String.valueOf(string2), String.valueOf(string3), String.valueOf(objectClass), String.valueOf(copyOnWriteArraySet), String.valueOf(copyOnWriteArraySet2), String.valueOf((Object)objectClassType), String.valueOf(bl), String.valueOf(concurrentHashMap2)));
        this.primaryName = string;
        this.names = concurrentHashMap;
        this.oid = string2;
        this.description = string3;
        this.superiorClass = objectClass;
        this.requiredAttributes = copyOnWriteArraySet;
        this.optionalAttributes = copyOnWriteArraySet2;
        this.objectClassType = objectClassType;
        this.isObsolete = bl;
        this.schemaFile = null;
        this.extraProperties = concurrentHashMap2;
    }

    public String getPrimaryName() {
        assert (Debug.debugEnter(CLASS_NAME, "getPrimaryName", new String[0]));
        return this.primaryName;
    }

    public void setPrimaryName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setPrimaryName", String.valueOf(string)));
        this.primaryName = string;
        String string2 = StaticUtils.toLowerCase(string);
        this.names.put(string2, string);
    }

    public ConcurrentHashMap<String, String> getNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getNames", new String[0]));
        return this.names;
    }

    public void setNames(ConcurrentHashMap<String, String> concurrentHashMap) {
        assert (Debug.debugEnter(CLASS_NAME, "setNames", String.valueOf(concurrentHashMap)));
        this.names = concurrentHashMap;
    }

    public boolean hasName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasName", String.valueOf(string)));
        return this.names.containsKey(string);
    }

    public void addName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "addName", String.valueOf(string)));
        String string2 = StaticUtils.toLowerCase(string);
        this.names.put(string2, string);
    }

    public void removeName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "removeName", String.valueOf(string)));
        this.names.remove(string);
        if (string.equalsIgnoreCase(this.primaryName)) {
            this.primaryName = this.names.isEmpty() ? null : this.names.values().iterator().next();
        }
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public void setOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setOID", String.valueOf(string)));
        this.oid = string;
    }

    public String getNameOrOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameOrOID", new String[0]));
        if (this.primaryName == null) {
            return this.oid;
        }
        return this.primaryName;
    }

    public boolean hasNameOrOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasNameOrOID", String.valueOf(string)));
        if (this.names.containsKey(string)) {
            return true;
        }
        return string.equals(this.oid);
    }

    public String getSchemaFile() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaFile", new String[0]));
        return this.schemaFile;
    }

    public void setSchemaFile(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setSchemaFile", String.valueOf(string)));
        this.schemaFile = string;
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public void setDescription(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setDescription", String.valueOf(string)));
        this.description = string;
    }

    public ObjectClass getSuperiorClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getSuperiorClass", new String[0]));
        return this.superiorClass;
    }

    public void setSuperiorClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "setSuperiorClass", String.valueOf(objectClass)));
        this.superiorClass = objectClass;
    }

    public boolean isDescendantOf(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "isDescendantOf", String.valueOf(objectClass)));
        if (this.superiorClass == null) {
            return false;
        }
        return this.superiorClass.equals(objectClass) || this.superiorClass.isDescendantOf(objectClass);
    }

    public CopyOnWriteArraySet<AttributeType> getRequiredAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequiredAttributes", new String[0]));
        return this.requiredAttributes;
    }

    public Set<AttributeType> getRequiredAttributeChain() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequiredAttributeChain", new String[0]));
        if (this.superiorClass == null) {
            return this.requiredAttributes;
        }
        HashSet<AttributeType> hashSet = new HashSet<AttributeType>();
        hashSet.addAll(this.requiredAttributes);
        hashSet.addAll(this.superiorClass.getRequiredAttributeChain());
        return hashSet;
    }

    public boolean isRequired(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequired", String.valueOf(attributeType)));
        if (this.requiredAttributes.contains(attributeType)) {
            return true;
        }
        if (this.superiorClass != null) {
            return this.superiorClass.isRequired(attributeType);
        }
        return false;
    }

    public void setRequiredAttributes(CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setRequiredAttributes", String.valueOf(copyOnWriteArraySet)));
        this.requiredAttributes = copyOnWriteArraySet;
    }

    public void addRequiredAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addRequiredAttribute", String.valueOf(attributeType)));
        this.requiredAttributes.add(attributeType);
    }

    public void removeRequiredAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "removeRequiredAttribute", String.valueOf(attributeType)));
        this.requiredAttributes.remove(attributeType);
    }

    public CopyOnWriteArraySet<AttributeType> getOptionalAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getOptionalAttributes", new String[0]));
        return this.optionalAttributes;
    }

    public Set<AttributeType> getOptionalAttributeChain() {
        assert (Debug.debugEnter(CLASS_NAME, "getOptionalAttributeChain", new String[0]));
        if (this.superiorClass == null) {
            return this.optionalAttributes;
        }
        HashSet<AttributeType> hashSet = new HashSet<AttributeType>();
        hashSet.addAll(this.optionalAttributes);
        hashSet.addAll(this.superiorClass.getOptionalAttributeChain());
        return hashSet;
    }

    public boolean isOptional(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isOptional", String.valueOf(attributeType)));
        if (this.optionalAttributes.contains(attributeType)) {
            return true;
        }
        if (this.isExtensibleObject() && !this.requiredAttributes.contains(attributeType)) {
            return true;
        }
        if (this.superiorClass != null) {
            return this.superiorClass.isOptional(attributeType);
        }
        return false;
    }

    public void setOptionalAttributes(CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setOptionalAttributes", String.valueOf(copyOnWriteArraySet)));
        this.optionalAttributes = copyOnWriteArraySet;
    }

    public void addOptionalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addOptionalAttribute", String.valueOf(attributeType)));
        this.optionalAttributes.add(attributeType);
    }

    public void removeOptionalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "removeOptionalAttribute", String.valueOf(attributeType)));
        this.optionalAttributes.remove(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequiredOrOptional", String.valueOf(attributeType)));
        if (this.requiredAttributes.contains(attributeType) || this.optionalAttributes.contains(attributeType)) {
            return true;
        }
        if (this.isExtensibleObject()) {
            return true;
        }
        if (this.superiorClass != null) {
            return this.superiorClass.isRequiredOrOptional(attributeType);
        }
        return false;
    }

    public ObjectClassType getObjectClassType() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClassType", new String[0]));
        return this.objectClassType;
    }

    public void setObjectClassType(ObjectClassType objectClassType) {
        assert (Debug.debugEnter(CLASS_NAME, "setObjectClassType", String.valueOf((Object)objectClassType)));
    }

    public boolean isObsolete() {
        assert (Debug.debugEnter(CLASS_NAME, "isObsolete", new String[0]));
        return this.isObsolete;
    }

    public void setObsolete(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setObsolete", String.valueOf(bl)));
        this.isObsolete = bl;
    }

    public boolean isExtensibleObject() {
        assert (Debug.debugEnter(CLASS_NAME, "isExtensibleObject", new String[0]));
        return this.names.containsKey("extensibleobject") || this.oid.equals("1.3.6.1.4.1.1466.101.120.111");
    }

    public ConcurrentHashMap<String, CopyOnWriteArrayList<String>> getExtraProperties() {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperties", new String[0]));
        return this.extraProperties;
    }

    public CopyOnWriteArrayList<String> getExtraProperty(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperty", String.valueOf(string)));
        return this.extraProperties.get(string);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ObjectClass)) {
            return false;
        }
        return this.oid.equals(((ObjectClass)object).oid);
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = this.oid.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.oid.charAt(i);
        }
        return n2;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        String string2;
        Iterator<Object> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(bl)));
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.values().iterator();
            string2 = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(" NAME ( '");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append("' '");
                    stringBuilder.append((String)iterator.next());
                }
                stringBuilder.append("' )");
            } else {
                stringBuilder.append(" NAME '");
                stringBuilder.append(string2);
                stringBuilder.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            stringBuilder.append(" DESC '");
            stringBuilder.append(this.description);
            stringBuilder.append("'");
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        if (this.superiorClass != null) {
            stringBuilder.append(" SUP ");
            stringBuilder.append(this.superiorClass.getNameOrOID());
        }
        if (this.objectClassType != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.objectClassType.toString());
        }
        if (!this.requiredAttributes.isEmpty()) {
            iterator = this.requiredAttributes.iterator();
            string2 = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" MUST ( ");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" MUST ");
                stringBuilder.append(string2);
            }
        }
        if (!this.optionalAttributes.isEmpty()) {
            iterator = this.optionalAttributes.iterator();
            string2 = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" MAY ( ");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" MAY ");
                stringBuilder.append(string2);
            }
        }
        if (!this.extraProperties.isEmpty()) {
            for (String string2 : this.extraProperties.keySet()) {
                CopyOnWriteArrayList<String> copyOnWriteArrayList = this.extraProperties.get(string2);
                stringBuilder.append(" ");
                stringBuilder.append(string2);
                if (copyOnWriteArrayList.size() == 1) {
                    stringBuilder.append(" '");
                    stringBuilder.append(copyOnWriteArrayList.get(0));
                    stringBuilder.append("'");
                    continue;
                }
                stringBuilder.append(" ( ");
                for (String string3 : copyOnWriteArrayList) {
                    stringBuilder.append("'");
                    stringBuilder.append(string3);
                    stringBuilder.append("' ");
                }
                stringBuilder.append(")");
            }
        }
        if (bl && this.schemaFile != null && !this.extraProperties.containsKey("X-SCHEMA-FILE")) {
            stringBuilder.append(" ");
            stringBuilder.append("X-SCHEMA-FILE");
            stringBuilder.append(" '");
            stringBuilder.append(this.schemaFile);
            stringBuilder.append("'");
        }
        stringBuilder.append(" )");
    }
}

