/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DITContentRule {
    private static final String CLASS_NAME = "org.opends.server.types.DITContentRule";
    private boolean isObsolete;
    private ConcurrentHashMap<String, CopyOnWriteArrayList<String>> extraProperties;
    private ConcurrentHashMap<String, String> names;
    private CopyOnWriteArraySet<ObjectClass> auxiliaryClasses;
    private CopyOnWriteArraySet<AttributeType> optionalAttributes;
    private CopyOnWriteArraySet<AttributeType> prohibitedAttributes;
    private CopyOnWriteArraySet<AttributeType> requiredAttributes;
    private ObjectClass structuralClass;
    private String description;
    private String schemaFile;

    public DITContentRule(ObjectClass objectClass, ConcurrentHashMap<String, String> concurrentHashMap, String string, CopyOnWriteArraySet<ObjectClass> copyOnWriteArraySet, CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet2, CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet3, CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet4, boolean bl, ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(objectClass), String.valueOf(concurrentHashMap), String.valueOf(string), String.valueOf(copyOnWriteArraySet), String.valueOf(copyOnWriteArraySet2), String.valueOf(copyOnWriteArraySet3), String.valueOf(copyOnWriteArraySet4), String.valueOf(bl), String.valueOf(concurrentHashMap2)));
        this.structuralClass = objectClass;
        this.names = concurrentHashMap;
        this.description = string;
        this.auxiliaryClasses = copyOnWriteArraySet;
        this.requiredAttributes = copyOnWriteArraySet2;
        this.optionalAttributes = copyOnWriteArraySet3;
        this.prohibitedAttributes = copyOnWriteArraySet4;
        this.isObsolete = bl;
        this.schemaFile = null;
        this.extraProperties = concurrentHashMap2;
    }

    public ObjectClass getStructuralClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getStructuralClass", new String[0]));
        return this.structuralClass;
    }

    public void setStructuralClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "setStructuralClass", String.valueOf(objectClass)));
        this.structuralClass = objectClass;
    }

    public ConcurrentHashMap<String, String> getNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getNames", new String[0]));
        return this.names;
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        if (this.names.isEmpty()) {
            return null;
        }
        return this.names.values().iterator().next();
    }

    public void setNames(ConcurrentHashMap<String, String> concurrentHashMap) {
        assert (Debug.debugEnter(CLASS_NAME, "setNames", String.valueOf(concurrentHashMap)));
        this.names = concurrentHashMap;
    }

    public boolean hasName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasName", String.valueOf(string)));
        return this.names.containsKey(string);
    }

    public void addName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "addName", String.valueOf(string)));
        String string2 = StaticUtils.toLowerCase(string);
        this.names.put(string2, string);
    }

    public void removeName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "removeName", String.valueOf(string)));
        this.names.remove(string);
    }

    public String getSchemaFile() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaFile", new String[0]));
        return this.schemaFile;
    }

    public void setSchemaFile(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setSchemaFile", String.valueOf(string)));
        this.schemaFile = string;
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public void setDescription(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setDescription", String.valueOf(string)));
        this.description = string;
    }

    public CopyOnWriteArraySet<ObjectClass> getAuxiliaryClasses() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuxiliaryClasses", new String[0]));
        return this.auxiliaryClasses;
    }

    public void setAuxiliaryClasses(CopyOnWriteArraySet<ObjectClass> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuxiliaryClasses", String.valueOf(copyOnWriteArraySet)));
        this.auxiliaryClasses = copyOnWriteArraySet;
    }

    public void addAuxiliaryClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "addAuxiliaryClass", String.valueOf(objectClass)));
        this.auxiliaryClasses.add(objectClass);
    }

    public void removeAuxiliaryClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "removeAuxiliaryClass", String.valueOf(objectClass)));
        this.auxiliaryClasses.remove(objectClass);
    }

    public boolean isAllowedAuxiliaryClass(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "isAllowedAuxiliaryClass", new String[0]));
        return this.auxiliaryClasses.contains(objectClass);
    }

    public CopyOnWriteArraySet<AttributeType> getRequiredAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequiredAttributes", new String[0]));
        return this.requiredAttributes;
    }

    public boolean isRequired(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequired", String.valueOf(attributeType)));
        return this.requiredAttributes.contains(attributeType);
    }

    public void setRequiredAttributes(CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setRequiredAttributes", String.valueOf(copyOnWriteArraySet)));
        this.requiredAttributes = copyOnWriteArraySet;
    }

    public void addRequiredAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addRequiredAttribute", String.valueOf(attributeType)));
        this.requiredAttributes.add(attributeType);
    }

    public void removeRequiredAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "removeRequiredAttribute", String.valueOf(attributeType)));
        this.requiredAttributes.remove(attributeType);
    }

    public CopyOnWriteArraySet<AttributeType> getOptionalAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getOptionalAttributes", new String[0]));
        return this.optionalAttributes;
    }

    public boolean isOptional(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isOptional", String.valueOf(attributeType)));
        return this.optionalAttributes.contains(attributeType);
    }

    public void setOptionalAttributes(CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setOptionalAttributes", String.valueOf(copyOnWriteArraySet)));
        this.optionalAttributes = copyOnWriteArraySet;
    }

    public void addOptionalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addOptionalAttribute", String.valueOf(attributeType)));
        this.optionalAttributes.add(attributeType);
    }

    public void removeOptionalAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "removeOptionalAttribute", String.valueOf(attributeType)));
        this.optionalAttributes.remove(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequiredOrOptional", String.valueOf(attributeType)));
        return this.requiredAttributes.contains(attributeType) || this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "isRequiredOrOptional", String.valueOf(attributeType)));
        if (bl && (this.requiredAttributes.isEmpty() || this.optionalAttributes.isEmpty())) {
            return true;
        }
        return this.requiredAttributes.contains(attributeType) || this.optionalAttributes.contains(attributeType);
    }

    public CopyOnWriteArraySet<AttributeType> getProhibitedAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getProhibitedAttributes", new String[0]));
        return this.prohibitedAttributes;
    }

    public boolean isProhibited(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "isProhibited", String.valueOf(attributeType)));
        return this.prohibitedAttributes.contains(attributeType);
    }

    public void setProhibitedAttributes(CopyOnWriteArraySet<AttributeType> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setProhibitedAttributes", String.valueOf(copyOnWriteArraySet)));
        this.prohibitedAttributes = copyOnWriteArraySet;
    }

    public void addProhibitedAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "addProhibitedAttribute", String.valueOf(attributeType)));
        this.prohibitedAttributes.add(attributeType);
    }

    public void removeProhibitedAttribute(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "removeProhibitedAttribute", String.valueOf(attributeType)));
        this.prohibitedAttributes.remove(attributeType);
    }

    public boolean isObsolete() {
        assert (Debug.debugEnter(CLASS_NAME, "isObsolete", new String[0]));
        return this.isObsolete;
    }

    public void setObsolete(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setObsolete", String.valueOf(bl)));
        this.isObsolete = bl;
    }

    public ConcurrentHashMap<String, CopyOnWriteArrayList<String>> getExtraProperties() {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperties", new String[0]));
        return this.extraProperties;
    }

    public CopyOnWriteArrayList<String> getExtraProperty(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperty", String.valueOf(string)));
        return this.extraProperties.get(string);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DITContentRule)) {
            return false;
        }
        DITContentRule dITContentRule = (DITContentRule)object;
        if (!this.structuralClass.equals(dITContentRule.structuralClass)) {
            return false;
        }
        if (this.names.size() != dITContentRule.names.size()) {
            return false;
        }
        Iterator iterator = this.names.keySet().iterator();
        while (iterator.hasNext()) {
            if (dITContentRule.names.containsKey(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.structuralClass.hashCode();
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        String string2;
        Iterator<Object> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(bl)));
        stringBuilder.append("( ");
        stringBuilder.append(this.structuralClass.getOID());
        if (!this.names.isEmpty()) {
            iterator = this.names.values().iterator();
            string2 = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(" NAME ( '");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append("' '");
                    stringBuilder.append((String)iterator.next());
                }
                stringBuilder.append("' )");
            } else {
                stringBuilder.append(" NAME '");
                stringBuilder.append(string2);
                stringBuilder.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            stringBuilder.append(" DESC '");
            stringBuilder.append(this.description);
            stringBuilder.append("'");
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        if (!this.auxiliaryClasses.isEmpty()) {
            iterator = this.auxiliaryClasses.iterator();
            string2 = ((ObjectClass)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" AUX (");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(iterator.next());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" AUX ");
                stringBuilder.append(string2);
            }
        }
        if (!this.requiredAttributes.isEmpty()) {
            iterator = this.requiredAttributes.iterator();
            string2 = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" MUST ( ");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" MUST ");
                stringBuilder.append(string2);
            }
        }
        if (!this.optionalAttributes.isEmpty()) {
            iterator = this.optionalAttributes.iterator();
            string2 = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" MAY ( ");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" MAY ");
                stringBuilder.append(string2);
            }
        }
        if (!this.prohibitedAttributes.isEmpty()) {
            iterator = this.prohibitedAttributes.iterator();
            string2 = ((AttributeType)iterator.next()).getNameOrOID();
            if (iterator.hasNext()) {
                stringBuilder.append(" NOT ( ");
                stringBuilder.append(string2);
                while (iterator.hasNext()) {
                    stringBuilder.append(" $ ");
                    stringBuilder.append(((AttributeType)iterator.next()).getNameOrOID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" NOT ");
                stringBuilder.append(string2);
            }
        }
        if (!this.extraProperties.isEmpty()) {
            for (String string2 : this.extraProperties.keySet()) {
                CopyOnWriteArrayList<String> copyOnWriteArrayList = this.extraProperties.get(string2);
                stringBuilder.append(" ");
                stringBuilder.append(string2);
                if (copyOnWriteArrayList.size() == 1) {
                    stringBuilder.append(" '");
                    stringBuilder.append(copyOnWriteArrayList.get(0));
                    stringBuilder.append("'");
                    continue;
                }
                stringBuilder.append(" ( ");
                for (String string3 : copyOnWriteArrayList) {
                    stringBuilder.append("'");
                    stringBuilder.append(string3);
                    stringBuilder.append("' ");
                }
                stringBuilder.append(")");
            }
        }
        if (bl && this.schemaFile != null && !this.extraProperties.containsKey("X-SCHEMA-FILE")) {
            stringBuilder.append(" ");
            stringBuilder.append("X-SCHEMA-FILE");
            stringBuilder.append(" '");
            stringBuilder.append(this.schemaFile);
            stringBuilder.append("'");
        }
        stringBuilder.append(" )");
    }
}

