/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Comparator;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeValueComparator
implements Comparator<AttributeValue> {
    private static final String CLASS_NAME = "org.opends.server.types.AttributeValueComparator";
    private AttributeType attributeType;
    private OrderingMatchingRule matchingRule;

    public AttributeValueComparator(AttributeType attributeType) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType)));
        this.attributeType = attributeType;
        this.matchingRule = attributeType.getOrderingMatchingRule();
    }

    @Override
    public int compare(AttributeValue attributeValue, AttributeValue attributeValue2) {
        assert (Debug.debugEnter(CLASS_NAME, "compare", String.valueOf(attributeValue), String.valueOf(attributeValue2)));
        try {
            if (this.matchingRule == null) {
                return AttributeValueComparator.compareValues(attributeValue.getNormalizedValue(), attributeValue2.getNormalizedValue());
            }
            return this.matchingRule.compare(attributeValue.getNormalizedValueBytes(), attributeValue2.getNormalizedValueBytes());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "compare", exception));
            return AttributeValueComparator.compareValues(attributeValue.getValue(), attributeValue2.getValue());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int compareValues(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "compareValues", String.valueOf(byteString), String.valueOf(byteString2)));
        byte[] byArray = byteString.value();
        byte[] byArray2 = byteString2.value();
        int n = 0;
        while (true) {
            if (n < byArray.length) {
                if (n >= byArray2.length) return 1;
                int n2 = byArray[n] - byArray2[n];
                if (n2 != 0) {
                    return n2;
                }
            } else {
                if (n >= byArray2.length) return 0;
                return -1;
            }
            ++n;
        }
    }
}

