/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute {
    private static final String CLASS_NAME = "org.opends.server.types.Attribute";
    private AttributeType attributeType;
    private LinkedHashSet<AttributeValue> values;
    private LinkedHashSet<String> options;
    private String name;

    public Attribute(AttributeType attributeType) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType)));
        this.attributeType = attributeType;
        this.name = attributeType.getPrimaryName();
        this.options = new LinkedHashSet(0);
        this.values = new LinkedHashSet();
    }

    public Attribute(AttributeType attributeType, String string) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType), String.valueOf(string)));
        this.attributeType = attributeType;
        this.name = string;
        this.options = new LinkedHashSet(0);
        this.values = new LinkedHashSet();
    }

    public Attribute(AttributeType attributeType, String string, LinkedHashSet<AttributeValue> linkedHashSet) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType), String.valueOf(string), String.valueOf(linkedHashSet)));
        this.attributeType = attributeType;
        this.name = string;
        this.options = new LinkedHashSet(0);
        this.values = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
    }

    public Attribute(String string, String string2) {
        this.attributeType = DirectoryServer.getAttributeType(string, true);
        this.name = string;
        this.values = new LinkedHashSet();
        this.values.add(new AttributeValue(this.attributeType, string2));
        this.options = new LinkedHashSet(0);
    }

    public Attribute(AttributeType attributeType, String string, LinkedHashSet<String> linkedHashSet, LinkedHashSet<AttributeValue> linkedHashSet2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType), String.valueOf(string), String.valueOf(linkedHashSet), String.valueOf(linkedHashSet2)));
        this.attributeType = attributeType;
        this.name = string;
        this.options = linkedHashSet == null ? new LinkedHashSet(0) : linkedHashSet;
        this.values = linkedHashSet2 == null ? new LinkedHashSet() : linkedHashSet2;
    }

    public AttributeType getAttributeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", new String[0]));
        return this.attributeType;
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return this.name;
    }

    public LinkedHashSet<String> getOptions() {
        assert (Debug.debugEnter(CLASS_NAME, "getOptions", new String[0]));
        return this.options;
    }

    public boolean hasOption(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasOption", String.valueOf(string)));
        return this.options.contains(string);
    }

    public boolean hasOptions() {
        assert (Debug.debugEnter(CLASS_NAME, "hasOptions", new String[0]));
        return this.options != null && !this.options.isEmpty();
    }

    public boolean hasOptions(Collection<String> collection) {
        assert (Debug.debugEnter(CLASS_NAME, "hasOptions", String.valueOf(collection)));
        if (collection == null) {
            return true;
        }
        for (String string : collection) {
            if (this.options.contains(string)) continue;
            return false;
        }
        return true;
    }

    public boolean optionsEqual(Set<String> set) {
        assert (Debug.debugEnter(CLASS_NAME, "optionsEqual", String.valueOf(set)));
        if (set == null) {
            return this.options == null || this.options.isEmpty();
        }
        if (set.isEmpty() && this.options.isEmpty()) {
            return true;
        }
        if (set.size() != this.options.size()) {
            return false;
        }
        for (String string : set) {
            if (this.options.contains(string)) continue;
            return false;
        }
        return true;
    }

    public LinkedHashSet<AttributeValue> getValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getValues", new String[0]));
        return this.values;
    }

    public void setValues(LinkedHashSet<AttributeValue> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "setValues", String.valueOf(linkedHashSet)));
        this.values = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
    }

    public boolean hasValue() {
        assert (Debug.debugEnter(CLASS_NAME, "hasValue", new String[0]));
        return !this.values.isEmpty();
    }

    public boolean hasValue(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "hasValue", String.valueOf(attributeValue)));
        return this.values.contains(attributeValue);
    }

    public boolean hasAllValues(Collection<AttributeValue> collection) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAllValues", String.valueOf(collection)));
        for (AttributeValue attributeValue : collection) {
            if (this.values.contains(attributeValue)) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyValue(Collection<AttributeValue> collection) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAnyValue", String.valueOf(collection)));
        for (AttributeValue attributeValue : collection) {
            if (!this.values.contains(attributeValue)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public ConditionResult matchesSubstring(ByteString byteString, List<ByteString> list, ByteString byteString2) {
        void var8_12;
        Object object;
        ArrayList<ByteString> arrayList;
        ByteString byteString3;
        assert (Debug.debugEnter(CLASS_NAME, "matchesSubstring", String.valueOf(byteString), String.valueOf(list), String.valueOf(byteString2)));
        SubstringMatchingRule substringMatchingRule = this.attributeType.getSubstringMatchingRule();
        if (substringMatchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        if (byteString == null) {
            byteString3 = null;
        } else {
            try {
                byteString3 = substringMatchingRule.normalizeSubstring(byteString);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "matchesSubstring", exception));
                return ConditionResult.UNDEFINED;
            }
        }
        if (list == null) {
            arrayList = null;
        } else {
            arrayList = new ArrayList<ByteString>(list.size());
            for (ByteString object22 : list) {
                try {
                    arrayList.add(substringMatchingRule.normalizeSubstring(object22));
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "matchesSubstring", exception));
                    return ConditionResult.UNDEFINED;
                }
            }
        }
        if (byteString2 == null) {
            object = null;
        } else {
            try {
                object = substringMatchingRule.normalizeSubstring(byteString2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "matchesSubstring", exception));
                return ConditionResult.UNDEFINED;
            }
        }
        ConditionResult conditionResult = ConditionResult.FALSE;
        for (AttributeValue attributeValue : this.values) {
            try {
                if (!substringMatchingRule.valueMatchesSubstring(attributeValue.getNormalizedValue(), byteString3, arrayList, (ByteString)object)) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "matchesSubstring", exception));
                ConditionResult conditionResult2 = ConditionResult.UNDEFINED;
            }
        }
        return var8_12;
    }

    public ConditionResult greaterThanOrEqualTo(AttributeValue attributeValue) {
        ByteString byteString;
        assert (Debug.debugEnter(CLASS_NAME, "greaterThanOrEqualTo", String.valueOf(attributeValue)));
        OrderingMatchingRule orderingMatchingRule = this.attributeType.getOrderingMatchingRule();
        if (orderingMatchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            byteString = attributeValue.getNormalizedValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "greaterThanOrEqualTo", exception));
            return ConditionResult.UNDEFINED;
        }
        ConditionResult conditionResult = ConditionResult.FALSE;
        for (AttributeValue attributeValue2 : this.values) {
            try {
                ByteString byteString2 = attributeValue2.getNormalizedValue();
                int n = orderingMatchingRule.compareValues(byteString2, byteString);
                if (n < 0) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "greaterThanOrEqualTo", exception));
                conditionResult = ConditionResult.UNDEFINED;
            }
        }
        return conditionResult;
    }

    public ConditionResult lessThanOrEqualTo(AttributeValue attributeValue) {
        ByteString byteString;
        assert (Debug.debugEnter(CLASS_NAME, "lessThanOrEqualTo", String.valueOf(attributeValue)));
        OrderingMatchingRule orderingMatchingRule = this.attributeType.getOrderingMatchingRule();
        if (orderingMatchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            byteString = attributeValue.getNormalizedValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "lessThanOrEqualTo", exception));
            return ConditionResult.UNDEFINED;
        }
        ConditionResult conditionResult = ConditionResult.FALSE;
        for (AttributeValue attributeValue2 : this.values) {
            try {
                ByteString byteString2 = attributeValue2.getNormalizedValue();
                int n = orderingMatchingRule.compareValues(byteString2, byteString);
                if (n > 0) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "lessThanOrEqualTo", exception));
                conditionResult = ConditionResult.UNDEFINED;
            }
        }
        return conditionResult;
    }

    public ConditionResult approximatelyEqualTo(AttributeValue attributeValue) {
        ByteString byteString;
        assert (Debug.debugEnter(CLASS_NAME, "approximatelyEqualTo", String.valueOf(attributeValue)));
        ApproximateMatchingRule approximateMatchingRule = this.attributeType.getApproximateMatchingRule();
        if (approximateMatchingRule == null) {
            return ConditionResult.UNDEFINED;
        }
        try {
            byteString = attributeValue.getNormalizedValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "approximatelyEqualTo", exception));
            return ConditionResult.UNDEFINED;
        }
        ConditionResult conditionResult = ConditionResult.FALSE;
        for (AttributeValue attributeValue2 : this.values) {
            try {
                ByteString byteString2 = attributeValue2.getNormalizedValue();
                if (!approximateMatchingRule.approximatelyMatch(byteString2, byteString)) continue;
                return ConditionResult.TRUE;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "approximatelyEqualTo", exception));
                conditionResult = ConditionResult.UNDEFINED;
            }
        }
        return conditionResult;
    }

    public Attribute duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.options.size());
        for (String object : this.options) {
            linkedHashSet.add(object);
        }
        LinkedHashSet linkedHashSet2 = new LinkedHashSet(this.values.size());
        for (AttributeValue attributeValue : this.values) {
            linkedHashSet2.add(attributeValue);
        }
        return new Attribute(this.attributeType, this.name, linkedHashSet, linkedHashSet2);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        if (!this.attributeType.equals(attribute.attributeType)) {
            return false;
        }
        if (this.values.size() != attribute.values.size()) {
            return false;
        }
        if (!this.hasAllValues(attribute.values)) {
            return false;
        }
        return this.optionsEqual(attribute.options);
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = this.attributeType.hashCode();
        for (AttributeValue attributeValue : this.values) {
            n += attributeValue.hashCode();
        }
        return n;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("Attribute(");
        stringBuilder.append(this.name);
        stringBuilder.append(", {");
        boolean bl = true;
        for (AttributeValue attributeValue : this.values) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            attributeValue.toString(stringBuilder);
            bl = false;
        }
        stringBuilder.append("})");
    }

    public String toLDIF() {
        assert (Debug.debugEnter(CLASS_NAME, "toLDIF", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toLDIF(stringBuilder);
        return stringBuilder.toString();
    }

    public void toLDIF(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toLDIF", "java.lang.StringBuilder"));
        for (AttributeValue attributeValue : this.values) {
            stringBuilder.append(this.name);
            if (StaticUtils.needsBase64Encoding(attributeValue.getValueBytes())) {
                stringBuilder.append("::");
                stringBuilder.append(Base64.encode(attributeValue.getValueBytes()));
            } else {
                stringBuilder.append(": ");
                stringBuilder.append(attributeValue.getStringValue());
            }
            stringBuilder.append(ServerConstants.EOL);
        }
    }
}

