/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEntry {
    private Branch branch;
    private DN dn;
    private DN parentDN;
    private LinkedHashMap<AttributeType, ArrayList<TemplateValue>> attributes;
    private Template template;

    public TemplateEntry(Branch branch) {
        this.branch = branch;
        this.dn = branch.getBranchDN();
        this.template = null;
        this.parentDN = null;
        this.attributes = new LinkedHashMap();
    }

    public TemplateEntry(Template template, DN dN) {
        this.template = template;
        this.parentDN = dN;
        this.dn = null;
        this.branch = null;
        this.attributes = new LinkedHashMap();
    }

    public Branch getBranch() {
        return this.branch;
    }

    public Template getTemplate() {
        return this.template;
    }

    public DN getParentDN() {
        return this.parentDN;
    }

    public DN getDN() {
        if (this.dn == null) {
            RDN[] rDNArray;
            AttributeType[] attributeTypeArray = this.template.getRDNAttributes();
            String[] stringArray = new String[attributeTypeArray.length];
            AttributeValue[] attributeValueArray = new AttributeValue[attributeTypeArray.length];
            for (int i = 0; i < attributeTypeArray.length; ++i) {
                rDNArray = this.getValue(attributeTypeArray[i]);
                if (rDNArray == null) {
                    return null;
                }
                stringArray[i] = attributeTypeArray[i].getNameOrOID();
                attributeValueArray[i] = new AttributeValue(attributeTypeArray[i], rDNArray.getValue().toString());
            }
            RDN[] rDNArray2 = this.parentDN.getRDNComponents();
            rDNArray = new RDN[rDNArray2.length + 1];
            rDNArray[0] = new RDN(attributeTypeArray, stringArray, attributeValueArray);
            System.arraycopy(rDNArray2, 0, rDNArray, 1, rDNArray2.length);
            this.dn = new DN(rDNArray);
        }
        return this.dn;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        return this.attributes.containsKey(attributeType);
    }

    public TemplateValue getValue(AttributeType attributeType) {
        ArrayList<TemplateValue> arrayList = this.attributes.get(attributeType);
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        return arrayList.get(0);
    }

    public List<TemplateValue> getValues(AttributeType attributeType) {
        ArrayList<TemplateValue> arrayList = this.attributes.get(attributeType);
        return arrayList;
    }

    public void addValue(TemplateValue templateValue) {
        ArrayList<TemplateValue> arrayList = this.attributes.get(templateValue.getAttributeType());
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(templateValue);
            this.attributes.put(templateValue.getAttributeType(), arrayList);
        } else {
            arrayList.add(templateValue);
        }
    }

    public Entry toEntry() {
        LinkedHashMap<ObjectClass, String> linkedHashMap = new LinkedHashMap<ObjectClass, String>();
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap2 = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> linkedHashMap3 = new LinkedHashMap<AttributeType, List<Attribute>>();
        for (AttributeType attributeType : this.attributes.keySet()) {
            LinkedHashSet<AttributeValue> linkedHashSet;
            ArrayList<TemplateValue> arrayList2 = this.attributes.get(attributeType);
            if (attributeType.isObjectClassType()) {
                for (TemplateValue templateValue : arrayList2) {
                    String string = StaticUtils.toLowerCase(templateValue.getValue().toString());
                    ObjectClass objectClass = DirectoryServer.getObjectClass(string, true);
                    linkedHashMap.put(objectClass, string);
                }
                continue;
            }
            if (attributeType.isOperational()) {
                linkedHashSet = new LinkedHashSet();
                for (TemplateValue templateValue : arrayList2) {
                    linkedHashSet.add(new AttributeValue(attributeType, templateValue.getValue().toString()));
                }
                ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
                arrayList.add(new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet));
                linkedHashMap3.put(attributeType, arrayList);
                continue;
            }
            linkedHashSet = new LinkedHashSet<AttributeValue>();
            for (TemplateValue templateValue : arrayList2) {
                linkedHashSet.add(new AttributeValue(attributeType, templateValue.getValue().toString()));
            }
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
            arrayList.add(new Attribute(attributeType, attributeType.getNameOrOID(), linkedHashSet));
            linkedHashMap2.put(attributeType, arrayList);
        }
        return new Entry(this.getDN(), linkedHashMap, linkedHashMap2, linkedHashMap3);
    }
}

