/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateLine;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    private AttributeType[] rdnAttributes;
    private int[] numEntriesPerTemplate;
    private String name;
    private String[] subordinateTemplateNames;
    private Template[] subordinateTemplates;
    private TemplateFile templateFile;
    private TemplateLine[] templateLines;

    public Template(TemplateFile templateFile, String string, AttributeType[] attributeTypeArray, String[] stringArray, int[] nArray) {
        this.templateFile = templateFile;
        this.name = string;
        this.rdnAttributes = attributeTypeArray;
        this.subordinateTemplateNames = stringArray;
        this.numEntriesPerTemplate = nArray;
        this.templateLines = new TemplateLine[0];
        this.subordinateTemplates = null;
    }

    public Template(TemplateFile templateFile, String string, AttributeType[] attributeTypeArray, String[] stringArray, int[] nArray, TemplateLine[] templateLineArray) {
        this.templateFile = templateFile;
        this.name = string;
        this.rdnAttributes = attributeTypeArray;
        this.subordinateTemplateNames = stringArray;
        this.numEntriesPerTemplate = nArray;
        this.templateLines = templateLineArray;
        this.subordinateTemplates = null;
    }

    public void completeTemplateInitialization(Map<String, Template> map) throws MakeLDIFException {
        Object object;
        if (this.subordinateTemplateNames == null) {
            this.subordinateTemplateNames = new String[0];
            this.subordinateTemplates = new Template[0];
        } else {
            this.subordinateTemplates = new Template[this.subordinateTemplateNames.length];
            for (int i = 0; i < this.subordinateTemplates.length; ++i) {
                this.subordinateTemplates[i] = map.get(StaticUtils.toLowerCase(this.subordinateTemplateNames[i]));
                if (this.subordinateTemplates[i] != null) continue;
                int n = 10682923;
                String string = MessageHandler.getMessage(n, this.subordinateTemplateNames[i], this.name);
                throw new MakeLDIFException(n, string);
            }
        }
        HashSet<AttributeType> hashSet = new HashSet<AttributeType>(this.rdnAttributes.length);
        for (AttributeType object2 : this.rdnAttributes) {
            hashSet.add(object2);
        }
        Object object3 = this.templateLines;
        int n = ((Object[])object3).length;
        for (int i = 0; !(i >= n || hashSet.remove(((TemplateLine)(object = object3[i])).getAttributeType()) && hashSet.isEmpty()); ++i) {
        }
        if (!hashSet.isEmpty()) {
            object3 = (AttributeType)hashSet.iterator().next();
            n = 10682933;
            String string = MessageHandler.getMessage(n, this.name, ((AttributeType)object3).getNameOrOID());
            throw new MakeLDIFException(n, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public AttributeType[] getRDNAttributes() {
        return this.rdnAttributes;
    }

    public String[] getSubordinateTemplateNames() {
        return this.subordinateTemplateNames;
    }

    public Template[] getSubordinateTemplates() {
        return this.subordinateTemplates;
    }

    public int[] getNumEntriesPerTemplate() {
        return this.numEntriesPerTemplate;
    }

    public TemplateLine[] getTemplateLines() {
        return this.templateLines;
    }

    public void addTemplateLine(TemplateLine templateLine) {
        TemplateLine[] templateLineArray = new TemplateLine[this.templateLines.length + 1];
        System.arraycopy(this.templateLines, 0, templateLineArray, 0, this.templateLines.length);
        templateLineArray[this.templateLines.length] = templateLine;
        this.templateLines = templateLineArray;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        for (TemplateLine templateLine : this.templateLines) {
            if (!templateLine.getAttributeType().equals(attributeType)) continue;
            return true;
        }
        return false;
    }

    public TagResult writeEntries(EntryWriter entryWriter, DN dN, int n) throws IOException, MakeLDIFException {
        for (int i = 0; i < n; ++i) {
            this.templateFile.nextFirstAndLastNames();
            TemplateEntry templateEntry = new TemplateEntry(this, dN);
            for (TemplateLine templateLine : this.templateLines) {
                TagResult tagResult = templateLine.generateLine(templateEntry);
                if (tagResult.keepProcessingEntry() && tagResult.keepProcessingParent() && tagResult.keepProcessingTemplateFile()) continue;
                return tagResult;
            }
            Entry entry = templateEntry.toEntry();
            if (!entryWriter.writeEntry(entry)) {
                return TagResult.STOP_PROCESSING;
            }
            for (int j = 0; j < this.subordinateTemplates.length; ++j) {
                TagResult tagResult = this.subordinateTemplates[j].writeEntries(entryWriter, entry.getDN(), this.numEntriesPerTemplate[j]);
                if (tagResult.keepProcessingParent() && tagResult.keepProcessingTemplateFile()) continue;
                if (tagResult.keepProcessingTemplateFile()) {
                    return TagResult.SUCCESS_RESULT;
                }
                return tagResult;
            }
        }
        return TagResult.SUCCESS_RESULT;
    }
}

