/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.server.controls.PasswordExpiringControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.LDAPAuthenticationHandler;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.types.Control;
import org.opends.server.util.StaticUtils;

public class LDAPConnection {
    private static final String CLASS_NAME = "org.opends.server.tools.LDAPConnection";
    private String hostName = null;
    private int portNumber = 389;
    private LDAPConnectionOptions connectionOptions = null;
    private ASN1Writer asn1Writer;
    private ASN1Reader asn1Reader;
    private int versionNumber = 3;
    private PrintStream out;
    private PrintStream err;

    public LDAPConnection(String string, int n, LDAPConnectionOptions lDAPConnectionOptions) {
        this(string, n, lDAPConnectionOptions, System.out, System.err);
    }

    public LDAPConnection(String string, int n, LDAPConnectionOptions lDAPConnectionOptions, PrintStream printStream, PrintStream printStream2) {
        this.hostName = string;
        this.portNumber = n;
        this.connectionOptions = lDAPConnectionOptions;
        this.versionNumber = lDAPConnectionOptions.getVersionNumber();
        this.out = printStream;
        this.err = printStream2;
    }

    public void connectToHost(String string, String string2) throws LDAPConnectionException {
        this.connectToHost(string, string2, new AtomicInteger(1));
    }

    public void connectToHost(String string, String string2, AtomicInteger atomicInteger) throws LDAPConnectionException {
        Object object;
        Object object2;
        Object object3;
        Socket socket = null;
        Socket socket2 = null;
        int n = -1;
        ArrayList<LDAPControl> arrayList = new ArrayList<LDAPControl>();
        ArrayList<LDAPControl> arrayList2 = new ArrayList<LDAPControl>();
        if (this.connectionOptions.useStartTLS()) {
            try {
                socket2 = new Socket(this.hostName, this.portNumber);
                this.asn1Writer = new ASN1Writer(socket2);
                this.asn1Reader = new ASN1Reader(socket2);
            }
            catch (UnknownHostException unknownHostException) {
                int n2 = 335;
                String string3 = MessageHandler.getMessage(n2);
                throw new LDAPConnectionException(string3, 91, unknownHostException);
            }
            catch (ConnectException connectException) {
                int n3 = 335;
                String string4 = MessageHandler.getMessage(n3);
                throw new LDAPConnectionException(string4, 91, connectException);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "connectToHost", exception));
                throw new LDAPConnectionException(exception.getMessage(), exception);
            }
            object3 = new ExtendedRequestProtocolOp("1.3.6.1.4.1.1466.20037");
            object2 = new LDAPMessage(atomicInteger.getAndIncrement(), (ProtocolOp)object3);
            try {
                this.asn1Writer.writeElement(((LDAPMessage)object2).encode());
                object2 = LDAPMessage.decode(this.asn1Reader.readElement().decodeAsSequence());
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "connectToHost", exception));
                throw new LDAPConnectionException(exception.getMessage(), exception);
            }
            object = ((LDAPMessage)object2).getExtendedResponseProtocolOp();
            n = ((ExtendedResponseProtocolOp)object).getResultCode();
            if (n != 0) {
                String string5 = ((ExtendedResponseProtocolOp)object).getErrorMessage();
                if (string5 == null) {
                    string5 = "Response code:" + n;
                }
                throw new LDAPConnectionException(string5);
            }
        }
        object3 = this.connectionOptions.getSSLConnectionFactory();
        try {
            socket = object3 != null ? (this.connectionOptions.useStartTLS() ? ((SSLConnectionFactory)object3).createSocket(socket2, this.hostName, this.portNumber, true) : ((SSLConnectionFactory)object3).createSocket(this.hostName, this.portNumber)) : new Socket(this.hostName, this.portNumber);
            this.asn1Writer = new ASN1Writer(socket);
            this.asn1Reader = new ASN1Reader(socket);
        }
        catch (UnknownHostException unknownHostException) {
            int n4 = 335;
            String string6 = MessageHandler.getMessage(n4);
            throw new LDAPConnectionException(string6, 91, unknownHostException);
        }
        catch (ConnectException connectException) {
            int n5 = 335;
            String string7 = MessageHandler.getMessage(n5);
            throw new LDAPConnectionException(string7, 91, connectException);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "connectToHost", exception));
            throw new LDAPConnectionException(exception.getMessage(), exception);
        }
        if (this.connectionOptions.getReportAuthzID()) {
            arrayList.add(new LDAPControl("2.16.840.1.113730.3.4.16"));
        }
        if (this.connectionOptions.usePasswordPolicyControl()) {
            arrayList.add(new LDAPControl("1.3.6.1.4.1.42.2.27.8.5.1"));
        }
        object2 = new LDAPAuthenticationHandler(this.asn1Reader, this.asn1Writer, this.hostName, atomicInteger);
        try {
            object = string2 == null ? null : new ASN1OctetString(string2);
            String string8 = null;
            if (this.connectionOptions.useSASLExternal()) {
                string8 = ((LDAPAuthenticationHandler)object2).doSASLExternal(new ASN1OctetString(string), this.connectionOptions.getSASLProperties(), arrayList, arrayList2);
            } else if (this.connectionOptions.getSASLMechanism() != null) {
                string8 = ((LDAPAuthenticationHandler)object2).doSASLBind(new ASN1OctetString(string), (ASN1OctetString)object, this.connectionOptions.getSASLMechanism(), this.connectionOptions.getSASLProperties(), arrayList, arrayList2);
            } else if (string != null) {
                string8 = ((LDAPAuthenticationHandler)object2).doSimpleBind(this.versionNumber, new ASN1OctetString(string), (ASN1OctetString)object, arrayList, arrayList2);
            }
            if (string8 != null) {
                this.out.println(string8);
            }
            for (LDAPControl lDAPControl : arrayList2) {
                PasswordPolicyWarningType passwordPolicyWarningType;
                String string9;
                Object object4;
                if (lDAPControl.getOID().equals("2.16.840.1.113730.3.4.15")) {
                    object4 = lDAPControl.getValue();
                    if (object4 == null) continue;
                    int n6 = 10486122;
                    String string10 = MessageHandler.getMessage(n6, ((ASN1OctetString)object4).stringValue());
                    this.out.println(string10);
                    continue;
                }
                if (lDAPControl.getOID().equals("2.16.840.1.113730.3.4.4")) {
                    int n7 = 10486166;
                    String string11 = MessageHandler.getMessage(n7);
                    this.out.println(string11);
                    continue;
                }
                if (lDAPControl.getOID().equals("2.16.840.1.113730.3.4.5")) {
                    object4 = PasswordExpiringControl.decodeControl(new Control(lDAPControl.getOID(), lDAPControl.isCritical(), lDAPControl.getValue()));
                    String string12 = StaticUtils.secondsToTimeString(((PasswordExpiringControl)object4).getSecondsUntilExpiration());
                    int n8 = 10486167;
                    string9 = MessageHandler.getMessage(n8, string12);
                    this.out.println(string9);
                    continue;
                }
                if (!lDAPControl.getOID().equals("1.3.6.1.4.1.42.2.27.8.5.1")) continue;
                object4 = PasswordPolicyResponseControl.decodeControl(new Control(lDAPControl.getOID(), lDAPControl.isCritical(), lDAPControl.getValue()));
                PasswordPolicyErrorType passwordPolicyErrorType = ((PasswordPolicyResponseControl)object4).getErrorType();
                if (passwordPolicyErrorType != null) {
                    switch (passwordPolicyErrorType) {
                        case PASSWORD_EXPIRED: {
                            int n9 = 10486166;
                            string9 = MessageHandler.getMessage(n9);
                            this.out.println(string9);
                            break;
                        }
                        case ACCOUNT_LOCKED: {
                            int n10 = 10486168;
                            string9 = MessageHandler.getMessage(n10);
                            this.out.println(string9);
                            break;
                        }
                        case CHANGE_AFTER_RESET: {
                            int n11 = 10486169;
                            string9 = MessageHandler.getMessage(n11);
                            this.out.println(string9);
                        }
                    }
                }
                if ((passwordPolicyWarningType = ((PasswordPolicyResponseControl)object4).getWarningType()) == null) continue;
                switch (passwordPolicyWarningType) {
                    case TIME_BEFORE_EXPIRATION: {
                        string9 = StaticUtils.secondsToTimeString(((PasswordPolicyResponseControl)object4).getWarningValue());
                        int n12 = 10486167;
                        String string13 = MessageHandler.getMessage(n12, string9);
                        this.out.println(string13);
                        break;
                    }
                    case GRACE_LOGINS_REMAINING: {
                        int n12 = 10486170;
                        String string13 = MessageHandler.getMessage(n12, ((PasswordPolicyResponseControl)object4).getWarningValue());
                        this.out.println(string13);
                    }
                }
            }
        }
        catch (ClientException clientException) {
            assert (Debug.debugException(CLASS_NAME, "connectToHost", clientException));
            throw new LDAPConnectionException(clientException.getMessage(), clientException.getExitCode(), clientException);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "connectToHost", exception));
            throw new LDAPConnectionException(exception.getMessage(), exception);
        }
    }

    public void close() {
        if (this.asn1Writer != null) {
            this.asn1Writer.close();
        }
        if (this.asn1Reader != null) {
            this.asn1Reader.close();
        }
    }

    public ASN1Writer getASN1Writer() {
        return this.asn1Writer;
    }

    public ASN1Reader getASN1Reader() {
        return this.asn1Reader;
    }
}

