/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import org.opends.server.config.ConfigFileHandler;
import org.opends.server.core.DirectoryServer;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.ConfigureDS;
import org.opends.server.tools.ImportLDIF;
import org.opends.server.types.DN;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

public class InstallDS {
    private static final String CLASS_NAME = "org.opends.server.tools.InstallDS";
    public static final int MAX_LINE_WIDTH = 79;
    private static boolean isWindows = false;
    private static String versionString = "OpenDS Directory Service";
    private static String programName = "setup";

    public static void main(String[] stringArray) {
        int n = InstallDS.installMain(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int installMain(String[] stringArray) {
        String string10;
        String[] stringArray2;
        int n;
        String string2;
        LinkedList<DN> linkedList;
        String[] stringArray3;
        int n2;
        boolean bl;
        LinkedList<String> linkedList2;
        LinkedList<DN> linkedList3;
        BooleanArgument booleanArgument;
        FileBasedArgument fileBasedArgument;
        StringArgument stringArgument;
        StringArgument stringArgument2;
        BooleanArgument booleanArgument2;
        IntegerArgument integerArgument;
        StringArgument stringArgument3;
        BooleanArgument booleanArgument3;
        StringArgument stringArgument4;
        BooleanArgument booleanArgument4;
        StringArgument stringArgument5;
        StringArgument stringArgument6;
        BooleanArgument booleanArgument5;
        String string3 = System.getProperty("os.name");
        if (string3 != null && string3.toLowerCase().indexOf("windows") >= 0) {
            isWindows = true;
        }
        versionString = "OpenDS Directory Server 0.1";
        versionString = "" == null || "".length() == 0 ? versionString + ".0" : versionString + "";
        programName = isWindows ? "setup.bat" : "setup.sh";
        ArgumentParser argumentParser = new ArgumentParser(CLASS_NAME, false);
        try {
            booleanArgument5 = new BooleanArgument("test", Character.valueOf('t'), "testOnly", 10486245, new Object[0]);
            booleanArgument5.setHidden(true);
            argumentParser.addArgument(booleanArgument5);
            StringArgument stringArgument7 = new StringArgument("progname", Character.valueOf('P'), "programName", false, false, true, "{programName}", programName, null, 10486246, new Object[0]);
            stringArgument7.setHidden(true);
            argumentParser.addArgument(stringArgument7);
            stringArgument6 = new StringArgument("configfile", Character.valueOf('c'), "configFile", false, false, true, "{configFile}", null, null, 10486247, new Object[0]);
            argumentParser.addArgument(stringArgument6);
            stringArgument5 = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 10486248, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            booleanArgument4 = new BooleanArgument("silent", Character.valueOf('s'), "silentInstall", 10486249, new Object[0]);
            argumentParser.addArgument(booleanArgument4);
            stringArgument4 = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, "{baseDN}", "dc=example,dc=com", null, 10486250, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            booleanArgument3 = new BooleanArgument("addbase", Character.valueOf('a'), "addBaseEntry", 10486251, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            stringArgument3 = new StringArgument("importldif", Character.valueOf('i'), "importLDIF", false, true, true, "{ldifFile}", null, null, 10486252, new Object[0]);
            argumentParser.addArgument(stringArgument3);
            integerArgument = new IntegerArgument("ldapport", Character.valueOf('p'), "ldapPort", false, false, true, "{port}", 389, null, true, 1, true, 65535, 10486253, new Object[0]);
            argumentParser.addArgument(integerArgument);
            booleanArgument2 = new BooleanArgument("skipportcheck", Character.valueOf('S'), "skipPortCheck", 10486254, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            stringArgument2 = new StringArgument("rootdn", Character.valueOf('D'), "rootUserDN", false, true, true, "{rootDN}", "cn=Directory Manager", null, 10486255, new Object[0]);
            argumentParser.addArgument(stringArgument2);
            stringArgument = new StringArgument("rootpwstring", Character.valueOf('w'), "rootUserPassword", false, false, true, "{password}", null, null, 10486256, new Object[0]);
            argumentParser.addArgument(stringArgument);
            fileBasedArgument = new FileBasedArgument("rootpwfile", Character.valueOf('W'), "rootUserPasswordFile", false, false, "{filename}", null, null, 10486257, new Object[0]);
            argumentParser.addArgument(fileBasedArgument);
            booleanArgument = new BooleanArgument("help", Character.valueOf('H'), "help", 10486258, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            argumentParser.setUsageArgument(booleanArgument);
        }
        catch (ArgumentException argumentException) {
            System.err.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            System.err.println(argumentParser.getUsage());
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            System.err.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
            System.err.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument.isPresent() || booleanArgument5.isPresent()) {
            return 0;
        }
        if (!stringArgument6.isPresent()) {
            int n3 = 10748403;
            String string4 = MessageHandler.getMessage(n3, stringArgument6.getLongIdentifier());
            System.err.println(StaticUtils.wrapText(string4, 79));
            return 1;
        }
        String string5 = stringArgument6.getValue();
        String string6 = stringArgument5.getValue();
        if (!booleanArgument4.isPresent()) {
            System.out.println(versionString);
            System.out.println();
            int n4 = 10486294;
            linkedList3 = MessageHandler.getMessage(n4);
            System.out.println(StaticUtils.wrapText((String)((Object)linkedList3), 79));
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        directoryServer.bootstrapClient();
        try {
            directoryServer.initializeJMX();
        }
        catch (Exception exception) {
            int n5 = 10748404;
            String string7 = MessageHandler.getMessage(n5, String.valueOf(stringArgument6.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string7, 79));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(stringArgument5.getValue(), stringArgument6.getValue());
        }
        catch (Exception exception) {
            int n6 = 10748405;
            String string8 = MessageHandler.getMessage(n6, String.valueOf(stringArgument6.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string8, 79));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (Exception exception) {
            int n7 = 10748406;
            String string9 = MessageHandler.getMessage(n7, String.valueOf(stringArgument6.getValue()), exception.getMessage());
            System.err.println(StaticUtils.wrapText(string9, 79));
            return 1;
        }
        if (stringArgument4.isPresent()) {
            linkedList3 = new LinkedList();
            for (String string10 : stringArgument4.getValues()) {
                try {
                    linkedList3.add(DN.decode(string10));
                }
                catch (Exception exception) {
                    int n8 = 10748407;
                    String string11 = MessageHandler.getMessage(n8, string10, exception.getMessage());
                    System.err.println(StaticUtils.wrapText(string11, 79));
                    return 1;
                }
            }
        } else if (booleanArgument4.isPresent()) {
            try {
                linkedList3 = new LinkedList<DN>();
                linkedList3.add(DN.decode(stringArgument4.getDefaultValue()));
            }
            catch (Exception exception) {
                int n9 = 10748407;
                String string12 = MessageHandler.getMessage(n9, stringArgument4.getDefaultValue(), exception.getMessage());
                System.err.println(StaticUtils.wrapText(string12, 79));
                return 1;
            }
        } else {
            String string10;
            int n10 = 10486264;
            string10 = MessageHandler.getMessage(n10);
            linkedList3 = new LinkedList();
            linkedList3.add(InstallDS.promptForDN(string10, stringArgument4.getDefaultValue()));
        }
        if (booleanArgument4.isPresent()) {
            linkedList2 = stringArgument3.isPresent() ? stringArgument3.getValues() : null;
        } else if (stringArgument3.isPresent()) {
            linkedList2 = stringArgument3.getValues();
        } else if (!stringArgument4.isPresent()) {
            int n11 = 10486265;
            String string13 = MessageHandler.getMessage(n11);
            boolean bl2 = InstallDS.promptForBoolean(string13, false);
            if (bl2) {
                n11 = 10486266;
                string13 = MessageHandler.getMessage(n11);
                linkedList2 = new LinkedList();
                linkedList2.add(InstallDS.promptForString(string13, null));
            } else {
                linkedList2 = null;
            }
        } else {
            linkedList2 = null;
        }
        if (booleanArgument3.isPresent()) {
            bl = true;
            if (linkedList2 != null && !linkedList2.isEmpty()) {
                int n12 = 10748411;
                String string14 = MessageHandler.getMessage(n12, booleanArgument3.getLongIdentifier(), stringArgument3.getLongIdentifier());
                System.err.println(StaticUtils.wrapText(string14, 79));
                return 1;
            }
        } else if (booleanArgument4.isPresent() || linkedList2 != null && !linkedList2.isEmpty()) {
            bl = false;
        } else if (stringArgument4.isPresent()) {
            bl = false;
        } else {
            int n13 = 10486268;
            String string15 = MessageHandler.getMessage(n13, ((DN)linkedList3.getFirst()).toString());
            bl = InstallDS.promptForBoolean(string15, true);
        }
        if (booleanArgument4.isPresent() || integerArgument.isPresent()) {
            try {
                n2 = integerArgument.getIntValue();
            }
            catch (ArgumentException argumentException) {
                System.err.println(StaticUtils.wrapText(argumentException.getMessage(), 79));
                return 1;
            }
        } else {
            while (true) {
                int n14 = 10486269;
                Object object3 = MessageHandler.getMessage(n14);
                n2 = InstallDS.promptForInteger((String)object3, 389, 1, 65535);
                if (booleanArgument2.isPresent()) continue;
                try {
                    InetSocketAddress object22 = new InetSocketAddress(n2);
                    stringArray3 = new ServerSocket();
                    stringArray3.setReuseAddress(true);
                    stringArray3.bind(object22);
                    stringArray3.close();
                }
                catch (Exception exception) {
                    if (n2 <= 1024) {
                        n14 = 10748414;
                        object3 = MessageHandler.getMessage(n14, n2, exception.getMessage());
                        System.err.println(StaticUtils.wrapText((String)object3, 79));
                        continue;
                    }
                    n14 = 10748415;
                    object3 = MessageHandler.getMessage(n14, n2, exception.getMessage());
                    System.err.println(StaticUtils.wrapText((String)object3, 79));
                    continue;
                }
                break;
            }
        }
        if (stringArgument2.isPresent()) {
            linkedList = new LinkedList<DN>();
            for (String n18 : stringArgument2.getValues()) {
                try {
                    linkedList.add(DN.decode(n18));
                }
                catch (Exception exception) {
                    int n3 = 10748407;
                    String string4 = MessageHandler.getMessage(n3, n18, exception.getMessage());
                    System.err.println(StaticUtils.wrapText(string4, 79));
                    return 1;
                }
            }
        } else if (booleanArgument4.isPresent()) {
            linkedList = new LinkedList();
            try {
                linkedList.add(DN.decode(stringArgument2.getDefaultValue()));
            }
            catch (Exception exception) {
                int n19 = 10748407;
                stringArray3 = MessageHandler.getMessage(n19, stringArgument2.getDefaultValue(), exception.getMessage());
                System.err.println(StaticUtils.wrapText((String)stringArray3, 79));
                return 1;
            }
        } else {
            int n17 = 0xA00200;
            String n20 = MessageHandler.getMessage(n17);
            linkedList = new LinkedList();
            linkedList.add(InstallDS.promptForDN(n20, stringArgument2.getDefaultValue()));
        }
        if (stringArgument.isPresent()) {
            string2 = stringArgument.getValue();
            if (fileBasedArgument.isPresent()) {
                int arrayList = 10748411;
                stringArray3 = MessageHandler.getMessage(arrayList, stringArgument.getLongIdentifier(), fileBasedArgument.getLongIdentifier());
                System.err.println(StaticUtils.wrapText((String)stringArray3, 79));
                return 1;
            }
        } else if (fileBasedArgument.isPresent()) {
            string2 = fileBasedArgument.getValue();
        } else {
            if (booleanArgument4.isPresent()) {
                int n4 = 10748417;
                stringArray3 = MessageHandler.getMessage(n4, stringArgument.getLongIdentifier(), fileBasedArgument.getLongIdentifier());
                System.err.println(StaticUtils.wrapText((String)stringArray3, 79));
                return 1;
            }
            int n5 = 0xA00202;
            stringArray3 = MessageHandler.getMessage(n5);
            int n6 = 10486275;
            String string7 = MessageHandler.getMessage(n6);
            string2 = new String(InstallDS.promptForPassword((String)stringArray3, string7));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-C");
        arrayList.add(string6);
        arrayList.add("-c");
        arrayList.add(string5);
        arrayList.add("-p");
        arrayList.add(String.valueOf(n2));
        for (DN dN : linkedList3) {
            arrayList.add("-b");
            arrayList.add(dN.toString());
        }
        for (DN dN : linkedList) {
            arrayList.add("-D");
            arrayList.add(dN.toString());
        }
        arrayList.add("-w");
        arrayList.add(string2);
        stringArray3 = new String[arrayList.size()];
        arrayList.toArray(stringArray3);
        if (!booleanArgument4.isPresent()) {
            System.out.println();
            String string8 = MessageHandler.getMessage(10486276);
            System.out.println(StaticUtils.wrapText(string8, 79));
        }
        if ((n = ConfigureDS.configMain(stringArray3)) != 0) {
            return n;
        }
        if (bl) {
            if (!booleanArgument4.isPresent()) {
                stringArray2 = MessageHandler.getMessage(10486277);
                System.out.println(StaticUtils.wrapText((String)stringArray2, 79));
            }
            try {
                stringArray2 = File.createTempFile("opends-base-entry", ".ldif");
                string10 = stringArray2.getAbsolutePath();
                stringArray2.deleteOnExit();
                LDIFExportConfig lDIFExportConfig = new LDIFExportConfig(string10, ExistingFileBehavior.OVERWRITE);
                LDIFWriter lDIFWriter = new LDIFWriter(lDIFExportConfig);
                for (DN dN : linkedList3) {
                    lDIFWriter.writeEntry(StaticUtils.createEntry(dN));
                }
                lDIFWriter.close();
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList();
                    linkedList2.add(string10);
                }
            }
            catch (Exception exception) {
                int n7 = 10748422;
                String string9 = MessageHandler.getMessage(n7, String.valueOf(exception));
                System.err.println(StaticUtils.wrapText(string9, 79));
                return 1;
            }
        }
        if (linkedList2 != null && !linkedList2.isEmpty()) {
            if (!booleanArgument4.isPresent()) {
                stringArray2 = MessageHandler.getMessage(10486279);
                System.out.println(StaticUtils.wrapText((String)stringArray2, 79));
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add("-C");
            arrayList2.add(string6);
            arrayList2.add("-f");
            arrayList2.add(string5);
            arrayList2.add("-n");
            arrayList2.add("userRoot");
            for (String string10 : linkedList2) {
                arrayList2.add("-l");
                arrayList2.add(string10);
            }
            if (bl) {
                arrayList2.add("-q");
            }
            stringArray2 = new String[arrayList2.size()];
            arrayList2.toArray(stringArray2);
            int n8 = ImportLDIF.mainImportLDIF(stringArray2);
            if (n8 != 0) {
                return n8;
            }
            string10 = MessageHandler.getMessage(10486293);
            System.out.println(StaticUtils.wrapText(string10, 79));
        }
        if (!booleanArgument4.isPresent()) {
            stringArray2 = MessageHandler.getMessage(10486280);
            System.out.println(StaticUtils.wrapText((String)stringArray2, 79));
        }
        return 0;
    }

    private static boolean promptForBoolean(String string, Boolean bl) {
        String string2 = StaticUtils.wrapText(string, 79);
        while (true) {
            String string3;
            System.out.println();
            System.out.println(string2);
            if (bl == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                if (bl.booleanValue()) {
                    System.out.print(MessageHandler.getMessage(10486281));
                } else {
                    System.out.print(MessageHandler.getMessage(0xA0020A));
                }
                System.out.print("]: ");
            }
            System.out.flush();
            String string4 = StaticUtils.toLowerCase(InstallDS.readLine());
            if (string4.equals("true") || string4.equals("yes") || string4.equals("t") || string4.equals("y")) {
                return true;
            }
            if (string4.equals("false") || string4.equals("no") || string4.equals("f") || string4.equals("n")) {
                return false;
            }
            if (string4.equals("")) {
                if (bl == null) {
                    string3 = MessageHandler.getMessage(10682891);
                    System.err.println(StaticUtils.wrapText(string3, 79));
                    continue;
                }
                return bl;
            }
            string3 = MessageHandler.getMessage(10682891);
            System.err.println(StaticUtils.wrapText(string3, 79));
        }
    }

    private static int promptForInteger(String string, Integer n, Integer n2, Integer n3) {
        String string2 = StaticUtils.wrapText(string, 79);
        while (true) {
            String string3;
            System.out.println();
            System.out.println(string2);
            if (n == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                System.out.print(n);
                System.out.print("]: ");
            }
            System.out.flush();
            String string4 = InstallDS.readLine();
            if (string4.equals("")) {
                if (n == null) {
                    String string5 = MessageHandler.getMessage(10682892);
                    System.err.println(StaticUtils.wrapText(string5, 79));
                    continue;
                }
                return n;
            }
            try {
                int n4 = Integer.parseInt(string4);
                if (n2 != null && n4 < n2) {
                    string3 = MessageHandler.getMessage(10682893, n2);
                    System.err.println(StaticUtils.wrapText(string3, 79));
                    continue;
                }
                if (n3 != null && n4 > n3) {
                    string3 = MessageHandler.getMessage(10682894, n3);
                    System.err.println(StaticUtils.wrapText(string3, 79));
                    continue;
                }
                return n4;
            }
            catch (NumberFormatException numberFormatException) {
                string3 = MessageHandler.getMessage(10682892);
                System.err.println(StaticUtils.wrapText(string3, 79));
                continue;
            }
            break;
        }
    }

    private static DN promptForDN(String string, String string2) {
        String string3 = StaticUtils.wrapText(string, 79);
        while (true) {
            String string4;
            System.out.println();
            System.out.println(string3);
            if (string2 == null) {
                System.out.print(": ");
            } else {
                System.out.print("[");
                System.out.print(string2);
                System.out.print("]: ");
            }
            System.out.flush();
            String string5 = InstallDS.readLine();
            if (string5.equals("")) {
                if (string2 == null) {
                    String string6 = MessageHandler.getMessage(10682895);
                    System.err.println(StaticUtils.wrapText(string6, 79));
                    continue;
                }
                try {
                    return DN.decode(string2);
                }
                catch (Exception exception) {
                    string4 = MessageHandler.getMessage(10682895);
                    System.err.println(StaticUtils.wrapText(string4, 79));
                    continue;
                }
            }
            try {
                return DN.decode(string5);
            }
            catch (Exception exception) {
                string4 = MessageHandler.getMessage(10682895);
                System.err.println(StaticUtils.wrapText(string4, 79));
                continue;
            }
            break;
        }
    }

    private static String promptForString(String string, String string2) {
        String string3;
        block3: {
            System.out.println();
            String string4 = StaticUtils.wrapText(string, 79);
            while (true) {
                System.out.println(string4);
                if (string2 == null) {
                    System.out.print(": ");
                } else {
                    System.out.print("[");
                    System.out.print(string2);
                    System.out.print("]: ");
                }
                System.out.flush();
                string3 = InstallDS.readLine();
                if (!string3.equals("")) break block3;
                if (string2 != null) break;
                String string5 = MessageHandler.getMessage(10682896);
                System.err.println(StaticUtils.wrapText(string5, 79));
            }
            return string2;
        }
        return string3;
    }

    private static char[] promptForPassword(String string, String string2) {
        char[] cArray;
        String string3 = StaticUtils.wrapText(string, 79);
        String string4 = StaticUtils.wrapText(string2, 79);
        while (true) {
            Object object;
            System.out.println();
            System.out.print(string3);
            System.out.print(": ");
            System.out.flush();
            cArray = PasswordReader.readPassword();
            if (cArray == null || cArray.length == 0) {
                object = MessageHandler.getMessage(10682897);
                System.err.println(StaticUtils.wrapText((String)object, 79));
                continue;
            }
            System.out.print(string4);
            System.out.print(": ");
            System.out.flush();
            object = PasswordReader.readPassword();
            if (object != null && Arrays.equals(cArray, (char[])object)) break;
            String string5 = MessageHandler.getMessage(10682898);
            System.err.println(StaticUtils.wrapText(string5, 79));
        }
        return cArray;
    }

    private static String readLine() {
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = System.in.read()) >= 0 && n != 10) {
                if (n == 13) {
                    int n2 = System.in.read();
                    if (n2 == 10) break;
                    byteArrayOutputStream.write(n);
                    byteArrayOutputStream.write(n2);
                    continue;
                }
                byteArrayOutputStream.write(n);
            }
            return new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (Exception exception) {
            String string = MessageHandler.getMessage(10682899, String.valueOf(exception));
            System.err.println(StaticUtils.wrapText(string, 79));
            return null;
        }
    }
}

