/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.zip.DataFormatException;
import org.opends.server.core.DirectoryException;
import org.opends.server.synchronization.ServerState;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.synchronization.SynchronizationMessage;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.DN;

public class ServerStartMessage
extends SynchronizationMessage
implements Serializable {
    private static final long serialVersionUID = 8649393307038290287L;
    private short serverId;
    private String serverURL;
    private String baseDn;
    private int maxReceiveQueue;
    private int maxSendQueue;
    private int maxReceiveDelay;
    private int maxSendDelay;
    private ServerState serverState = null;

    public ServerStartMessage(short s, DN dN, int n, int n2, int n3, int n4, ServerState serverState) {
        this.serverId = s;
        this.baseDn = dN.toString();
        this.maxReceiveDelay = n;
        this.maxReceiveQueue = n2;
        this.maxSendDelay = n3;
        this.maxSendQueue = n4;
        this.serverState = serverState;
        try {
            this.serverURL = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this.serverURL = "Unknown host";
        }
    }

    public ServerStartMessage(byte[] byArray) throws DataFormatException {
        try {
            if (byArray[0] != 6) {
                throw new DataFormatException("input is not a valid ServerStart msg");
            }
            int n = 1;
            int n2 = this.getNextLength(byArray, n);
            this.baseDn = new String(byArray, n, n2, "UTF-8");
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            String string = new String(byArray, n, n2, "UTF-8");
            this.serverId = Short.valueOf(string);
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            this.serverURL = new String(byArray, n, n2, "UTF-8");
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            this.maxReceiveDelay = Integer.valueOf(new String(byArray, n, n2, "UTF-8"));
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            this.maxReceiveQueue = Integer.valueOf(new String(byArray, n, n2, "UTF-8"));
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            this.maxSendDelay = Integer.valueOf(new String(byArray, n, n2, "UTF-8"));
            n += n2 + 1;
            n2 = this.getNextLength(byArray, n);
            this.maxSendQueue = Integer.valueOf(new String(byArray, n, n2, "UTF-8"));
            this.serverState = new ServerState(byArray, n += n2 + 1, byArray.length - 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public short getServerId() {
        return this.serverId;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public DN getBaseDn() {
        try {
            return DN.decode(this.baseDn);
        }
        catch (DirectoryException directoryException) {
            return null;
        }
    }

    public int getMaxReceiveDelay() {
        return this.maxReceiveDelay;
    }

    public int getMaxReceiveQueue() {
        return this.maxReceiveQueue;
    }

    public int getMaxSendDelay() {
        return this.maxSendDelay;
    }

    public int getMaxSendQueue() {
        return this.maxSendQueue;
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    public UpdateMessage processReceive(SynchronizationDomain synchronizationDomain) {
        return null;
    }

    public byte[] getBytes() {
        try {
            byte[] byArray = this.baseDn.getBytes("UTF-8");
            byte[] byArray2 = String.valueOf(this.serverId).getBytes("UTF-8");
            byte[] byArray3 = this.serverURL.getBytes("UTF-8");
            byte[] byArray4 = String.valueOf(this.maxReceiveDelay).getBytes("UTF-8");
            byte[] byArray5 = String.valueOf(this.maxReceiveQueue).getBytes("UTF-8");
            byte[] byArray6 = String.valueOf(this.maxSendDelay).getBytes("UTF-8");
            byte[] byArray7 = String.valueOf(this.maxSendQueue).getBytes("UTF-8");
            byte[] byArray8 = this.serverState.getBytes();
            int n = 1 + byArray.length + 1 + byArray2.length + 1 + byArray3.length + 1 + byArray4.length + 1 + byArray5.length + 1 + byArray6.length + 1 + byArray7.length + 1 + byArray8.length + 1;
            byte[] byArray9 = new byte[n];
            byArray9[0] = 6;
            int n2 = 1;
            n2 = this.addByteArray(byArray, byArray9, n2);
            n2 = this.addByteArray(byArray2, byArray9, n2);
            n2 = this.addByteArray(byArray3, byArray9, n2);
            n2 = this.addByteArray(byArray4, byArray9, n2);
            n2 = this.addByteArray(byArray5, byArray9, n2);
            n2 = this.addByteArray(byArray6, byArray9, n2);
            n2 = this.addByteArray(byArray7, byArray9, n2);
            n2 = this.addByteArray(byArray8, byArray9, n2);
            return byArray9;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

